/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.geotools.data.geobuf.Geobuf;
import org.geotools.data.geobuf.GeobufFeatureType;
import org.geotools.data.geobuf.GeobufGeometry;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class GeobufFeature {
    private GeobufGeometry geobufGeometry;

    public GeobufFeature() {
        this(new GeobufGeometry());
    }

    public GeobufFeature(GeobufGeometry geobufGeometry) {
        this.geobufGeometry = geobufGeometry;
    }

    public GeobufGeometry getGeobufGeometry() {
        return this.geobufGeometry;
    }

    public void encode(SimpleFeature feature, OutputStream out) throws IOException {
        Geobuf.Data.Builder dataBuilder = Geobuf.Data.newBuilder();
        for (AttributeDescriptor descriptor : feature.getFeatureType().getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) continue;
            dataBuilder.addKeys(descriptor.getLocalName());
        }
        dataBuilder.setDimensions(this.geobufGeometry.getDimension());
        dataBuilder.setPrecision(this.geobufGeometry.getPrecision());
        dataBuilder.setFeature(this.encode(feature));
        ((Geobuf.Data)dataBuilder.build()).writeTo(out);
    }

    public SimpleFeature decode(InputStream in) throws IOException {
        Geobuf.Data data = Geobuf.Data.parseFrom(in);
        GeobufFeatureType geobufFeatureType = new GeobufFeatureType();
        return this.decode(data, new SimpleFeatureBuilder(geobufFeatureType.getFeatureType("features", data)));
    }

    protected Geobuf.Data.Feature encode(SimpleFeature feature) {
        Geobuf.Data.Feature.Builder featureBuilder = Geobuf.Data.Feature.newBuilder();
        int i = 0;
        for (AttributeDescriptor attributeDescriptor : feature.getFeatureType().getAttributeDescriptors()) {
            Object value = feature.getAttribute(attributeDescriptor.getName());
            if (attributeDescriptor instanceof GeometryDescriptor) {
                featureBuilder.setGeometry(this.geobufGeometry.encode((Geometry)feature.getDefaultGeometry()));
                continue;
            }
            featureBuilder.addValues(i, this.encodeValue(attributeDescriptor, value));
            ++i;
        }
        return (Geobuf.Data.Feature)featureBuilder.build();
    }

    protected Geobuf.Data.Value encodeValue(AttributeDescriptor attributeDescriptor, Object value) {
        Geobuf.Data.Value.Builder builder = Geobuf.Data.Value.newBuilder();
        if (value instanceof String) {
            builder.setStringValue((String)value);
        } else if (value instanceof Integer) {
            builder.setPosIntValue(((Integer)value).intValue());
        } else if (value instanceof Double) {
            builder.setDoubleValue((Double)value);
        } else if (value instanceof Boolean) {
            builder.setBoolValue((Boolean)value);
        } else {
            builder.setStringValue(value != null ? value.toString() : "");
        }
        return (Geobuf.Data.Value)builder.build();
    }

    protected SimpleFeature decode(Geobuf.Data data) throws IOException {
        GeobufFeatureType geobufFeatureType = new GeobufFeatureType();
        return this.decode(data, 0, new SimpleFeatureBuilder(geobufFeatureType.getFeatureType("features", data)));
    }

    protected SimpleFeature decode(Geobuf.Data data, SimpleFeatureBuilder featureBuilder) {
        return this.decode(data, 0, featureBuilder);
    }

    protected SimpleFeature decode(Geobuf.Data data, int index, SimpleFeatureBuilder featureBuilder) {
        block6: {
            block7: {
                block5: {
                    if (data.getDataTypeCase() != Geobuf.Data.DataTypeCase.GEOMETRY) break block5;
                    if (index > 0) {
                        return null;
                    }
                    featureBuilder.set(featureBuilder.getFeatureType().getGeometryDescriptor().getLocalName(), (Object)this.geobufGeometry.decode(data.getGeometry()));
                    break block6;
                }
                if (data.getDataTypeCase() != Geobuf.Data.DataTypeCase.FEATURE) break block7;
                if (index > 0) {
                    return null;
                }
                featureBuilder.set(featureBuilder.getFeatureType().getGeometryDescriptor().getLocalName(), (Object)this.geobufGeometry.decode(data.getFeature().getGeometry()));
                int keyCount = data.getKeysCount();
                for (int j = 0; j < keyCount; ++j) {
                    String key = data.getKeys(j);
                    Object value = this.getValue(data.getFeature().getValues(j));
                    featureBuilder.set(key, value);
                }
                break block6;
            }
            if (data.getDataTypeCase() != Geobuf.Data.DataTypeCase.FEATURE_COLLECTION) break block6;
            if (index >= data.getFeatureCollection().getFeaturesCount()) {
                return null;
            }
            Geobuf.Data.Feature feature = data.getFeatureCollection().getFeatures(index);
            featureBuilder.set(featureBuilder.getFeatureType().getGeometryDescriptor().getLocalName(), (Object)this.geobufGeometry.decode(feature.getGeometry()));
            int keyCount = data.getKeysCount();
            for (int j = 0; j < keyCount; ++j) {
                String key = data.getKeys(j);
                Object value = feature.getValuesCount() > j ? this.getValue(feature.getValues(j)) : null;
                featureBuilder.set(key, value);
            }
        }
        return featureBuilder.buildFeature(String.valueOf(index));
    }

    protected Object getValue(Geobuf.Data.Value value) {
        if (value.getValueTypeCase() == Geobuf.Data.Value.ValueTypeCase.STRING_VALUE) {
            return value.getStringValue();
        }
        if (value.getValueTypeCase() == Geobuf.Data.Value.ValueTypeCase.POS_INT_VALUE) {
            return value.getPosIntValue();
        }
        if (value.getValueTypeCase() == Geobuf.Data.Value.ValueTypeCase.NEG_INT_VALUE) {
            return value.getNegIntValue();
        }
        if (value.getValueTypeCase() == Geobuf.Data.Value.ValueTypeCase.DOUBLE_VALUE) {
            return value.getDoubleValue();
        }
        if (value.getValueTypeCase() == Geobuf.Data.Value.ValueTypeCase.BOOL_VALUE) {
            return value.getBoolValue();
        }
        if (value.getValueTypeCase() == Geobuf.Data.Value.ValueTypeCase.JSON_VALUE) {
            return value.getJsonValue();
        }
        return null;
    }
}

