/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.geobuf.GeobufDataStore;
import org.geotools.data.geobuf.GeobufDirectoryDataStore;
import org.geotools.util.KVP;
import org.geotools.util.logging.Logging;

public class GeobufDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logging.getLogger(GeobufDataStoreFactory.class);
    public static final DataAccessFactory.Param FILE_PARAM = new DataAccessFactory.Param("file", File.class, "The Geobuf file or directory", true, null, (Map)new KVP(new Object[]{"ext", "pbf"}));
    public static final DataAccessFactory.Param PRECISION_PARAM = new DataAccessFactory.Param("precision", Integer.class, "The coordinate preceision", false, (Object)6, (Map)new KVP(new Object[]{"precision", "6"}));
    public static final DataAccessFactory.Param DIMENSION_PARAM = new DataAccessFactory.Param("dimension", Integer.class, "The geometry dimension", false, (Object)2, (Map)new KVP(new Object[]{"precision", "2"}));

    public DataStore createDataStore(Map<String, Serializable> map) throws IOException {
        Integer dimension;
        File file = (File)FILE_PARAM.lookUp(map);
        Integer precision = (Integer)PRECISION_PARAM.lookUp(map);
        if (precision == null) {
            precision = 6;
        }
        if ((dimension = (Integer)DIMENSION_PARAM.lookUp(map)) == null) {
            dimension = 2;
        }
        if (file.isDirectory()) {
            return new GeobufDirectoryDataStore(file, precision, dimension);
        }
        return new GeobufDataStore(file, precision, dimension);
    }

    public DataStore createNewDataStore(Map<String, Serializable> map) throws IOException {
        Integer dimension;
        File file = (File)FILE_PARAM.lookUp(map);
        Integer precision = (Integer)PRECISION_PARAM.lookUp(map);
        if (precision == null) {
            precision = 6;
        }
        if ((dimension = (Integer)DIMENSION_PARAM.lookUp(map)) == null) {
            dimension = 2;
        }
        if (file.isDirectory()) {
            return new GeobufDirectoryDataStore(file, precision, dimension);
        }
        if (file.exists()) {
            LOGGER.warning("File already exists: " + file);
        }
        return new GeobufDataStore(file, precision, dimension);
    }

    public String getDisplayName() {
        return "Geobuf";
    }

    public String getDescription() {
        return "A DataStore for reading and writing Geobuf files";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{FILE_PARAM, PRECISION_PARAM, DIMENSION_PARAM};
    }

    public boolean canProcess(Map<String, Serializable> map) {
        try {
            File file = (File)FILE_PARAM.lookUp(map);
            if (file != null) {
                return file.isDirectory() || file.getPath().toLowerCase().endsWith(".pbf") || file.getPath().toLowerCase().endsWith(".geobuf");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }
}

