/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.geobuf.Geobuf;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class GeobufGeometry {
    private int precision;
    private int dimension;
    private double maxNumberOfDecimalPlaces;
    private GeometryFactory geometryFactory;

    public GeobufGeometry() {
        this(6, 2, JTSFactoryFinder.getGeometryFactory(null));
    }

    public GeobufGeometry(int precision, int dimension) {
        this(precision, dimension, JTSFactoryFinder.getGeometryFactory(null));
    }

    public GeobufGeometry(int precision, int dimension, GeometryFactory geometryFactory) {
        this.precision = precision;
        this.dimension = dimension;
        this.maxNumberOfDecimalPlaces = Math.pow(10.0, precision);
        this.geometryFactory = geometryFactory;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void encode(Geometry geometry, OutputStream out) throws IOException {
        Geobuf.Data.Builder dataBuilder = Geobuf.Data.newBuilder();
        dataBuilder.setDimensions(this.dimension);
        dataBuilder.setPrecision(this.precision);
        Geobuf.Data.Geometry g = this.encode(geometry);
        dataBuilder.setGeometry(g);
        dataBuilder.build().writeTo(out);
    }

    public Geometry decode(InputStream in) throws IOException {
        Geobuf.Data data = Geobuf.Data.parseFrom(in);
        if (data.getDataTypeCase() != Geobuf.Data.DataTypeCase.GEOMETRY) {
            throw new IllegalArgumentException("Geobuf data type is not Geometry!");
        }
        return this.decode(data.getGeometry());
    }

    protected Geobuf.Data.Geometry encode(Geometry geometry) {
        Geobuf.Data.Geometry.Builder builder = Geobuf.Data.Geometry.newBuilder();
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            builder.setType(Geobuf.Data.Geometry.Type.POINT);
            this.addCoords(builder, new Coordinate[]{point.getCoordinate()});
        } else if (geometry instanceof LineString) {
            LineString line = (LineString)geometry;
            builder.setType(Geobuf.Data.Geometry.Type.LINESTRING);
            Coordinate[] coords = line.getCoordinates();
            this.addCoords(builder, coords);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            builder.setType(Geobuf.Data.Geometry.Type.POLYGON);
            Coordinate[] coords = polygon.getCoordinates();
            this.addCoords(builder, coords);
        } else if (geometry instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)geometry;
            builder.setType(Geobuf.Data.Geometry.Type.MULTIPOINT);
            Coordinate[] coords = multiPoint.getCoordinates();
            this.addCoords(builder, coords);
        } else if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            builder.setType(Geobuf.Data.Geometry.Type.MULTILINESTRING);
            for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
                LineString line = (LineString)multiLineString.getGeometryN(i);
                builder.addLengths(line.getCoordinates().length);
                this.addCoords(builder, line.getCoordinates());
            }
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            builder.setType(Geobuf.Data.Geometry.Type.MULTIPOLYGON);
            builder.addLengths(multiPolygon.getNumGeometries());
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
                builder.addLengths(1 + polygon.getNumInteriorRing());
                builder.addLengths(polygon.getExteriorRing().getCoordinates().length);
                this.addCoords(builder, polygon.getExteriorRing().getCoordinates());
                for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
                    LinearRing ring = polygon.getInteriorRingN(j);
                    builder.addLengths(ring.getCoordinates().length);
                    this.addCoords(builder, ring.getCoordinates());
                }
            }
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            builder.setType(Geobuf.Data.Geometry.Type.GEOMETRYCOLLECTION);
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                Geometry geom = geometryCollection.getGeometryN(i);
                builder.addGeometries(this.encode(geom));
            }
        }
        Geobuf.Data.Geometry geom = builder.build();
        return geom;
    }

    private void addCoords(Geobuf.Data.Geometry.Builder builder, Coordinate[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            Coordinate coord = coords[i];
            long x = Math.round(coord.x * this.maxNumberOfDecimalPlaces);
            long y = Math.round(coord.y * this.maxNumberOfDecimalPlaces);
            if (i > 0) {
                Coordinate prevCoord = coords[i - 1];
                x -= Math.round(prevCoord.x * this.maxNumberOfDecimalPlaces);
                y -= Math.round(prevCoord.y * this.maxNumberOfDecimalPlaces);
            }
            builder.addCoords(x).addCoords(y);
        }
    }

    protected Geometry decode(Geobuf.Data.Geometry g) {
        if (g.getType() == Geobuf.Data.Geometry.Type.POINT) {
            return this.geometryFactory.createPoint(this.getAllCoordinates(g)[0]);
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.LINESTRING) {
            return this.geometryFactory.createLineString(this.getAllCoordinates(g));
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.POLYGON) {
            Coordinate[] coords = this.getAllCoordinates(g);
            if (!CoordinateArrays.isRing((Coordinate[])coords)) {
                Coordinate[] closedCoords = new Coordinate[coords.length + 1];
                CoordinateArrays.copyDeep((Coordinate[])coords, (int)0, (Coordinate[])closedCoords, (int)0, (int)coords.length);
                closedCoords[closedCoords.length - 1] = coords[0];
                coords = closedCoords;
            }
            LinearRing shell = this.geometryFactory.createLinearRing(coords);
            LinearRing[] holes = new LinearRing[]{};
            return this.geometryFactory.createPolygon(shell, holes);
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.MULTIPOINT) {
            Coordinate[] coords = this.getAllCoordinates(g);
            return this.geometryFactory.createMultiPoint((CoordinateSequence)new CoordinateArraySequence(coords));
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.MULTILINESTRING) {
            List<Coordinate[]> listOfCoordinates = this.getCoordinates(g);
            LineString[] lines = new LineString[listOfCoordinates.size()];
            for (int i = 0; i < listOfCoordinates.size(); ++i) {
                lines[i] = this.geometryFactory.createLineString(listOfCoordinates.get(i));
            }
            return this.geometryFactory.createMultiLineString(lines);
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.MULTIPOLYGON) {
            int lengthPosition = 0;
            int numberOfPolygons = g.getLengths(lengthPosition);
            ++lengthPosition;
            Polygon[] polygons = new Polygon[numberOfPolygons];
            int start = 0;
            for (int p = 0; p < numberOfPolygons; ++p) {
                int numberOfRings = g.getLengths(lengthPosition);
                ++lengthPosition;
                LinearRing[] rings = new LinearRing[numberOfRings];
                for (int r = 0; r < numberOfRings; ++r) {
                    int numberOfCoordinates = g.getLengths(lengthPosition);
                    ++lengthPosition;
                    int end = start + numberOfCoordinates * this.dimension;
                    Coordinate[] coords = this.getCoordinates(g, start, end);
                    if (!CoordinateArrays.isRing((Coordinate[])coords)) {
                        Coordinate[] closedCoords = new Coordinate[coords.length + 1];
                        CoordinateArrays.copyDeep((Coordinate[])coords, (int)0, (Coordinate[])closedCoords, (int)0, (int)coords.length);
                        closedCoords[closedCoords.length - 1] = coords[0];
                        coords = closedCoords;
                    }
                    rings[r] = this.geometryFactory.createLinearRing(coords);
                    start = end;
                }
                polygons[p] = rings.length > 1 ? this.geometryFactory.createPolygon(rings[0], Arrays.copyOfRange(rings, 1, rings.length)) : this.geometryFactory.createPolygon(rings[0]);
            }
            return this.geometryFactory.createMultiPolygon(polygons);
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.GEOMETRYCOLLECTION) {
            List<Geometry> geoms = this.getGeometries(g);
            return this.geometryFactory.createGeometryCollection(geoms.toArray(new Geometry[0]));
        }
        return null;
    }

    protected List<Geometry> getGeometries(Geobuf.Data.Geometry g) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        this.getGeometries(geometries, g);
        return geometries;
    }

    protected void getGeometries(List<Geometry> geometries, Geobuf.Data.Geometry g) {
        int count = g.getGeometriesCount();
        if (count < 2) {
            geometries.add(this.decode(g));
        } else {
            for (int i = 0; i < count; ++i) {
                this.getGeometries(geometries, g.getGeometries(i));
            }
        }
    }

    protected Coordinate[] getCoordinates(Geobuf.Data.Geometry g, int start, int end) {
        int numberOfCoords = (end - start) / this.dimension;
        Coordinate[] coords = new Coordinate[numberOfCoords];
        int coordinateCounter = 0;
        int c = start;
        for (int i = start; i < start + numberOfCoords; ++i) {
            Coordinate coord = new Coordinate();
            for (int k = 0; k < this.dimension; ++k) {
                double value = g.getCoords(c);
                for (int l = start + k; l < c; l += this.dimension) {
                    value += (double)g.getCoords(l);
                }
                value /= this.maxNumberOfDecimalPlaces;
                if (k == 0) {
                    coord.x = value;
                } else if (k == 1) {
                    coord.y = value;
                } else if (k == 2) {
                    coord.setZ(value);
                }
                ++c;
            }
            coords[coordinateCounter] = coord;
            ++coordinateCounter;
        }
        return coords;
    }

    protected List<Coordinate[]> getCoordinates(Geobuf.Data.Geometry g) {
        ArrayList<Coordinate[]> listOfCoordinates = new ArrayList<Coordinate[]>();
        int numberOfLengths = g.getLengthsCount();
        if (numberOfLengths == 0) {
            listOfCoordinates.add(this.getAllCoordinates(g));
        } else {
            int start = 0;
            for (int i = 0; i < numberOfLengths; ++i) {
                int len = g.getLengths(i);
                int end = start + len * this.dimension;
                Coordinate[] coordinates = this.getCoordinates(g, start, end);
                listOfCoordinates.add(coordinates);
                start = end;
            }
        }
        return listOfCoordinates;
    }

    protected Coordinate[] getAllCoordinates(Geobuf.Data.Geometry g) {
        return this.getCoordinates(g, 0, g.getCoordsCount());
    }
}

