/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.geobuf.GeobufDataStore;
import org.geotools.data.geobuf.GeobufFeatureSource;
import org.geotools.data.geobuf.GeobufFeatureWriter;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class GeobufFeatureStore
extends ContentFeatureStore {
    private int precision = 6;
    private int dimension = 2;
    GeobufFeatureSource delegate = new GeobufFeatureSource(this.entry, this.query, this.precision, this.dimension){

        public void setTransaction(Transaction transaction) {
            super.setTransaction(transaction);
            GeobufFeatureStore.this.setTransaction(transaction);
        }
    };

    public GeobufFeatureStore(ContentEntry entry, Query query, int precision, int dimension) {
        super(entry, query);
        this.precision = precision;
        this.dimension = dimension;
    }

    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    protected GeobufFeatureWriter getWriterInternal(Query query, int flags) throws IOException {
        return new GeobufFeatureWriter(this.getState(), query, this.precision, this.dimension);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCountInternal(query);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return this.delegate.handleVisitor(query, visitor);
    }

    public GeobufDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    public ContentEntry getEntry() {
        return this.delegate.getEntry();
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public ContentState getState() {
        return this.delegate.getState();
    }

    public ResourceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public Name getName() {
        return this.delegate.getName();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }
}

