/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.flatgeobuf.FeatureConversions;
import org.geotools.data.flatgeobuf.FlatGeobufFeatureReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.PackedRTree;

final class ReadFidsIterable
implements Iterable<SimpleFeature> {
    private final SimpleFeatureBuilder fb;
    private final long[] fids;
    private final long[] featureOffsets;
    private final HeaderMeta headerMeta;
    private final LittleEndianDataInputStream data;

    ReadFidsIterable(SimpleFeatureBuilder fb, long[] fids, HeaderMeta headerMeta, LittleEndianDataInputStream data) throws IOException {
        this.fb = fb;
        this.fids = fids;
        this.featureOffsets = PackedRTree.readFeatureOffsets((LittleEndianDataInputStream)data, (long[])fids, (HeaderMeta)headerMeta);
        this.headerMeta = headerMeta;
        this.data = data;
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        IteratorImplementation it = new IteratorImplementation();
        return it;
    }

    private final class IteratorImplementation
    implements Iterator<SimpleFeature> {
        int i = 0;
        long pos = 0L;

        private IteratorImplementation() {
        }

        @Override
        public boolean hasNext() {
            return this.i < ReadFidsIterable.this.featureOffsets.length;
        }

        @Override
        public SimpleFeature next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                long delta = ReadFidsIterable.this.featureOffsets[this.i] - this.pos;
                FlatGeobufFeatureReader.skipNBytes((InputStream)ReadFidsIterable.this.data, delta);
                int featureSize = ReadFidsIterable.this.data.readInt();
                SimpleFeature feature = FeatureConversions.deserialize(ReadFidsIterable.this.data, ReadFidsIterable.this.fb, ReadFidsIterable.this.headerMeta, ReadFidsIterable.this.fids[this.i], featureSize);
                this.pos += delta + 4L + (long)featureSize;
                ++this.i;
                return feature;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

