/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.data.flatgeobuf.FlatGeobufDataStore;
import org.geotools.data.flatgeobuf.FlatGeobufDirectoryDataStore;
import org.geotools.data.store.ContentDataStore;
import org.geotools.util.KVP;

public class FlatGeobufDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param URL_PARAM = new DataAccessFactory.Param("url", URL.class, "The FlatGeobuf file or directory", true, null, (Map)new KVP(new Object[]{"ext", "fgb"}));
    public static final DataAccessFactory.Param NAMESPACE_PARAM = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false, null, (Map)new KVP(new Object[]{"level", "advanced"}));

    public DataStore createDataStore(Map<String, ?> map) throws IOException {
        URL url = (URL)URL_PARAM.lookUp(map);
        URI namespace = (URI)NAMESPACE_PARAM.lookUp(map);
        File file = FlatGeobufDataStore.getFile(url);
        ContentDataStore store = file != null && file.isDirectory() ? new FlatGeobufDirectoryDataStore(file) : new FlatGeobufDataStore(url);
        if (namespace != null) {
            store.setNamespaceURI(namespace.toString());
        }
        return store;
    }

    public DataStore createNewDataStore(Map<String, ?> map) throws IOException {
        return this.createDataStore(map);
    }

    public String getDisplayName() {
        return "FlatGeobuf";
    }

    public String getDescription() {
        return "A DataStore for reading and writing FlatGeobuf files";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URL_PARAM, NAMESPACE_PARAM};
    }

    public boolean canProcess(Map<String, ?> map) {
        try {
            URL url = (URL)URL_PARAM.lookUp(map);
            File file = FlatGeobufDataStore.getFile(url);
            if (file != null) {
                return file.isDirectory() || file.getPath().toLowerCase().endsWith(".fgb");
            }
            return url.toString().endsWith(".fgb");
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }
}

