/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import com.google.flatbuffers.ByteBufferUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.wololo.flatgeobuf.generated.Feature;
import org.wololo.flatgeobuf.geotools.FeatureConversions;
import org.wololo.flatgeobuf.geotools.FeatureTypeConversions;
import org.wololo.flatgeobuf.geotools.HeaderMeta;

public class FlatgeobufReader {
    private final InputStream inputStream;
    private int offset = 0;
    private ByteBuffer byteBuffer;
    private SimpleFeatureType featureType;
    private HeaderMeta headerMeta;
    private String name;
    private String geometryPropertyName;
    private int featureId = 1;

    public FlatgeobufReader(String name, String geometryPropertyName, InputStream inputStream) {
        this.name = name;
        this.geometryPropertyName = geometryPropertyName;
        this.inputStream = inputStream;
    }

    private ByteBuffer getByteBuffer() throws IOException {
        if (this.byteBuffer == null) {
            this.byteBuffer = FlatgeobufReader.toByteBuffer(this.inputStream);
        }
        return this.byteBuffer;
    }

    private static ByteBuffer toByteBuffer(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb;
    }

    public SimpleFeatureType getFeatureType() throws IOException {
        if (this.featureType == null) {
            ByteBuffer bb = this.getByteBuffer();
            this.headerMeta = FeatureTypeConversions.deserialize((ByteBuffer)bb, (String)this.name, (String)this.geometryPropertyName);
            this.offset = this.headerMeta.offset;
            this.featureType = this.headerMeta.featureType;
        }
        return this.featureType;
    }

    public SimpleFeature getNextFeature() throws IOException {
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(this.getFeatureType());
        ByteBuffer bb = this.getByteBuffer();
        if (bb.hasRemaining()) {
            int featureSize = ByteBufferUtil.getSizePrefix((ByteBuffer)bb);
            bb.position(this.offset += 4);
            Feature feature = Feature.getRootAsFeature((ByteBuffer)bb);
            bb.position(this.offset += featureSize);
            SimpleFeature f = FeatureConversions.deserialize((Feature)feature, (SimpleFeatureBuilder)fb, (HeaderMeta)this.headerMeta, (String)String.valueOf(this.featureId++));
            return f;
        }
        return null;
    }
}

