/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.flatgeobuf.FlatgeobufDataStore;
import org.geotools.data.flatgeobuf.FlatgeobufDirectoryDataStore;
import org.geotools.data.flatgeobuf.FlatgeobufFeatureReader;
import org.geotools.data.flatgeobuf.FlatgeobufWriter;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FlatgeobufFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private ContentState state;
    private File temp;
    private FlatgeobufFeatureReader delegate;
    private boolean appending = false;
    private SimpleFeature currentFeature;
    private int nextRow = 0;
    private File file;
    private FlatgeobufWriter writer;
    private OutputStream outputStream;

    public FlatgeobufFeatureWriter(ContentState state, Query query) throws IOException {
        this.state = state;
        String typeName = query.getTypeName();
        ContentDataStore dataStore = state.getEntry().getDataStore();
        this.file = dataStore instanceof FlatgeobufDirectoryDataStore ? ((FlatgeobufDirectoryDataStore)dataStore).getDataStore(typeName).getFile() : ((FlatgeobufDataStore)dataStore).getFile();
        File directory = this.file.getParentFile();
        this.temp = File.createTempFile(typeName + System.currentTimeMillis(), "flatgeobuf", directory);
        this.outputStream = new FileOutputStream(this.temp);
        this.writer = new FlatgeobufWriter(this.outputStream);
        this.writer.writeFeatureType(state.getFeatureType());
        this.delegate = new FlatgeobufFeatureReader(state, query);
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public SimpleFeature next() throws IOException {
        if (this.writer == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        try {
            if (!this.appending) {
                if (this.delegate.hasNext()) {
                    this.currentFeature = this.delegate.next();
                    return this.currentFeature;
                }
                this.appending = true;
            }
            SimpleFeatureType featureType = this.state.getFeatureType();
            String fid = featureType.getTypeName() + "." + this.nextRow;
            Object[] values = DataUtilities.defaultValues((SimpleFeatureType)featureType);
            this.currentFeature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])values, (String)fid);
            return this.currentFeature;
        }
        catch (IllegalArgumentException invalid) {
            throw new IOException("Unable to create feature:" + invalid.getMessage(), invalid);
        }
    }

    public void remove() throws IOException {
        this.currentFeature = null;
    }

    public void write() throws IOException {
        if (this.currentFeature == null) {
            return;
        }
        this.writer.writeFeature(this.currentFeature);
        ++this.nextRow;
        this.currentFeature = null;
    }

    public boolean hasNext() throws IOException {
        if (this.writer == null) {
            return false;
        }
        if (this.appending) {
            return false;
        }
        return this.delegate.hasNext();
    }

    public void close() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer alread closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        while (this.hasNext()) {
            this.next();
            this.write();
        }
        this.outputStream.flush();
        this.outputStream.close();
        this.writer = null;
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
        Files.copy(this.temp.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.temp.delete();
    }
}

