/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.flatgeobuf.FlatgeobufDataStore;
import org.geotools.data.flatgeobuf.FlatgeobufDirectoryDataStore;
import org.geotools.util.KVP;
import org.geotools.util.logging.Logging;

public class FlatgeobufDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logging.getLogger(FlatgeobufDataStoreFactory.class);
    public static final DataAccessFactory.Param FILE_PARAM = new DataAccessFactory.Param("flatgeobuf-file", File.class, "The Flatgeobuf file or directory", true, null, (Map)new KVP(new Object[]{"ext", "fgb"}));

    public DataStore createDataStore(Map<String, Serializable> map) throws IOException {
        File file = (File)FILE_PARAM.lookUp(map);
        if (file.isDirectory()) {
            return new FlatgeobufDirectoryDataStore(file);
        }
        return new FlatgeobufDataStore(file);
    }

    public DataStore createNewDataStore(Map<String, Serializable> map) throws IOException {
        File file = (File)FILE_PARAM.lookUp(map);
        if (file.isDirectory()) {
            return new FlatgeobufDirectoryDataStore(file);
        }
        if (file.exists()) {
            LOGGER.warning("File already exists: " + file);
        }
        return new FlatgeobufDataStore(file);
    }

    public String getDisplayName() {
        return "Flatgeobuf";
    }

    public String getDescription() {
        return "A DataStore for reading and writing Flatgeobuf files";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{FILE_PARAM};
    }

    public boolean canProcess(Map<String, Serializable> map) {
        try {
            File file = (File)FILE_PARAM.lookUp(map);
            if (file != null) {
                return file.isDirectory() || file.getPath().toLowerCase().endsWith(".fgb");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }
}

