/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.flatgeobuf.FlatgeobufFeatureSource;
import org.geotools.data.flatgeobuf.FlatgeobufFeatureStore;
import org.geotools.data.flatgeobuf.FlatgeobufReader;
import org.geotools.data.flatgeobuf.FlatgeobufWriter;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class FlatgeobufDataStore
extends ContentDataStore {
    private File file;

    public FlatgeobufDataStore(File file) {
        this.file = file;
    }

    protected File getFile() {
        return this.file;
    }

    protected List<Name> createTypeNames() throws IOException {
        String name = this.file.getName();
        name = name.substring(0, name.lastIndexOf(46));
        NameImpl typeName = new NameImpl(name);
        return Collections.singletonList(typeName);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        try (FileOutputStream out = new FileOutputStream(this.file);){
            FlatgeobufWriter writer = new FlatgeobufWriter(out);
            writer.writeFeatureType(featureType);
        }
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry contentEntry) throws IOException {
        if (!this.file.exists() || this.file.canWrite()) {
            return new FlatgeobufFeatureStore(contentEntry, Query.ALL);
        }
        return new FlatgeobufFeatureSource(contentEntry, Query.ALL);
    }

    public void removeSchema(Name typeName) throws IOException {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) throws IOException {
        if (!this.file.exists()) {
            throw new IOException("Can't delete " + this.file.getAbsolutePath() + " because it doesn't exist!");
        }
        this.file.delete();
    }

    protected SimpleFeatureType getFeatureType() throws IOException {
        if (this.file.exists()) {
            try (FileInputStream in = new FileInputStream(this.file);){
                String name = this.file.getName();
                name = name.substring(0, name.lastIndexOf(46));
                FlatgeobufReader reader = new FlatgeobufReader(name, "geom", in);
                SimpleFeatureType simpleFeatureType = reader.getFeatureType();
                return simpleFeatureType;
            }
        }
        return null;
    }
}

