/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.flatgeobuf.FeatureConversions;
import org.geotools.data.flatgeobuf.FlatGeobufFeatureReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.PackedRTree;

final class ReadHitsIterable
implements Iterable<SimpleFeature> {
    private final SimpleFeatureBuilder fb;
    private final ArrayList<PackedRTree.SearchHit> hits;
    private final HeaderMeta headerMeta;
    private final int featuresOffset;
    private final LittleEndianDataInputStream data;

    ReadHitsIterable(SimpleFeatureBuilder fb, ArrayList<PackedRTree.SearchHit> hits, HeaderMeta headerMeta, int featuresOffset, LittleEndianDataInputStream data) {
        this.fb = fb;
        this.hits = hits;
        this.headerMeta = headerMeta;
        this.featuresOffset = featuresOffset;
        this.data = data;
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        IteratorImplementation it = new IteratorImplementation();
        return it;
    }

    private final class IteratorImplementation
    implements Iterator<SimpleFeature> {
        int i = 0;
        long pos;

        private IteratorImplementation() {
            this.pos = ReadHitsIterable.this.featuresOffset;
        }

        @Override
        public boolean hasNext() {
            return this.i < ReadHitsIterable.this.hits.size();
        }

        @Override
        public SimpleFeature next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PackedRTree.SearchHit hit = ReadHitsIterable.this.hits.get(this.i);
            long skip = hit.offset - (this.pos - (long)ReadHitsIterable.this.featuresOffset);
            try {
                FlatGeobufFeatureReader.skipNBytes((InputStream)ReadHitsIterable.this.data, skip);
                this.pos += skip;
                int featureSize = ReadHitsIterable.this.data.readInt();
                this.pos += 4L;
                SimpleFeature feature = FeatureConversions.deserialize(ReadHitsIterable.this.data, ReadHitsIterable.this.fb, ReadHitsIterable.this.headerMeta, hit.index, featureSize);
                this.pos += (long)featureSize;
                ++this.i;
                return feature;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

