/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.flatgeobuf.FlatGeobufDataStore;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class FlatGeobufDirectoryDataStore
extends ContentDataStore {
    private File directory;
    private HashMap<String, SimpleFeatureType> createFeatureTypes;

    public FlatGeobufDirectoryDataStore(File directory) {
        this.directory = directory;
        this.createFeatureTypes = new HashMap();
    }

    protected File getDirectory() {
        return this.directory;
    }

    public void removeSchema(Name typeName) throws IOException {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) throws IOException {
        File file;
        if (!((String)typeName).endsWith(".fgb")) {
            typeName = (String)typeName + ".fgb";
        }
        if (!(file = new File(this.directory, (String)typeName)).exists()) {
            throw new IOException("Can't delete " + file.getAbsolutePath() + " because it doesn't exist!");
        }
        file.delete();
    }

    protected FlatGeobufDataStore getDataStore(String name) {
        File file = new File(this.directory, name + ".fgb");
        try {
            URL url = file.toURI().toURL();
            FlatGeobufDataStore store = new FlatGeobufDataStore(url);
            if (this.createFeatureTypes.containsKey(name) && !file.exists()) {
                SimpleFeatureType featureType = this.createFeatureTypes.get(name);
                store.createSchema(featureType);
            }
            return store;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Name> createTypeNames() throws IOException {
        File[] files = this.directory.listFiles((dir, name) -> name.endsWith(".fgb"));
        ArrayList<Name> names = new ArrayList<Name>();
        if (files != null) {
            for (File file : files) {
                String name2 = file.getName();
                if (this.createFeatureTypes.containsKey(name2)) {
                    this.createFeatureTypes.remove(name2);
                }
                names.add((Name)new NameImpl(name2.substring(0, name2.lastIndexOf(46))));
            }
        }
        for (String createName : this.createFeatureTypes.keySet()) {
            names.add((Name)new NameImpl(createName));
        }
        return names;
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.createFeatureTypes.put(featureType.getTypeName(), featureType);
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry contentEntry) throws IOException {
        return this.getDataStore(contentEntry.getTypeName()).createFeatureSource(contentEntry);
    }
}

