/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.geotools.util.NIOUtilities;

public class FlatBuffers {
    public static FlatBufferBuilder newBuilder(int minimumCapacity) {
        return new ReleasingFlatBufferBuilder(minimumCapacity, new ReleasingByteBufferFactory());
    }

    public static void release(FlatBufferBuilder builder) {
        if (builder instanceof ReleasingFlatBufferBuilder) {
            ((ReleasingFlatBufferBuilder)builder).releaseBuffer();
        }
    }

    private static class ReleasingFlatBufferBuilder
    extends FlatBufferBuilder {
        private ReleasingByteBufferFactory factory;

        public ReleasingFlatBufferBuilder(int initialSize, ReleasingByteBufferFactory factory) {
            super(initialSize, (FlatBufferBuilder.ByteBufferFactory)factory);
            this.factory = factory;
        }

        public void releaseBuffer() {
            this.factory.release();
        }
    }

    private static class ReleasingByteBufferFactory
    extends FlatBufferBuilder.ByteBufferFactory {
        private ByteBuffer lastBuffer;

        private ReleasingByteBufferFactory() {
        }

        public ByteBuffer newByteBuffer(int capacity) {
            ByteBuffer buff = NIOUtilities.allocate((int)capacity);
            buff.order(ByteOrder.LITTLE_ENDIAN);
            this.lastBuffer = buff;
            return this.lastBuffer;
        }

        public void releaseByteBuffer(ByteBuffer bb) {
            NIOUtilities.returnToCache((ByteBuffer)bb);
        }

        public void release() {
            if (this.lastBuffer != null) {
                this.releaseByteBuffer(this.lastBuffer);
                this.lastBuffer = null;
            }
        }
    }
}

