/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.Repository;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.data.DefaultResourceInfo;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.gen.PreGeneralizedDataStore;
import org.geotools.data.gen.PreGeneralizedFeatureCollection;
import org.geotools.data.gen.PreGeneralizedFeatureReader;
import org.geotools.data.gen.info.Generalization;
import org.geotools.data.gen.info.GeneralizationInfo;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class PreGeneralizedFeatureSource
implements SimpleFeatureSource {
    protected FeatureListenerManager listenerManager = new FeatureListenerManager();
    protected Repository repository;
    protected GeneralizationInfo info;
    protected PreGeneralizedDataStore dataStore;
    protected Logger log = Logging.getLogger(this.getClass());
    private Set<RenderingHints.Key> supportedHints;
    private QueryCapabilities queryCapabilities;
    private SimpleFeatureTypeImpl featureTyp;
    private Map<Double, int[]> indexMapping;
    private DefaultResourceInfo ri = null;

    public PreGeneralizedFeatureSource(GeneralizationInfo info, Repository repository, PreGeneralizedDataStore dataStore) {
        this.info = info;
        this.repository = repository;
        this.dataStore = dataStore;
        this.reset();
    }

    private void dsNotFoundException(String wsName, String dsName) throws IOException {
        String msg = "Data store named " + dsName;
        if (wsName != null) {
            msg = msg + " in workspace " + wsName;
        }
        msg = msg + " not found";
        throw new IOException(msg);
    }

    public void reset() {
        this.indexMapping = new HashMap<Double, int[]>();
        this.supportedHints = null;
        this.queryCapabilities = null;
        this.featureTyp = null;
    }

    private SimpleFeatureSource getBaseFeatureSource() throws IOException {
        DataStore ds = this.repository.dataStore((Name)new NameImpl(this.info.getDataSourceNameSpace(), this.info.getDataSourceName()));
        if (ds == null) {
            this.dsNotFoundException(this.info.getDataSourceNameSpace(), this.info.getDataSourceName());
        }
        return ds.getFeatureSource(this.info.getBaseFeatureName());
    }

    private int[] calculateIndexMapping(SimpleFeatureType backendType, String geomProperyName, String backendGeomPropertyName) throws IOException {
        int[] mapping = new int[this.getSchema().getAttributeCount()];
        for (int i = 0; i < mapping.length; ++i) {
            int j;
            block4: {
                String attrName = ((AttributeDescriptor)this.getSchema().getAttributeDescriptors().get(i)).getLocalName();
                if (attrName.equals(geomProperyName)) {
                    attrName = backendGeomPropertyName;
                }
                for (j = 0; j < backendType.getAttributeDescriptors().size(); ++j) {
                    if (!((AttributeDescriptor)backendType.getAttributeDescriptors().get(j)).getLocalName().equals(attrName)) {
                        continue;
                    }
                    break block4;
                }
                throw new IOException("No attribute " + attrName + " found in " + backendType.getTypeName());
            }
            mapping[i] = j;
        }
        return mapping;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.listenerManager.addFeatureListener((FeatureSource)this, listener);
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        Generalization di = this.info.getGeneralizationForDistance(this.getRequestedDistance(query));
        SimpleFeatureSource fs = this.getBaseFeatureSource();
        Query newQuery = this.getProxyObject(query, fs, di);
        return this.getBaseFeatureSource().getBounds(newQuery);
    }

    public int getCount(Query query) throws IOException {
        Generalization di = this.info.getGeneralizationForDistance(this.getRequestedDistance(query));
        SimpleFeatureSource fs = this.getBaseFeatureSource();
        Query newQuery = this.getProxyObject(query, fs, di);
        return this.getBaseFeatureSource().getCount(newQuery);
    }

    public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore() {
        return this.dataStore;
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return new PreGeneralizedFeatureCollection(this.getBaseFeatureSource().getFeatures(), this.getSchema(), this.getSchema(), this.indexMapping.get(0.0), this.info.getGeomPropertyName(), this.info.getGeomPropertyName());
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return new PreGeneralizedFeatureCollection(this.getBaseFeatureSource().getFeatures(filter), this.getSchema(), this.getSchema(), this.indexMapping.get(0.0), this.info.getGeomPropertyName(), this.info.getGeomPropertyName());
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        SimpleFeatureSource fs = this.getFeatureSourceFor(query);
        Generalization di = this.info.getGeneralizationForDistance(this.getRequestedDistance(query));
        Query newQuery = this.getProxyObject(query, fs, di);
        if (di != null) {
            this.logDistanceInfo(di);
        }
        return new PreGeneralizedFeatureCollection(fs.getFeatures(newQuery), this.getSchema(), this.getReturnedSchema(this.getSchema(), query), query.getPropertyNames() == Query.ALL_NAMES ? this.indexMapping.get(di == null ? 0.0 : di.getDistance()) : null, this.info.getGeomPropertyName(), this.getBackendGeometryName(di));
    }

    private SimpleFeatureType getReturnedSchema(SimpleFeatureType schema, Query query) {
        if (query.getPropertyNames() == Query.ALL_NAMES) {
            return schema;
        }
        return SimpleFeatureTypeBuilder.retype((SimpleFeatureType)schema, (String[])query.getPropertyNames());
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        SimpleFeatureSource fs = this.getFeatureSourceFor(query);
        DataAccess access = fs.getDataStore();
        if (access instanceof DataStore) {
            Generalization di = this.info.getGeneralizationForDistance(this.getRequestedDistance(query));
            if (di != null) {
                this.logDistanceInfo(di);
            }
            Query newQuery = this.getProxyObject(query, fs, di);
            String backendGeometryPropertyName = this.getBackendGeometryName(di);
            return new PreGeneralizedFeatureReader(this.getSchema(), this.getReturnedSchema(this.getSchema(), query), this.indexMapping.get(di == null ? 0.0 : di.getDistance()), (FeatureReader<SimpleFeatureType, SimpleFeature>)((DataStore)access).getFeatureReader(newQuery, transaction), this.info.getGeomPropertyName(), backendGeometryPropertyName);
        }
        return null;
    }

    public ResourceInfo getInfo() {
        if (this.ri != null) {
            return this.ri;
        }
        try {
            this.ri = new DefaultResourceInfo();
            this.ri.setBounds(this.getBaseFeatureSource().getBounds());
            if (((SimpleFeatureType)this.getBaseFeatureSource().getSchema()).getGeometryDescriptor() != null) {
                this.ri.setCRS(((SimpleFeatureType)this.getBaseFeatureSource().getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem());
            }
            this.ri.setDescription(this.getBaseFeatureSource().getInfo().getDescription());
            this.ri.setTitle(this.getBaseFeatureSource().getInfo().getTitle());
            this.ri.setName(this.getName().getLocalPart());
            TreeSet<String> keyWords = new TreeSet<String>();
            keyWords.addAll(this.getBaseFeatureSource().getInfo().getKeywords());
            keyWords.add("pregeneralized)");
            this.ri.setKeywords(keyWords);
        }
        catch (IOException ex) {
            this.ri = null;
            throw new RuntimeException(ex);
        }
        return this.ri;
    }

    public Name getName() {
        return new NameImpl(this.dataStore.getNamespace() == null ? null : this.dataStore.getNamespace().toString(), this.info.getFeatureName());
    }

    public QueryCapabilities getQueryCapabilities() {
        if (this.queryCapabilities != null) {
            return this.queryCapabilities;
        }
        this.queryCapabilities = new QueryCapabilities(){

            public boolean isOffsetSupported() {
                try {
                    if (!PreGeneralizedFeatureSource.this.getBaseFeatureSource().getQueryCapabilities().isOffsetSupported()) {
                        return false;
                    }
                    for (Generalization di : PreGeneralizedFeatureSource.this.info.getGeneralizations()) {
                        SimpleFeatureSource fs = PreGeneralizedFeatureSource.this.getFeatureSourceFor(di);
                        if (fs.getQueryCapabilities().isOffsetSupported()) continue;
                        return false;
                    }
                    return true;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public boolean isReliableFIDSupported() {
                try {
                    if (!PreGeneralizedFeatureSource.this.getBaseFeatureSource().getQueryCapabilities().isReliableFIDSupported()) {
                        return false;
                    }
                    for (Generalization di : PreGeneralizedFeatureSource.this.info.getGeneralizations()) {
                        SimpleFeatureSource fs = PreGeneralizedFeatureSource.this.getFeatureSourceFor(di);
                        if (fs.getQueryCapabilities().isReliableFIDSupported()) continue;
                        return false;
                    }
                    return true;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public boolean supportsSorting(SortBy[] arg0) {
                try {
                    if (!PreGeneralizedFeatureSource.this.getBaseFeatureSource().getQueryCapabilities().supportsSorting(arg0)) {
                        return false;
                    }
                    for (Generalization di : PreGeneralizedFeatureSource.this.info.getGeneralizations()) {
                        SimpleFeatureSource fs = PreGeneralizedFeatureSource.this.getFeatureSourceFor(di);
                        if (fs.getQueryCapabilities().supportsSorting(arg0)) continue;
                        return false;
                    }
                    return true;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        return this.queryCapabilities;
    }

    public SimpleFeatureType getSchema() {
        if (this.featureTyp != null) {
            return this.featureTyp;
        }
        try {
            SimpleFeatureType baseType = (SimpleFeatureType)this.getBaseFeatureSource().getSchema();
            ArrayList<AttributeDescriptor> attrDescrs = new ArrayList<AttributeDescriptor>();
            block2: for (AttributeDescriptor descr : baseType.getAttributeDescriptors()) {
                for (Generalization di : this.info.getGeneralizations()) {
                    if (!di.getDataSourceName().equals(this.info.getDataSourceName()) || !di.getFeatureName().equals(baseType.getName().getLocalPart()) || !di.getGeomPropertyName().equals(descr.getName().getLocalPart())) continue;
                    continue block2;
                }
                attrDescrs.add(descr);
            }
            GeometryDescriptor geomDescr = (GeometryDescriptor)baseType.getDescriptor(this.info.getGeomPropertyName());
            this.featureTyp = new SimpleFeatureTypeImpl((Name)new NameImpl(this.dataStore.getNamespace() == null ? null : this.dataStore.getNamespace().toString(), this.info.getFeatureName()), attrDescrs, geomDescr, false, null, null, baseType.getDescription());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.featureTyp;
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        if (this.supportedHints != null) {
            return this.supportedHints;
        }
        HashSet<Hints.Key> hints = new HashSet<Hints.Key>();
        try {
            hints.addAll(this.getBaseFeatureSource().getSupportedHints());
            for (Generalization di : this.info.getGeneralizations()) {
                SimpleFeatureSource fs = this.getFeatureSourceFor(di);
                hints.retainAll(fs.getSupportedHints());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        hints.add(Hints.GEOMETRY_DISTANCE);
        this.supportedHints = Collections.unmodifiableSet(hints);
        return this.supportedHints;
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
    }

    private SimpleFeatureSource getFeatureSourceFor(Double requestedDistance) throws IOException {
        if (requestedDistance == null || requestedDistance == 0.0) {
            return this.getBaseFeatureSource();
        }
        Generalization di = this.info.getGeneralizationForDistance(requestedDistance);
        return this.getFeatureSourceFor(di);
    }

    private SimpleFeatureSource getFeatureSourceFor(Generalization di) throws IOException {
        if (di == null) {
            return this.getBaseFeatureSource();
        }
        DataStore ds = this.repository.dataStore((Name)new NameImpl(di.getDataSourceNameSpace(), di.getDataSourceName()));
        if (ds == null) {
            this.dsNotFoundException(di.getDataSourceNameSpace(), di.getDataSourceName());
        }
        SimpleFeatureSource fs = ds.getFeatureSource(di.getFeatureName());
        int[] mapping = this.calculateIndexMapping((SimpleFeatureType)fs.getSchema(), this.info.getGeomPropertyName(), di.getGeomPropertyName());
        this.indexMapping.put(di.getDistance(), mapping);
        return fs;
    }

    private Double getRequestedDistance(Query query) {
        Double result = (Double)query.getHints().get((Object)Hints.GEOMETRY_DISTANCE);
        if (result == null) {
            result = (Double)query.getHints().get((Object)Hints.GEOMETRY_SIMPLIFICATION);
            this.log.fine("Hint for geometry simplification in query, fallback to base feature");
        }
        if (result == null) {
            this.log.fine("No hint for geometry distance in query, fallback to base feature");
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Hint geometry distance: " + result);
        }
        return result;
    }

    private SimpleFeatureSource getFeatureSourceFor(Query query) throws IOException {
        Double distance = this.getRequestedDistance(query);
        String geomPropertyName = this.info.getGeomPropertyName();
        String[] queryProperyNames = query.getPropertyNames();
        if (queryProperyNames != null) {
            for (String prop : queryProperyNames) {
                if (!prop.equals(geomPropertyName)) continue;
                return this.getFeatureSourceFor(distance);
            }
        } else {
            return this.getFeatureSourceFor(distance);
        }
        return this.getBaseFeatureSource();
    }

    private String getBackendGeometryName(Generalization di) {
        if (di != null) {
            return di.getGeomPropertyName();
        }
        return this.info.getGeomPropertyName();
    }

    protected Query getProxyObject(Query query, SimpleFeatureSource fs, Generalization di) {
        int i;
        String[] newPropNames;
        String baseGeomPropertyName = this.info.getGeomPropertyName();
        String backendGeomPropertyName = this.getBackendGeometryName(di);
        String[] originalPropNames = query.getPropertyNames();
        if (originalPropNames == Query.ALL_NAMES) {
            newPropNames = new String[this.getSchema().getAttributeCount()];
            for (i = 0; i < newPropNames.length; ++i) {
                AttributeDescriptor attrDescr = (AttributeDescriptor)this.getSchema().getAttributeDescriptors().get(i);
                newPropNames[i] = attrDescr.getLocalName().equals(baseGeomPropertyName) ? backendGeomPropertyName : attrDescr.getLocalName();
            }
        } else {
            newPropNames = new String[originalPropNames.length];
            for (i = 0; i < newPropNames.length; ++i) {
                newPropNames[i] = originalPropNames[i].equals(baseGeomPropertyName) ? backendGeomPropertyName : originalPropNames[i];
            }
        }
        Query newQuery = new Query(query);
        newQuery.setTypeName(fs.getName().getLocalPart());
        newQuery.setPropertyNames(newPropNames);
        return newQuery;
    }

    protected void logDistanceInfo(Generalization di) {
        StringBuffer buff = new StringBuffer("Using generalizsation: ");
        buff.append(di.getDataSourceName()).append(" ");
        buff.append(di.getFeatureName()).append(" ");
        buff.append(di.getGeomPropertyName()).append(" ");
        buff.append(di.getDistance());
        this.log.info(buff.toString());
    }
}

