/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.Repository;
import org.geotools.api.feature.type.Name;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.util.logging.Logging;

public class DSFinderRepository
implements Repository {
    Map<String, DataStore> map = new HashMap<String, DataStore>();
    Logger log = Logging.getLogger(this.getClass());

    public void clear() {
        this.map = new HashMap<String, DataStore>();
    }

    protected URL getURLForLocation(String location) throws IOException {
        URL url = null;
        File f = new File(location);
        url = f.exists() ? f.toURI().toURL() : new URL(location);
        url = new URL(URLDecoder.decode(url.toExternalForm(), "UTF8"));
        return url;
    }

    private Map<String, Serializable> getMapForShapeFile(URL shapeFileURL) throws IOException {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put(ShapefileDataStoreFactory.URLP.key, shapeFileURL);
        return result;
    }

    private Map<String, Serializable> getMapFromPropetryLocation(String location) throws IOException {
        URL url = this.getURLForLocation(location);
        if (location.endsWith(".shp") || location.endsWith(".SHP")) {
            return this.getMapForShapeFile(url);
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        Properties properties = new Properties();
        try (InputStream in = url.openStream();){
            properties.load(in);
            for (Object key : properties.keySet()) {
                result.put((String)key, (Serializable)properties.get(key));
            }
        }
        return result;
    }

    public void initialize(Object source) {
        this.clear();
    }

    public DataAccess<?, ?> access(Name name) {
        return this.dataStore(name);
    }

    public DataStore dataStore(Name name) {
        String localName = name.getLocalPart();
        DataStore ds = this.map.get(localName);
        if (ds != null) {
            return ds;
        }
        try {
            Map<String, Serializable> params = this.getMapFromPropetryLocation(localName);
            ds = DataStoreFinder.getDataStore(params);
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        this.map.put(localName, ds);
        return ds;
    }

    public List<DataStore> getDataStores() {
        return Collections.emptyList();
    }
}

