/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.epsg.wkt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Version;
import org.geotools.util.factory.AbstractFactory;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.InternationalString;

public class EPSGCRSAuthorityFactory
extends AbstractFactory
implements CRSAuthorityFactory {
    private static final Logger LOGGER = Logging.getLogger(EPSGCRSAuthorityFactory.class);
    public static final String AUTHORITY = "EPSG";
    public static final String AUTHORITY_PREFIX = "EPSG:";
    protected static EPSGCRSAuthorityFactory DEFAULT;
    protected Properties epsg = new Properties();
    protected CRSFactory crsFactory;
    private Map<String, Object> cache = new HashMap<String, Object>();

    public EPSGCRSAuthorityFactory() {
        this(ReferencingFactoryFinder.getCRSFactory(null));
    }

    protected EPSGCRSAuthorityFactory(CRSFactory factory) {
        super(1);
        this.crsFactory = factory;
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        this.hints.put(Hints.VERSION, new Version(""));
        try {
            this.loadDefault();
        }
        catch (IOException oops) {
            LOGGER.log(Level.SEVERE, "Could not load epsg.properties", oops);
        }
    }

    protected EPSGCRSAuthorityFactory(CRSFactory factory, URL definition) throws FactoryException {
        this(factory);
        try {
            this.epsg.load(definition.openStream());
        }
        catch (IOException io) {
            throw new FactoryException("Could not load properties file: " + String.valueOf(definition));
        }
    }

    protected void loadDefault() throws IOException {
        File file = new File("epsg.properties");
        if (file.exists()) {
            this.epsg.load(new FileInputStream(file));
        }
        URL url = EPSGCRSAuthorityFactory.class.getResource("epsg.properties");
        this.epsg.load(url.openStream());
    }

    public static synchronized CRSAuthorityFactory getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new EPSGCRSAuthorityFactory();
        }
        return DEFAULT;
    }

    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        Object wkt;
        if (code == null) {
            return null;
        }
        if (!code.startsWith(AUTHORITY_PREFIX)) {
            throw new NoSuchAuthorityCodeException("This factory only understand EPSG codes", AUTHORITY, code);
        }
        String EPSG_NUMBER = code.substring(code.indexOf(58) + 1).trim();
        if (this.cache.containsKey(EPSG_NUMBER)) {
            Object value = this.cache.get(EPSG_NUMBER);
            if (value instanceof Throwable) {
                throw new FactoryException("WKT for " + code + " could not be parsed", (Throwable)value);
            }
            if (value instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)value;
            }
        }
        if ((wkt = this.epsg.getProperty(EPSG_NUMBER)) == null) {
            throw new NoSuchAuthorityCodeException("Unknown EPSG_NUMBER", AUTHORITY, code);
        }
        if (((String)wkt).indexOf(EPSG_NUMBER) == -1) {
            wkt = ((String)wkt).trim();
            wkt = ((String)wkt).substring(0, ((String)wkt).length() - 1);
            wkt = (String)wkt + ",AUTHORITY[\"EPSG\",\"" + EPSG_NUMBER + "\"]]";
            LOGGER.log(Level.WARNING, AUTHORITY_PREFIX + EPSG_NUMBER + " lacks a proper identifying authority in its Well-Known Text. It is being added programmatically.");
        }
        try {
            CoordinateReferenceSystem crs = this.crsFactory.createFromWKT((String)wkt);
            this.cache.put(EPSG_NUMBER, crs);
            return crs;
        }
        catch (FactoryException fex) {
            this.cache.put(EPSG_NUMBER, (Object)fex);
            throw fex;
        }
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return (ProjectedCRS)this.createCoordinateReferenceSystem(code);
    }

    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        return (GeographicCRS)this.createCoordinateReferenceSystem(code);
    }

    public Citation getAuthority() {
        return Citations.EPSG;
    }

    public Set<String> getAuthorityCodes(Class clazz) throws FactoryException {
        if (clazz.getName().equalsIgnoreCase(CoordinateReferenceSystem.class.getName())) {
            TreeSet<String> all = new TreeSet<String>();
            for (Object o : this.epsg.keySet()) {
                String code = (String)o;
                all.add(AUTHORITY_PREFIX + code);
            }
            return all;
        }
        if (clazz.getName().equalsIgnoreCase(GeographicCRS.class.getName())) {
            Set<Object> all = this.epsg.keySet();
            TreeSet<String> geoCRS = new TreeSet<String>();
            for (Object o : all) {
                String code = (String)o;
                String wkt = this.epsg.getProperty(code);
                if (!wkt.startsWith("GEOGCS")) continue;
                geoCRS.add(AUTHORITY_PREFIX + code);
            }
            return geoCRS;
        }
        if (clazz.getName().equalsIgnoreCase(ProjectedCRS.class.getName())) {
            Set<Object> all = this.epsg.keySet();
            TreeSet<String> projCRS = new TreeSet<String>();
            for (Object o : all) {
                String code = (String)o;
                String wkt = this.epsg.getProperty(code);
                if (!wkt.startsWith("PROJCS")) continue;
                projCRS.add(AUTHORITY_PREFIX + code);
            }
            return projCRS;
        }
        return new TreeSet<String>();
    }

    public ObjectFactory getObjectFactory() {
        return this.crsFactory;
    }

    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        String wkt;
        if (code == null) {
            return null;
        }
        if (code.startsWith(AUTHORITY_PREFIX)) {
            code = code.substring(5);
        }
        if ((wkt = this.epsg.getProperty(code = code.trim())) == null) {
            throw new FactoryException("Unknonwn EPSG code: '" + code + "'");
        }
        wkt = wkt.trim();
        int start = wkt.indexOf(34);
        int end = wkt.indexOf(34, start + 1);
        return new SimpleInternationalString(wkt.substring(start + 1, end));
    }

    public CompoundCRS createCompoundCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public DerivedCRS createDerivedCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public EngineeringCRS createEngineeringCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public GeocentricCRS createGeocentricCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public ImageCRS createImageCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public TemporalCRS createTemporalCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public VerticalCRS createVerticalCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }
}

