/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.elasticsearch.GeohashUtil;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.elasticsearch.BBOXRemovingFilterVisitor;
import org.geotools.process.elasticsearch.BasicGeoHashGrid;
import org.geotools.process.elasticsearch.GeoHashGrid;
import org.geotools.process.elasticsearch.GridCoverageUtil;
import org.geotools.process.elasticsearch.MetricGeoHashGrid;
import org.geotools.process.elasticsearch.NestedAggGeoHashGrid;
import org.geotools.process.elasticsearch.RasterScale;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Envelope;

@DescribeProcess(title="geoHashGridAgg", description="Computes a grid from GeoHash grid aggregation buckets with values corresponding to doc_count values.")
public class GeoHashGridProcess
implements VectorProcess {
    private static final FilterFactory FILTER_FACTORY = CommonFactoryFinder.getFilterFactory(null);

    @DescribeResult(description="Output raster")
    public GridCoverage2D execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="gridStrategy", description="GeoHash grid strategy", defaultValue="Basic", min=0) String gridStrategy, @DescribeParameter(name="gridStrategyArgs", description="Grid strategy arguments", min=0) List<String> gridStrategyArgs, @DescribeParameter(name="emptyCellValue", description="Default cell value", min=0) Float emptyCellValue, @DescribeParameter(name="scaleMin", description="Scale minimum", defaultValue="0") Float scaleMin, @DescribeParameter(name="scaleMax", description="Scale maximum", min=0) Float scaleMax, @DescribeParameter(name="useLog", description="Whether to use log values (default=false)", defaultValue="false") Boolean useLog, @DescribeParameter(name="outputBBOX", description="Bounding box of the output") ReferencedEnvelope argOutputEnv, @DescribeParameter(name="outputWidth", description="Width of output raster in pixels") Integer argOutputWidth, @DescribeParameter(name="outputHeight", description="Height of output raster in pixels") Integer argOutputHeight, @DescribeParameter(name="aggregationDefinition", description="Native Elasticsearch Aggregation definition", min=0) String aggregationDefinition, @DescribeParameter(name="queryDefinition", description="Native Elasticsearch Query definition", min=0) String queryDefinition, ProgressListener monitor) throws ProcessException {
        try {
            if (aggregationDefinition == null) {
                aggregationDefinition = this.defaultAggregation(argOutputEnv, argOutputWidth);
            }
            GeoHashGrid geoHashGrid = Strategy.valueOf(gridStrategy.toUpperCase()).createNewInstance();
            geoHashGrid.setParams(gridStrategyArgs);
            geoHashGrid.setEmptyCellValue(emptyCellValue);
            geoHashGrid.setScale(new RasterScale(scaleMin, scaleMax, useLog));
            geoHashGrid.initalize(argOutputEnv, obsFeatures, aggregationDefinition, queryDefinition);
            return geoHashGrid.toGridCoverage2D();
        }
        catch (Exception e) {
            throw new ProcessException("Error executing GeoHashGridProcess", (Throwable)e);
        }
    }

    String defaultAggregation(ReferencedEnvelope envelope, Integer width) {
        int precision = GeohashUtil.getPrecisionFromScale(envelope, width);
        return "{\"agg\": {\"geohash_grid\": {\"size\": 65536, \"field\": \"\", \"precision\": " + precision + "}}}";
    }

    public Query invertQuery(@DescribeParameter(name="outputBBOX", description="Georeferenced bounding box of the output") ReferencedEnvelope envelope, @DescribeParameter(name="outputWidth", description="Width of output raster in pixels") Integer argOutputWidth, @DescribeParameter(name="aggregationDefinition", description="Native Elasticsearch Aggregation definition", min=0) String aggregationDefinition, Query targetQuery, GridGeometry targetGridGeometry) throws ProcessException {
        BBOX bbox;
        BBOXRemovingFilterVisitor visitor = new BBOXRemovingFilterVisitor();
        Filter filter = (Filter)targetQuery.getFilter().accept((FilterVisitor)visitor, null);
        String geometryName = visitor.getGeometryPropertyName();
        if (geometryName == null) {
            geometryName = "";
        }
        try {
            boolean reproject;
            boolean bl = reproject = !CRS.equalsIgnoreMetadata((Object)envelope.getCoordinateReferenceSystem(), (Object)DefaultGeographicCRS.WGS84);
            if (reproject) {
                envelope = envelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, false);
                if (aggregationDefinition == null) {
                    aggregationDefinition = this.defaultAggregation(envelope, argOutputWidth);
                }
                Integer precision = GeohashUtil.getPrecision(aggregationDefinition);
                envelope = GridCoverageUtil.pad((Envelope)envelope, precision);
            }
            bbox = FILTER_FACTORY.bbox(geometryName, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), "EPSG:4326");
        }
        catch (Exception e) {
            throw new ProcessException("Unable to create bbox filter for feature source", (Throwable)e);
        }
        filter = (Filter)FILTER_FACTORY.and(filter, (Filter)bbox).accept((FilterVisitor)new SimplifyingFilterVisitor(), null);
        targetQuery.setFilter(filter);
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        properties.add(FILTER_FACTORY.property("_aggregation"));
        targetQuery.setProperties(properties);
        return targetQuery;
    }

    public static enum Strategy {
        BASIC(BasicGeoHashGrid.class),
        METRIC(MetricGeoHashGrid.class),
        NESTED_AGG(NestedAggGeoHashGrid.class);

        private final Class<? extends GeoHashGrid> clazz;

        private Strategy(Class<? extends GeoHashGrid> clazz) {
            this.clazz = clazz;
        }

        GeoHashGrid createNewInstance() throws ReflectiveOperationException {
            return this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }
}

