/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.data.elasticsearch.ElasticAttribute;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

class ElasticFeatureTypeBuilder
extends SimpleFeatureTypeBuilder {
    private static final Logger LOGGER = Logging.getLogger(ElasticFeatureTypeBuilder.class);
    private final List<ElasticAttribute> attributes;

    public ElasticFeatureTypeBuilder(List<ElasticAttribute> attributes, Name name) {
        this.setName(name);
        this.attributes = attributes;
    }

    public SimpleFeatureType buildFeatureType() {
        if (this.attributes != null) {
            String defaultGeometryName = null;
            for (ElasticAttribute attribute : this.attributes) {
                AttributeDescriptor att;
                block10: {
                    if (!attribute.isUse().booleanValue()) continue;
                    String attributeName = attribute.getCustomName() != null ? attribute.getCustomName() : attribute.getName();
                    att = null;
                    if (Geometry.class.isAssignableFrom(attribute.getType())) {
                        Integer srid = attribute.getSrid();
                        try {
                            if (srid == null) break block10;
                            this.attributeBuilder.setCRS(CRS.decode((String)("EPSG:" + srid)));
                            this.attributeBuilder.setName(attributeName);
                            this.attributeBuilder.setBinding(attribute.getType());
                            att = this.attributeBuilder.buildDescriptor(attributeName, this.attributeBuilder.buildGeometryType());
                            ElasticAttribute.ElasticGeometryType geometryType = attribute.getGeometryType();
                            att.getUserData().put("geometry_type", geometryType);
                            if (attribute.isDefaultGeometry() != null && attribute.isDefaultGeometry().booleanValue()) {
                                defaultGeometryName = attributeName;
                            }
                        }
                        catch (Exception e) {
                            String msg = "Error occured determing srid for " + attribute.getName();
                            LOGGER.log(Level.WARNING, msg, e);
                        }
                    } else {
                        this.attributeBuilder.setName(attributeName);
                        this.attributeBuilder.setBinding(attribute.getType());
                        att = this.attributeBuilder.buildDescriptor(attributeName, this.attributeBuilder.buildType());
                    }
                }
                if (att != null && (attribute.getValidDateFormats() != null || attribute.getDateFormat() != null)) {
                    if (attribute.getValidDateFormats() == null) {
                        ArrayList<String> validFormats = new ArrayList<String>();
                        validFormats.add(attribute.getDateFormat());
                        attribute.setValidDateFormats(validFormats);
                    }
                    att.getUserData().put("date_format", attribute.getValidDateFormats());
                }
                if (att == null) continue;
                att.getUserData().put("full_name", attribute.getName());
                att.getUserData().put("analyzed", attribute.getAnalyzed());
                att.getUserData().put("nested", attribute.isNested());
                this.add(att);
            }
            if (defaultGeometryName != null) {
                this.setDefaultGeometry(defaultGeometryName);
            }
        }
        return super.buildFeatureType();
    }
}

