/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.data.elasticsearch.ElasticDataStore;
import org.geotools.util.logging.Logging;

public class ElasticDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logging.getLogger(ElasticDataStoreFactory.class);
    private static final String FORCE_RUNAS_PROPERTY = "org.geoserver.elasticsearch.xpack.force-runas";
    static final AtomicInteger httpThreads = new AtomicInteger(1);
    public static final String DISPLAY_NAME = "Elasticsearch";
    public static final String DESCRIPTION = "Elasticsearch Index";
    public static final DataAccessFactory.Param HOSTNAME = new DataAccessFactory.Param("elasticsearch_host", String.class, "Host(s) with optional HTTP scheme and port.", true, (Object)"localhost");
    public static final DataAccessFactory.Param HOSTPORT = new DataAccessFactory.Param("elasticsearch_port", Integer.class, "Default HTTP port. Ignored if the host includes the port.", true, (Object)9200);
    public static final DataAccessFactory.Param INDEX_NAME = new DataAccessFactory.Param("index_name", String.class, "Index defining type (supports wildcard)", true);
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "Elasticsearch user", ElasticDataStoreFactory.isForceRunas());
    public static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, "Elasticsearch password", ElasticDataStoreFactory.isForceRunas(), null, Collections.singletonMap("isPassword", Boolean.TRUE));
    public static final DataAccessFactory.Param RUNAS_GEOSERVER_USER = new DataAccessFactory.Param("runas_geoserver_user", Boolean.class, "Flag indicating whether to submit document search requests on behalf of the authenticated GeoServer user", false, (Object)ElasticDataStoreFactory.isForceRunas());
    public static final DataAccessFactory.Param PROXY_USER = new DataAccessFactory.Param("proxy_user", String.class, "Elasticsearch user for document search requests. If not provided the default user is used for all requests.", ElasticDataStoreFactory.isForceRunas());
    public static final DataAccessFactory.Param PROXY_PASSWD = new DataAccessFactory.Param("proxy_passwd", String.class, "Elasticsearch proxy user password.", ElasticDataStoreFactory.isForceRunas(), null, Collections.singletonMap("isPassword", Boolean.TRUE));
    public static final DataAccessFactory.Param SSL_REJECT_UNAUTHORIZED = new DataAccessFactory.Param("ssl_reject_unauthorized", Boolean.class, "Whether to validate the server certificate during the SSL handshake for https connections", false, (Object)true);
    public static final DataAccessFactory.Param SOURCE_FILTERING_ENABLED = new DataAccessFactory.Param("source_filtering_enabled", Boolean.class, "Enable source field filtering", false, (Object)false);
    public static final DataAccessFactory.Param SCROLL_ENABLED = new DataAccessFactory.Param("scroll_enabled", Boolean.class, "Use scan search type instead of dfs_query_then_fetch", false, (Object)false);
    public static final DataAccessFactory.Param SCROLL_SIZE = new DataAccessFactory.Param("scroll_size", Long.class, "Scroll size (ignored if scroll_enabled=false)", false, (Object)20);
    public static final DataAccessFactory.Param SCROLL_TIME_SECONDS = new DataAccessFactory.Param("scroll_time", Integer.class, "Time to keep the scroll open in seconds (ignored if scroll_enabled=false)", false, (Object)120);
    public static final DataAccessFactory.Param DEFAULT_MAX_FEATURES = new DataAccessFactory.Param("default_max_features", Integer.class, "Default max features", false, (Object)100);
    public static final DataAccessFactory.Param ARRAY_ENCODING = new DataAccessFactory.Param("array_encoding", String.class, "Array encoding strategy. Allowed values are \"JSON\" (keep arrays)  and \"CSV\" (URL encode and join array elements).", false, (Object)"JSON");
    public static final DataAccessFactory.Param GRID_SIZE = new DataAccessFactory.Param("grid_size", Long.class, "Hint for Geohash grid size (nrow*ncol)", false, (Object)65536L);
    public static final DataAccessFactory.Param GRID_THRESHOLD = new DataAccessFactory.Param("grid_threshold", Double.class, "Geohash grid aggregation precision will be the minimum necessary to satisfy actual_grid_size/grid_size>grid_threshold", false, (Object)0.05);
    public static final DataAccessFactory.Param RESPONSE_BUFFER_LIMIT = new DataAccessFactory.Param("response_buffer_limit", Integer.class, "Maximum number of bytes to buffer in memory when reading responses from Elasticsearch", false, (Object)0x6400000);
    public static final DataAccessFactory.Param[] PARAMS = new DataAccessFactory.Param[]{HOSTNAME, HOSTPORT, INDEX_NAME, USER, PASSWD, RUNAS_GEOSERVER_USER, PROXY_USER, PROXY_PASSWD, SSL_REJECT_UNAUTHORIZED, SOURCE_FILTERING_ENABLED, SCROLL_ENABLED, SCROLL_SIZE, SCROLL_TIME_SECONDS, DEFAULT_MAX_FEATURES, ARRAY_ENCODING, GRID_SIZE, GRID_THRESHOLD, RESPONSE_BUFFER_LIMIT};

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return PARAMS;
    }

    public boolean canProcess(Map<String, ?> params) {
        boolean result = false;
        try {
            String searchHost = (String)HOSTNAME.lookUp(params);
            String indexName = (String)INDEX_NAME.lookUp(params);
            Integer hostport = (Integer)HOSTPORT.lookUp(params);
            if (searchHost != null && hostport != null && indexName != null) {
                result = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        String user = (String)ElasticDataStoreFactory.getValue(USER, params);
        String passwd = (String)ElasticDataStoreFactory.getValue(PASSWD, params);
        String proxyUser = (String)ElasticDataStoreFactory.getValue(PROXY_USER, params);
        String proxyPasswd = (String)ElasticDataStoreFactory.getValue(PROXY_PASSWD, params);
        RestClient client = this.createRestClient(params, user, passwd);
        RestClient proxyClient = proxyUser != null ? this.createRestClient(params, proxyUser, proxyPasswd) : null;
        return this.createDataStore(client, proxyClient, params);
    }

    public DataStore createDataStore(RestClient client, RestClient proxyClient, Map<String, ?> params) throws IOException {
        String indexName = (String)INDEX_NAME.lookUp(params);
        String arrayEncoding = (String)ElasticDataStoreFactory.getValue(ARRAY_ENCODING, params);
        boolean runAsGeoServerUser = (Boolean)ElasticDataStoreFactory.getValue(RUNAS_GEOSERVER_USER, params);
        int responseBufferLimit = (Integer)ElasticDataStoreFactory.getValue(RESPONSE_BUFFER_LIMIT, params);
        if (ElasticDataStoreFactory.isForceRunas() && !runAsGeoServerUser) {
            throw new IllegalArgumentException(ElasticDataStoreFactory.RUNAS_GEOSERVER_USER.key + " is disabled but org.geoserver.elasticsearch.xpack.force-runas is set. Enable " + ElasticDataStoreFactory.RUNAS_GEOSERVER_USER.key + " or unset org.geoserver.elasticsearch.xpack.force-runas in the system environment.");
        }
        ElasticDataStore dataStore = new ElasticDataStore(client, proxyClient, indexName, runAsGeoServerUser, responseBufferLimit);
        dataStore.setDefaultMaxFeatures((Integer)ElasticDataStoreFactory.getValue(DEFAULT_MAX_FEATURES, params));
        dataStore.setSourceFilteringEnabled((Boolean)ElasticDataStoreFactory.getValue(SOURCE_FILTERING_ENABLED, params));
        dataStore.setScrollEnabled((Boolean)ElasticDataStoreFactory.getValue(SCROLL_ENABLED, params));
        dataStore.setScrollSize(((Number)ElasticDataStoreFactory.getValue(SCROLL_SIZE, params)).longValue());
        dataStore.setScrollTime((Integer)ElasticDataStoreFactory.getValue(SCROLL_TIME_SECONDS, params));
        dataStore.setArrayEncoding(ElasticDataStore.ArrayEncoding.valueOf(arrayEncoding.toUpperCase()));
        dataStore.setGridSize((Long)GRID_SIZE.lookUp(params));
        dataStore.setGridThreshold((Double)GRID_THRESHOLD.lookUp(params));
        return dataStore;
    }

    public RestClient createRestClient(Map<String, Serializable> params) throws IOException {
        return this.createRestClient(params, null, null);
    }

    private RestClient createRestClient(Map<String, ?> params, String user, String password) throws IOException {
        String hostName = (String)ElasticDataStoreFactory.getValue(HOSTNAME, params);
        String[] hosts = hostName.split(",");
        Integer defaultPort = (Integer)ElasticDataStoreFactory.getValue(HOSTPORT, params);
        Boolean sslRejectUnauthorized = (Boolean)ElasticDataStoreFactory.getValue(SSL_REJECT_UNAUTHORIZED, params);
        String adminUser = (String)ElasticDataStoreFactory.getValue(USER, params);
        String type = user == null || adminUser == null || user.equals(adminUser) ? "ADMIN" : "PROXY_USER";
        Pattern pattern = Pattern.compile("(?<scheme>https?)?(://)?(?<host>[^:]+):?(?<port>\\d+)?");
        HttpHost[] httpHosts = new HttpHost[hosts.length];
        AuthScope[] auths = new AuthScope[hosts.length];
        for (int index = 0; index < hosts.length; ++index) {
            Matcher matcher = pattern.matcher(hosts[index].trim());
            if (!matcher.find()) {
                throw new IOException("Unable to parse host");
            }
            String scheme = matcher.group("scheme") != null ? matcher.group("scheme") : "http";
            String host = matcher.group("host");
            Integer port = matcher.group("port") != null ? Integer.valueOf(matcher.group("port")) : defaultPort;
            httpHosts[index] = new HttpHost(host, port.intValue(), scheme);
            auths[index] = new AuthScope(host, port.intValue());
        }
        RestClientBuilder builder = this.createClientBuilder(httpHosts);
        if (user != null) {
            builder.setRequestConfigCallback(b -> {
                LOGGER.finest(String.format("Calling %s setRequestConfigCallback", type));
                return b.setAuthenticationEnabled(true);
            });
        }
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            LOGGER.finest(String.format("Calling %s customizeHttpClient", type));
            httpClientBuilder.setThreadFactory(run -> {
                Thread thread = new Thread(run);
                thread.setDaemon(true);
                thread.setName(String.format("esrest-asynchttp-%s-%d", type, httpThreads.getAndIncrement()));
                return thread;
            });
            httpClientBuilder.useSystemProperties();
            if (!sslRejectUnauthorized.booleanValue()) {
                httpClientBuilder.setSSLHostnameVerifier((host, session) -> true);
                try {
                    httpClientBuilder.setSSLContext(SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build());
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                    throw new UncheckedIOException(new IOException("Unable to create SSLContext", e));
                }
            }
            if (user != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
                for (AuthScope scope : auths) {
                    credentialsProvider.setCredentials(scope, (Credentials)credentials);
                }
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            return httpClientBuilder;
        });
        LOGGER.fine(String.format("Building a %s RestClient for %s @ %s:%d", type, user, hostName, defaultPort));
        return builder.build();
    }

    public DataStore createNewDataStore(Map<String, ?> params) {
        return null;
    }

    public RestClientBuilder createClientBuilder(HttpHost[] hosts) {
        return RestClient.builder((HttpHost[])hosts);
    }

    private static boolean isForceRunas() {
        return System.getProperty(FORCE_RUNAS_PROPERTY) != null;
    }

    static <T> T getValue(DataAccessFactory.Param param, Map<String, ?> params) throws IOException {
        Object value = param.lookUp(params) != null ? param.lookUp(params) : param.sample;
        return (T)value;
    }
}

