/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.elasticsearch;

class RasterScale {
    private static final float DEFAULT_SCALE_MIN = 0.0f;
    private final Float scaleMin;
    private final Float scaleMax;
    private final boolean scaleLog;
    private Float dataMin;
    private Float dataMax;

    public RasterScale() {
        this(null, null, false);
    }

    public RasterScale(boolean useLog) {
        this(null, null, useLog);
    }

    public RasterScale(Float scaleMax) {
        this(Float.valueOf(0.0f), scaleMax, false);
    }

    public RasterScale(Float scaleMin, Float scaleMax) {
        this(scaleMin, scaleMax, false);
    }

    public RasterScale(Float scaleMin, Float scaleMax, boolean scaleLog) {
        this.scaleMin = scaleMin;
        this.scaleMax = scaleMax;
        this.scaleLog = scaleLog;
        if (scaleMax != null && (scaleMin == null || scaleMax.floatValue() == scaleMin.floatValue())) {
            throw new IllegalArgumentException();
        }
    }

    public float scaleValue(float value) {
        if (this.scaleLog && value > 0.0f) {
            value = (float)Math.log10(value);
        }
        if (this.scaleMax == null) {
            return value;
        }
        if (this.dataMax.floatValue() == this.dataMin.floatValue()) {
            return this.scaleMax.floatValue();
        }
        return (this.scaleMax.floatValue() - this.scaleMin.floatValue()) * (value - this.dataMin.floatValue()) / (this.dataMax.floatValue() - this.dataMin.floatValue()) + this.scaleMin.floatValue();
    }

    public void prepareScale(float value) {
        if (this.scaleLog && value > 0.0f) {
            value = (float)Math.log10(value);
        }
        if (this.scaleMax != null && this.dataMin != null) {
            if (value < this.dataMin.floatValue()) {
                this.dataMin = Float.valueOf(value);
            }
            if (value > this.dataMax.floatValue()) {
                this.dataMax = Float.valueOf(value);
            }
        } else if (this.scaleMax != null) {
            this.dataMin = Float.valueOf(value);
            this.dataMax = Float.valueOf(value);
        }
    }

    public boolean isScaleSet() {
        return this.scaleMax != null;
    }

    public Float getScaleMin() {
        return this.scaleMin;
    }

    public Float getScaleMax() {
        return this.scaleMax;
    }
}

