/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.elasticsearch;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.Operations;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;

class GridCoverageUtil {
    GridCoverageUtil() {
    }

    public static GridCoverage2D scale(GridCoverage2D coverage, float width, float height) {
        RenderedImage renderedImage = coverage.getRenderedImage();
        Raster renderedGrid = renderedImage.getData();
        float yScale = width / (float)renderedGrid.getWidth();
        float xScale = height / (float)renderedGrid.getHeight();
        Operations ops = new Operations(null);
        return (GridCoverage2D)ops.scale((GridCoverage)coverage, (double)xScale, (double)yScale, 0.0, 0.0);
    }

    public static GridCoverage2D crop(GridCoverage2D coverage, Envelope envelope) {
        CoverageProcessor processor = new CoverageProcessor();
        ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters();
        GeneralEnvelope crop = new GeneralEnvelope(envelope);
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("Envelope").setValue((Object)crop);
        return (GridCoverage2D)processor.doOperation(param);
    }
}

