/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.Operations;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.elasticsearch.BBOXRemovingFilterVisitor;
import org.geotools.process.elasticsearch.BasicGeoHashGrid;
import org.geotools.process.elasticsearch.GeoHashGrid;
import org.geotools.process.elasticsearch.GridCoverageUtil;
import org.geotools.process.elasticsearch.MetricGeoHashGrid;
import org.geotools.process.elasticsearch.NestedAggGeoHashGrid;
import org.geotools.process.elasticsearch.RasterScale;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="geoHashGridAgg", description="Computes a grid from GeoHash grid aggregation buckets with values corresponding to doc_count values.")
public class GeoHashGridProcess
implements VectorProcess {
    private static final FilterFactory FILTER_FACTORY = CommonFactoryFinder.getFilterFactory(null);

    @DescribeResult(description="Output raster")
    public GridCoverage2D execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="pixelsPerCell", description="Resolution used for upsampling (in pixels)", defaultValue="1", min=1) Integer argPixelsPerCell, @DescribeParameter(name="gridStrategy", description="GeoHash grid strategy", defaultValue="Basic", min=1) String gridStrategy, @DescribeParameter(name="gridStrategyArgs", description="Grid strategy arguments", min=0) List<String> gridStrategyArgs, @DescribeParameter(name="emptyCellValue", description="Default cell value", min=0) Float emptyCellValue, @DescribeParameter(name="scaleMin", description="Scale minimum", defaultValue="0") Float scaleMin, @DescribeParameter(name="scaleMax", description="Scale maximum", min=0) Float scaleMax, @DescribeParameter(name="useLog", description="Whether to use log values (default=false)", defaultValue="false") Boolean useLog, @DescribeParameter(name="outputBBOX", description="Bounding box of the output") ReferencedEnvelope argOutputEnv, @DescribeParameter(name="outputWidth", description="Width of output raster in pixels") Integer argOutputWidth, @DescribeParameter(name="outputHeight", description="Height of output raster in pixels") Integer argOutputHeight, ProgressListener monitor) throws ProcessException {
        try {
            GeoHashGrid geoHashGrid = Strategy.valueOf(gridStrategy.toUpperCase()).createNewInstance();
            geoHashGrid.setParams(gridStrategyArgs);
            geoHashGrid.setEmptyCellValue(emptyCellValue);
            geoHashGrid.setScale(new RasterScale(scaleMin, scaleMax, useLog));
            geoHashGrid.initalize(argOutputEnv, obsFeatures);
            GridCoverage2D nativeCoverage = geoHashGrid.toGridCoverage2D();
            GridCoverage2D transformedCoverage = (GridCoverage2D)Operations.DEFAULT.resample((Coverage)nativeCoverage, argOutputEnv.getCoordinateReferenceSystem());
            GridCoverage2D scaledCoverage = GridCoverageUtil.scale(transformedCoverage, argOutputWidth * argPixelsPerCell, argOutputHeight * argPixelsPerCell);
            GridCoverage2D croppedCoverage = GridCoverageUtil.crop(scaledCoverage, (Envelope)argOutputEnv);
            return GridCoverageUtil.scale(croppedCoverage, argOutputWidth.intValue(), argOutputHeight.intValue());
        }
        catch (Exception e) {
            throw new ProcessException("Error executing GeoHashGridProcess", (Throwable)e);
        }
    }

    public Query invertQuery(@DescribeParameter(name="outputBBOX", description="Georeferenced bounding box of the output") ReferencedEnvelope envelope, Query targetQuery, GridGeometry targetGridGeometry) throws ProcessException {
        BBOXRemovingFilterVisitor visitor = new BBOXRemovingFilterVisitor();
        Filter filter = (Filter)targetQuery.getFilter().accept((FilterVisitor)visitor, null);
        String geometryName = visitor.getGeometryPropertyName();
        if (geometryName != null) {
            BBOX bbox;
            try {
                if (envelope.getCoordinateReferenceSystem() != null) {
                    envelope = envelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, false);
                }
                bbox = FILTER_FACTORY.bbox(geometryName, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), "EPSG:4326");
            }
            catch (Exception e) {
                throw new ProcessException("Unable to create bbox filter for feature source", (Throwable)e);
            }
            filter = (Filter)FILTER_FACTORY.and(filter, (Filter)bbox).accept((FilterVisitor)new SimplifyingFilterVisitor(), null);
            targetQuery.setFilter(filter);
        }
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        properties.add(FILTER_FACTORY.property("_aggregation"));
        targetQuery.setProperties(properties);
        return targetQuery;
    }

    public static enum Strategy {
        BASIC(BasicGeoHashGrid.class),
        METRIC(MetricGeoHashGrid.class),
        NESTED_AGG(NestedAggGeoHashGrid.class);

        private final Class<? extends GeoHashGrid> clazz;

        private Strategy(Class<? extends GeoHashGrid> clazz) {
            this.clazz = clazz;
        }

        GeoHashGrid createNewInstance() throws ReflectiveOperationException {
            return this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }
}

