/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.elasticsearch;

import com.github.davidmoten.geo.GeoHash;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.Operations;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class GridCoverageUtil {
    GridCoverageUtil() {
    }

    public static GridCoverage2D scale(GridCoverage2D coverage, float width, float height) {
        RenderedImage renderedImage = coverage.getRenderedImage();
        Raster renderedGrid = renderedImage.getData();
        float yScale = width / (float)renderedGrid.getWidth();
        float xScale = height / (float)renderedGrid.getHeight();
        Operations ops = new Operations(null);
        return (GridCoverage2D)ops.scale((GridCoverage)coverage, (double)xScale, (double)yScale, 0.0, 0.0);
    }

    public static GridCoverage2D crop(GridCoverage2D coverage, Envelope envelope) {
        CoverageProcessor processor = new CoverageProcessor();
        ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters();
        GeneralEnvelope crop = new GeneralEnvelope(envelope);
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("Envelope").setValue((Object)crop);
        return (GridCoverage2D)processor.doOperation(param);
    }

    public static ReferencedEnvelope pad(org.locationtech.jts.geom.Envelope envelope, int precision) {
        double cellWidth = GeoHash.widthDegrees((int)precision);
        double cellHeight = GeoHash.widthDegrees((int)precision);
        double minLon = Math.max(-180.0 + cellWidth / 2.0, envelope.getMinX() - cellWidth);
        double maxLon = Math.min(180.0 - cellWidth / 2.0, envelope.getMaxX() + cellWidth);
        double minLat = Math.max(-90.0 + cellHeight / 2.0, envelope.getMinY() - cellHeight);
        double maxLat = Math.min(90.0 - cellHeight / 2.0, envelope.getMaxY() + cellHeight);
        return new ReferencedEnvelope(minLon, maxLon, minLat, maxLat, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }
}

