/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch.date;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.data.elasticsearch.date.DateFormat;
import org.geotools.data.elasticsearch.date.DateFormatter;
import org.springframework.util.Assert;

public final class ElasticsearchDateConverter {
    private static final ConcurrentHashMap<String, ElasticsearchDateConverter> patternConverters = new ConcurrentHashMap();
    private static final ConcurrentHashMap<DateFormat, ElasticsearchDateConverter> dateFormatConverters = new ConcurrentHashMap();
    private final DateFormatter dateFormatter;

    public static ElasticsearchDateConverter forFormat(String format) {
        try {
            DateFormat dateFormat = DateFormat.valueOf(format);
            return ElasticsearchDateConverter.of(dateFormat);
        }
        catch (IllegalArgumentException e) {
            return ElasticsearchDateConverter.of(format);
        }
    }

    public static ElasticsearchDateConverter of(DateFormat dateFormat) {
        Assert.notNull((Object)((Object)dateFormat), (String)"dateFormat must not be null");
        return dateFormatConverters.computeIfAbsent(dateFormat, d -> new ElasticsearchDateConverter(ElasticsearchDateConverter.forDateFormat(d)));
    }

    public static ElasticsearchDateConverter of(String pattern) {
        Assert.notNull((Object)pattern, (String)"pattern must not be null");
        Assert.hasText((String)pattern, (String)"pattern must not be empty");
        String[] subPatterns = pattern.split("\\|\\|");
        return patternConverters.computeIfAbsent(subPatterns[0].trim(), p -> new ElasticsearchDateConverter(ElasticsearchDateConverter.forPattern(p)));
    }

    private ElasticsearchDateConverter(DateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public String format(TemporalAccessor accessor) {
        Assert.notNull((Object)"accessor", (String)"accessor must not be null");
        if (accessor instanceof Instant) {
            Instant instant = (Instant)accessor;
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.of("UTC"));
            return this.dateFormatter.format(zonedDateTime);
        }
        return this.dateFormatter.format(accessor);
    }

    public String format(Date date) {
        Assert.notNull((Object)date, (String)"accessor must not be null");
        return this.dateFormatter.format(Instant.ofEpochMilli(date.getTime()));
    }

    public <T extends TemporalAccessor> T parse(String input, Class<T> type) {
        return this.dateFormatter.parse(input, type);
    }

    public Date parse(String input) {
        return new Date(this.dateFormatter.parse(input, Instant.class).toEpochMilli());
    }

    private static DateFormatter forDateFormat(DateFormat format) {
        if (DateFormat.epoch_millis.equals((Object)format)) {
            return new EpochMillisDateFormatter();
        }
        if (DateFormat.epoch_second.equals((Object)format)) {
            return new EpochSecondDateFormatter();
        }
        if (DateFormat.date_optional_time.equals((Object)format)) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().appendPattern("[X]").toFormatter();
            DateTimeFormatter fullParser = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().appendPattern("[VV][X]").toFormatter();
            DateTimeFormatter simplifiedParser = DateTimeFormatter.ofPattern("[uuuu-M[-d['T'H[:m[:s]]]]]");
            DateTimeFormatter parser = new DateTimeFormatterBuilder().appendOptional(fullParser).appendOptional(simplifiedParser).toFormatter();
            return new PatternDateFormatter(formatter, parser);
        }
        String parsePattern = format.getParsePattern();
        String formatPattern = format.getFormatPattern();
        DateTimeFormatter parser = DateTimeFormatter.ofPattern(parsePattern);
        if (formatPattern.equals(parsePattern)) {
            return new PatternDateFormatter(parser, parser);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
        return new PatternDateFormatter(formatter, parser);
    }

    private static DateFormatter forPattern(String pattern) {
        try {
            DateFormat df = DateFormat.valueOf(pattern);
            return ElasticsearchDateConverter.forDateFormat(df);
        }
        catch (IllegalArgumentException e) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
            return new PatternDateFormatter(dateTimeFormatter, dateTimeFormatter);
        }
    }

    private static <T extends TemporalAccessor> TemporalQuery<T> getTemporalQuery(Class<T> type) {
        return temporal -> {
            if (type == HijrahDate.class) {
                return HijrahDate.from(temporal);
            }
            if (type == JapaneseDate.class) {
                return JapaneseDate.from(temporal);
            }
            if (type == ZonedDateTime.class) {
                return ZonedDateTime.from(temporal);
            }
            if (type == LocalDateTime.class) {
                return LocalDateTime.from(temporal);
            }
            if (type == ThaiBuddhistDate.class) {
                return ThaiBuddhistDate.from(temporal);
            }
            if (type == LocalTime.class) {
                return LocalTime.from(temporal);
            }
            if (type == ZoneOffset.class) {
                return ZoneOffset.from(temporal);
            }
            if (type == OffsetTime.class) {
                return OffsetTime.from(temporal);
            }
            if (type == ChronoLocalDate.class) {
                return ChronoLocalDate.from(temporal);
            }
            if (type == Month.class) {
                return Month.from(temporal);
            }
            if (type == ChronoLocalDateTime.class) {
                return ChronoLocalDateTime.from(temporal);
            }
            if (type == MonthDay.class) {
                return MonthDay.from(temporal);
            }
            if (type == Instant.class) {
                return Instant.from(temporal);
            }
            if (type == OffsetDateTime.class) {
                return OffsetDateTime.from(temporal);
            }
            if (type == ChronoZonedDateTime.class) {
                return ChronoZonedDateTime.from(temporal);
            }
            if (type == MinguoDate.class) {
                return MinguoDate.from(temporal);
            }
            if (type == Year.class) {
                return Year.from(temporal);
            }
            if (type == DayOfWeek.class) {
                return DayOfWeek.from(temporal);
            }
            if (type == LocalDate.class) {
                return LocalDate.from(temporal);
            }
            if (type == YearMonth.class) {
                return YearMonth.from(temporal);
            }
            try {
                Method method = type.getMethod("from", TemporalAccessor.class);
                Object o = method.invoke(null, temporal);
                return (TemporalAccessor)type.cast(o);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("no 'from' factory method found in class " + type.getName());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("could not create object of class " + type.getName(), e);
            }
        };
    }

    static class PatternDateFormatter
    implements DateFormatter {
        private final DateTimeFormatter formatter;
        private final DateTimeFormatter parser;

        PatternDateFormatter(DateTimeFormatter formatter, DateTimeFormatter parser) {
            this.formatter = formatter;
            this.parser = parser;
        }

        @Override
        public String format(TemporalAccessor accessor) {
            Assert.notNull((Object)accessor, (String)"accessor must not be null");
            try {
                return this.formatter.format(accessor);
            }
            catch (Exception e) {
                if (accessor instanceof Instant) {
                    return this.formatter.format(ZonedDateTime.ofInstant((Instant)accessor, ZoneId.of("UTC")));
                }
                throw e;
            }
        }

        @Override
        public <T extends TemporalAccessor> T parse(String input, Class<T> type) {
            Assert.notNull((Object)input, (String)"input must not be null");
            Assert.notNull(type, (String)"type must not be null");
            try {
                return (T)((TemporalAccessor)this.parser.parse((CharSequence)input, ElasticsearchDateConverter.getTemporalQuery(type)));
            }
            catch (Exception exception) {
                if (type.equals(Instant.class)) {
                    TemporalAccessor accessor = this.parser.parse(input);
                    if (accessor.isSupported(ChronoField.OFFSET_SECONDS) && accessor.isSupported(ChronoField.YEAR) && accessor.isSupported(ChronoField.MONTH_OF_YEAR)) {
                        ZonedDateTime zonedDateTime = accessor.query(ElasticsearchDateConverter.getTemporalQuery(ZonedDateTime.class));
                        return (T)zonedDateTime.toInstant();
                    }
                    if (accessor.isSupported(ChronoField.YEAR) && accessor.isSupported(ChronoField.MONTH_OF_YEAR)) {
                        if (accessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                            LocalDateTime localDateTime = accessor.query(ElasticsearchDateConverter.getTemporalQuery(LocalDateTime.class));
                            return (T)localDateTime.toInstant(ZoneOffset.UTC);
                        }
                        YearMonth ym = accessor.query(ElasticsearchDateConverter.getTemporalQuery(YearMonth.class));
                        return (T)ym.atDay(1).atStartOfDay().toInstant(ZoneOffset.UTC);
                    }
                    if (accessor.isSupported(ChronoField.YEAR)) {
                        Year y = accessor.query(ElasticsearchDateConverter.getTemporalQuery(Year.class));
                        return (T)y.atDay(1).atStartOfDay().toInstant(ZoneOffset.UTC);
                    }
                    if (accessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                        LocalTime lt = accessor.query(ElasticsearchDateConverter.getTemporalQuery(LocalTime.class));
                        return (T)lt.atDate(LocalDate.ofEpochDay(0L)).toInstant(ZoneOffset.UTC);
                    }
                }
                throw exception;
            }
        }
    }

    static class EpochSecondDateFormatter
    implements DateFormatter {
        EpochSecondDateFormatter() {
        }

        @Override
        public String format(TemporalAccessor accessor) {
            Assert.notNull((Object)accessor, (String)"accessor must not be null");
            long epochMilli = Instant.from(accessor).toEpochMilli();
            long fraction = epochMilli % 1000L;
            if (fraction == 0L) {
                return Long.toString(epochMilli / 1000L);
            }
            Double d = (double)epochMilli / 1000.0;
            return String.format(Locale.ROOT, "%.03f", d);
        }

        @Override
        public <T extends TemporalAccessor> T parse(String input, Class<T> type) {
            Assert.notNull((Object)input, (String)"input must not be null");
            Assert.notNull(type, (String)"type must not be null");
            Double epochMilli = Double.parseDouble(input) * 1000.0;
            Instant instant = Instant.ofEpochMilli(epochMilli.longValue());
            TemporalQuery<T> query = ElasticsearchDateConverter.getTemporalQuery(type);
            return (T)((TemporalAccessor)query.queryFrom(instant));
        }
    }

    static class EpochMillisDateFormatter
    implements DateFormatter {
        EpochMillisDateFormatter() {
        }

        @Override
        public String format(TemporalAccessor accessor) {
            Assert.notNull((Object)accessor, (String)"accessor must not be null");
            return Long.toString(Instant.from(accessor).toEpochMilli());
        }

        @Override
        public <T extends TemporalAccessor> T parse(String input, Class<T> type) {
            Assert.notNull((Object)input, (String)"input must not be null");
            Assert.notNull(type, (String)"type must not be null");
            Instant instant = Instant.ofEpochMilli(Long.parseLong(input));
            TemporalQuery<T> query = ElasticsearchDateConverter.getTemporalQuery(type);
            return (T)((TemporalAccessor)query.queryFrom(instant));
        }
    }
}

