/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.elasticsearch.ElasticAttribute;
import org.geotools.data.elasticsearch.ElasticConstants;
import org.geotools.data.elasticsearch.FilterToElastic;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Within;
import org.opengis.geometry.BoundingBox;

class FilterToElasticHelper {
    private String key;
    private Map<String, Object> shapeBuilder;
    static final Map<String, Double> UNITS_MAP = new HashMap<String, Double>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("millimeter", 0.001);
            this.put("mm", 0.001);
            this.put("cm", 0.01);
            this.put("m", 1.0);
            this.put("kilometers", 1000.0);
            this.put("kilometer", 1000.0);
            this.put("km", 1000.0);
            this.put("in", 0.0254);
            this.put("ft", 0.3048);
            this.put("feet", 0.3048);
            this.put("yd", 0.9144);
            this.put("mi", 1609.344);
            this.put("miles", 1609.344);
            this.put("NM", 1852.0);
            this.put("nmi", 1852.0);
        }
    };
    private static final Envelope WORLD = new Envelope(-180.0, 180.0, -90.0, 90.0);
    private final FilterToElastic delegate;

    public FilterToElasticHelper(FilterToElastic delegate) {
        this.delegate = delegate;
    }

    Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        if (filter instanceof DistanceBufferOperator) {
            this.visitDistanceSpatialOperator((DistanceBufferOperator)filter, property, geometry, swapped, extraData);
        } else {
            this.visitComparisonSpatialOperator(filter, property, geometry, swapped, extraData);
        }
        return extraData;
    }

    Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
        return extraData;
    }

    private void visitDistanceSpatialOperator(DistanceBufferOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        property.accept((ExpressionVisitor)this.delegate, extraData);
        this.key = (String)this.delegate.field;
        geometry.accept((ExpressionVisitor)this.delegate, extraData);
        Geometry geo = this.delegate.currentGeometry;
        double lat = geo.getCentroid().getY();
        double lon = geo.getCentroid().getX();
        double inputDistance = filter.getDistance();
        String inputUnits = filter.getDistanceUnits();
        double distance = Double.valueOf(this.toMeters(inputDistance, inputUnits));
        this.delegate.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must", ElasticConstants.MATCH_ALL, (Object)"filter", (Object)ImmutableMap.of((Object)"geo_distance", (Object)ImmutableMap.of((Object)"distance", (Object)(distance + "m"), (Object)this.key, (Object)ImmutableList.of((Object)lon, (Object)lat)))));
        if (filter instanceof DWithin && swapped || filter instanceof Beyond && !swapped) {
            this.delegate.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must_not", this.delegate.queryBuilder));
        }
    }

    private String toMeters(double distance, String unit) {
        Double conversion = UNITS_MAP.get(unit);
        if (conversion != null) {
            return String.valueOf(distance * conversion);
        }
        return String.valueOf(distance);
    }

    private void visitComparisonSpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        Literal geometry1 = this.clipToWorld(geometry);
        this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry1, swapped, extraData);
        if (this.isWorld(geometry1)) {
            this.delegate.queryBuilder = ElasticConstants.MATCH_ALL;
            return;
        }
        if (this.isEmpty(geometry1)) {
            this.delegate.queryBuilder = !(filter instanceof Disjoint) ? ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must_not", ElasticConstants.MATCH_ALL)) : ElasticConstants.MATCH_ALL;
            return;
        }
        this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry1, swapped, extraData);
    }

    private void visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        AttributeDescriptor attType = (AttributeDescriptor)e1.evaluate((Object)this.delegate.featureType);
        ElasticAttribute.ElasticGeometryType geometryType = (ElasticAttribute.ElasticGeometryType)((Object)attType.getUserData().get("geometry_type"));
        if (geometryType == ElasticAttribute.ElasticGeometryType.GEO_POINT) {
            this.visitGeoPointBinarySpatialOperator(filter, e1, e2, swapped, extraData);
        } else {
            this.visitGeoShapeBinarySpatialOperator(filter, e1, e2, swapped, extraData);
        }
    }

    private void visitGeoShapeBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        SpatialRelation shapeRelation;
        if (filter instanceof Disjoint) {
            shapeRelation = SpatialRelation.DISJOINT;
        } else if (!swapped && filter instanceof Within || swapped && filter instanceof Contains) {
            shapeRelation = SpatialRelation.WITHIN;
        } else if (filter instanceof Intersects || filter instanceof BBOX) {
            shapeRelation = SpatialRelation.INTERSECTS;
        } else {
            FilterToElastic.LOGGER.fine(filter.getClass().getSimpleName() + " is unsupported for geo_shape types");
            shapeRelation = null;
            this.delegate.fullySupported = false;
        }
        if (shapeRelation != null) {
            e1.accept((ExpressionVisitor)this.delegate, extraData);
            this.key = (String)this.delegate.field;
            e2.accept((ExpressionVisitor)this.delegate, extraData);
            this.shapeBuilder = this.delegate.currentShapeBuilder;
        }
        if (shapeRelation != null && this.shapeBuilder != null) {
            ImmutableMap geo = ImmutableMap.of((Object)"shape", this.shapeBuilder, (Object)"relation", (Object)shapeRelation);
            this.delegate.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must", ElasticConstants.MATCH_ALL, (Object)"filter", (Object)ImmutableMap.of((Object)"geo_shape", (Object)ImmutableMap.of((Object)this.key, (Object)geo))));
        } else {
            this.delegate.queryBuilder = ElasticConstants.MATCH_ALL;
        }
    }

    private void visitGeoPointBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        e1.accept((ExpressionVisitor)this.delegate, extraData);
        this.key = (String)this.delegate.field;
        e2.accept((ExpressionVisitor)this.delegate, extraData);
        Geometry geometry = this.delegate.currentGeometry;
        if (geometry instanceof Polygon && (!swapped && filter instanceof Within || swapped && filter instanceof Contains || filter instanceof Intersects)) {
            Polygon polygon = (Polygon)geometry;
            ArrayList<ImmutableList> points = new ArrayList<ImmutableList>();
            for (Coordinate coordinate : polygon.getCoordinates()) {
                points.add(ImmutableList.of((Object)coordinate.x, (Object)coordinate.y));
            }
            this.delegate.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must", ElasticConstants.MATCH_ALL, (Object)"filter", (Object)ImmutableMap.of((Object)"geo_polygon", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"points", points)))));
        } else if (filter instanceof BBOX) {
            double maxX;
            double minX;
            BoundingBox envelope = ((BBOX)filter).getBounds();
            double minY = this.clipLat(envelope.getMinY());
            double maxY = this.clipLat(envelope.getMaxY());
            if (envelope.getWidth() < 360.0) {
                minX = this.clipLon(envelope.getMinX());
                maxX = this.clipLon(envelope.getMaxX());
            } else {
                minX = -180.0;
                maxX = 180.0;
            }
            ImmutableMap geo = ImmutableMap.of((Object)"top_left", (Object)ImmutableList.of((Object)minX, (Object)maxY), (Object)"bottom_right", (Object)ImmutableList.of((Object)maxX, (Object)minY));
            this.delegate.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must", ElasticConstants.MATCH_ALL, (Object)"filter", (Object)ImmutableMap.of((Object)"geo_bounding_box", (Object)ImmutableMap.of((Object)this.key, (Object)geo))));
        } else {
            FilterToElastic.LOGGER.fine(filter.getClass().getSimpleName() + " is unsupported for geo_point types");
            this.delegate.fullySupported = false;
            this.delegate.queryBuilder = ElasticConstants.MATCH_ALL;
        }
    }

    private Literal clipToWorld(Literal geometry) {
        Geometry g;
        if (geometry != null && (g = (Geometry)geometry.evaluate(null, Geometry.class)) != null) {
            g.apply(coord -> coord.setCoordinate(new Coordinate(this.clipLon(coord.x), this.clipLat(coord.y))));
            geometry = CommonFactoryFinder.getFilterFactory(null).literal((Object)g);
        }
        return geometry;
    }

    private double clipLon(double lon) {
        double x = Math.signum(lon) * (Math.abs(lon) % 360.0);
        return x > 180.0 ? x - 360.0 : (x < -180.0 ? x + 360.0 : x);
    }

    private double clipLat(double lat) {
        return Math.min(90.0, Math.max(-90.0, lat));
    }

    private boolean isWorld(Literal geometry) {
        Geometry g;
        boolean result = false;
        if (geometry != null && (g = (Geometry)geometry.evaluate(null, Geometry.class)) != null) {
            result = JTS.toGeometry((Envelope)WORLD).equalsTopo(g.union());
        }
        return result;
    }

    private boolean isEmpty(Literal geometry) {
        boolean result = false;
        if (geometry != null) {
            Geometry g = (Geometry)geometry.evaluate(null, Geometry.class);
            result = g == null || g.isEmpty();
        }
        return result;
    }
}

