/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.elasticsearch.ElasticCapabilities;
import org.geotools.data.elasticsearch.ElasticConstants;
import org.geotools.data.elasticsearch.ElasticParserUtil;
import org.geotools.data.elasticsearch.FilterToElasticException;
import org.geotools.data.elasticsearch.FilterToElasticHelper;
import org.geotools.data.elasticsearch.GeohashUtil;
import org.geotools.data.elasticsearch.date.DateFormat;
import org.geotools.data.elasticsearch.date.ElasticsearchDateConverter;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Capabilities;
import org.geotools.process.elasticsearch.ElasticBucketVisitor;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.temporal.Period;

class FilterToElastic
implements FilterVisitor,
ExpressionVisitor {
    static final Logger LOGGER = Logging.getLogger(FilterToElastic.class);
    private static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectReader mapReader = mapper.readerWithView(Map.class).forType(HashMap.class);
    private static final ElasticsearchDateConverter DEFAULT_DATE_FORMATTER = ElasticsearchDateConverter.of(DateFormat.date_optional_time);
    private Capabilities capabilities = null;
    SimpleFeatureType featureType;
    Geometry currentGeometry;
    Object field;
    Map<String, Object> currentShapeBuilder;
    Boolean fullySupported;
    Map<String, Object> queryBuilder = ElasticConstants.MATCH_ALL;
    Map<String, Object> nativeQueryBuilder = ImmutableMap.of((Object)"match_all", Collections.emptyMap());
    Map<String, Map<String, Map<String, Object>>> aggregations;
    private final FilterToElasticHelper helper = new FilterToElasticHelper(this);
    private String key;
    private Object lower;
    private Boolean nested;
    private String path;
    private String op;
    private Object begin;
    private Object end;
    private ElasticsearchDateConverter dateFormatter;

    public void encode(Filter filter) throws FilterToElasticException {
        this.fullySupported = this.getCapabilities().fullySupports(filter);
        filter.accept((FilterVisitor)this, null);
    }

    public void encode(Query query) throws FilterToElasticException {
        this.encode(query.getFilter());
        this.addViewParams(query);
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    Capabilities createCapabilities() {
        return new ElasticCapabilities();
    }

    private synchronized Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.createCapabilities();
        }
        return this.capabilities;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        this.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must_not", ElasticConstants.MATCH_ALL));
        return extraData;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        this.queryBuilder = ElasticConstants.MATCH_ALL;
        return extraData;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        Class context;
        LOGGER.finest("exporting PropertyIsBetween");
        Expression expr = filter.getExpression();
        Expression lowerbounds = filter.getLowerBoundary();
        Expression upperbounds = filter.getUpperBoundary();
        this.nested = false;
        AttributeDescriptor attType = (AttributeDescriptor)expr.evaluate((Object)this.featureType);
        if (attType != null) {
            context = attType.getType().getBinding();
            if (attType.getUserData().containsKey("nested")) {
                this.nested = (Boolean)attType.getUserData().get("nested");
            }
            if (Date.class.isAssignableFrom(context)) {
                this.updateDateFormatter(attType);
            }
        } else {
            context = String.class;
        }
        expr.accept((ExpressionVisitor)this, extraData);
        this.key = (String)this.field;
        lowerbounds.accept((ExpressionVisitor)this, (Object)context);
        this.lower = this.field;
        upperbounds.accept((ExpressionVisitor)this, (Object)context);
        Object upper = this.field;
        if (this.nested.booleanValue()) {
            this.path = FilterToElastic.extractNestedPath(this.key);
        }
        this.queryBuilder = ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"gte", (Object)this.lower, (Object)"lte", (Object)upper)));
        if (this.nested.booleanValue()) {
            this.queryBuilder = ImmutableMap.of((Object)"nested", (Object)ImmutableMap.of((Object)"path", (Object)this.path, (Object)"query", this.queryBuilder));
        }
        return extraData;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        char esc = filter.getEscape().charAt(0);
        char multi = filter.getWildCard().charAt(0);
        char single = filter.getSingleChar().charAt(0);
        if (filter.isMatchingCase()) {
            LOGGER.fine("Case sensitive search not supported");
        }
        String literal = filter.getLiteral();
        Expression att = filter.getExpression();
        AttributeDescriptor attType = (AttributeDescriptor)att.evaluate((Object)this.featureType);
        Boolean analyzed = false;
        this.nested = false;
        if (attType != null) {
            if (attType.getUserData().containsKey("analyzed")) {
                analyzed = (Boolean)attType.getUserData().get("analyzed");
            }
            if (attType.getUserData().containsKey("nested")) {
                this.nested = (Boolean)attType.getUserData().get("nested");
            }
            if (Date.class.isAssignableFrom(attType.getType().getBinding())) {
                this.updateDateFormatter(attType);
            }
        }
        att.accept((ExpressionVisitor)this, extraData);
        this.key = (String)this.field;
        String pattern = analyzed != false ? FilterToElastic.convertToQueryString(esc, multi, single, literal) : FilterToElastic.convertToRegex(esc, multi, single, literal);
        if (this.nested.booleanValue()) {
            this.path = FilterToElastic.extractNestedPath(this.key);
        }
        this.queryBuilder = analyzed != false ? ImmutableMap.of((Object)"query_string", (Object)ImmutableMap.of((Object)"query", (Object)pattern, (Object)"default_field", (Object)this.key)) : ImmutableMap.of((Object)"regexp", (Object)ImmutableMap.of((Object)this.key, (Object)pattern));
        if (this.nested.booleanValue()) {
            this.queryBuilder = ImmutableMap.of((Object)"nested", (Object)ImmutableMap.of((Object)"path", (Object)this.path, (Object)"query", this.queryBuilder));
        }
        return extraData;
    }

    public Object visit(And filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"AND");
    }

    public Object visit(Not filter, Object extraData) {
        if (filter.getFilter() instanceof PropertyIsNull) {
            Expression expr = ((PropertyIsNull)filter.getFilter()).getExpression();
            expr.accept((ExpressionVisitor)this, extraData);
        } else {
            filter.getFilter().accept((FilterVisitor)this, extraData);
        }
        this.queryBuilder = filter.getFilter() instanceof PropertyIsNull ? ImmutableMap.of((Object)"exists", (Object)ImmutableMap.of((Object)"field", (Object)this.field)) : ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must_not", this.queryBuilder));
        return extraData;
    }

    public Object visit(Or filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"OR");
    }

    private Object visit(BinaryLogicOperator filter, Object extraData) {
        LOGGER.finest("exporting LogicFilter");
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>();
        for (Filter child : filter.getChildren()) {
            child.accept((FilterVisitor)this, extraData);
            filters.add(this.queryBuilder);
        }
        if (extraData.equals("AND")) {
            this.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must", filters));
        } else if (extraData.equals("OR")) {
            this.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"should", filters));
        }
        return extraData;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">");
        return extraData;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<");
        return extraData;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<=");
        return extraData;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "!=");
        return extraData;
    }

    private void visitBinaryComparisonOperator(BinaryComparisonOperator filter, Object extraData) {
        LOGGER.finest("exporting FilterBuilder ComparisonFilter");
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        if (this.isBinaryExpression(left) || this.isBinaryExpression(right)) {
            throw new UnsupportedOperationException("Binary expressions not supported");
        }
        AttributeDescriptor attType = null;
        Class leftContext = null;
        Class rightContext = null;
        if (left instanceof PropertyName && (attType = (AttributeDescriptor)left.evaluate((Object)this.featureType)) != null) {
            rightContext = attType.getType().getBinding();
        }
        if (right instanceof PropertyName && (attType = (AttributeDescriptor)right.evaluate((Object)this.featureType)) != null) {
            leftContext = attType.getType().getBinding();
        }
        this.nested = false;
        if (attType != null) {
            if (attType.getUserData().containsKey("nested")) {
                this.nested = (Boolean)attType.getUserData().get("nested");
            }
            if (Date.class.isAssignableFrom(attType.getType().getBinding())) {
                this.updateDateFormatter(attType);
            }
        }
        if (!filter.isMatchingCase() && (filter instanceof PropertyIsEqualTo || filter instanceof PropertyIsNotEqualTo) && (String.class.equals((Object)leftContext) || String.class.equals((Object)rightContext))) {
            LOGGER.fine("Case insensitive filter not supported");
        }
        String type = (String)extraData;
        if (left instanceof PropertyName) {
            left.accept((ExpressionVisitor)this, null);
            this.key = (String)this.field;
            right.accept((ExpressionVisitor)this, (Object)rightContext);
        } else {
            right.accept((ExpressionVisitor)this, null);
            this.key = (String)this.field;
            left.accept((ExpressionVisitor)this, (Object)leftContext);
        }
        if (this.nested.booleanValue()) {
            this.path = FilterToElastic.extractNestedPath(this.key);
        }
        switch (type) {
            case "=": {
                this.queryBuilder = ImmutableMap.of((Object)"term", (Object)ImmutableMap.of((Object)this.key, (Object)this.field));
                break;
            }
            case "!=": {
                this.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must_not", (Object)ImmutableMap.of((Object)"term", (Object)ImmutableMap.of((Object)this.key, (Object)this.field))));
                break;
            }
            case ">": {
                this.queryBuilder = ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"gt", (Object)this.field)));
                break;
            }
            case ">=": {
                this.queryBuilder = ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"gte", (Object)this.field)));
                break;
            }
            case "<": {
                this.queryBuilder = ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"lt", (Object)this.field)));
                break;
            }
            case "<=": {
                this.queryBuilder = ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"lte", (Object)this.field)));
            }
        }
        if (this.nested.booleanValue()) {
            this.queryBuilder = ImmutableMap.of((Object)"nested", (Object)ImmutableMap.of((Object)"path", (Object)this.path, (Object)"query", this.queryBuilder));
        }
    }

    private boolean isBinaryExpression(Expression e) {
        return e instanceof BinaryExpression;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        LOGGER.finest("exporting NullFilter");
        Expression expr = filter.getExpression();
        expr.accept((ExpressionVisitor)this, extraData);
        this.queryBuilder = ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must_not", (Object)ImmutableMap.of((Object)"exists", (Object)ImmutableMap.of((Object)"field", (Object)this.field))));
        return extraData;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("isNil not supported");
    }

    public Object visit(Id filter, Object extraData) {
        ArrayList<String> idList = new ArrayList<String>();
        for (Identifier id : filter.getIdentifiers()) {
            idList.add(id.toString());
        }
        this.queryBuilder = ImmutableMap.of((Object)"ids", (Object)ImmutableMap.of((Object)"values", idList));
        return extraData;
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    private Object visitBinarySpatialOperator(BinarySpatialOperator filter, Object extraData) {
        if (filter == null) {
            throw new NullPointerException("Filter to be encoded cannot be null");
        }
        Expression e1 = filter.getExpression1();
        Expression e2 = filter.getExpression2();
        if (e1 instanceof Literal && e2 instanceof PropertyName) {
            e1 = filter.getExpression2();
            e2 = filter.getExpression1();
        }
        if (e1 instanceof PropertyName && e2 instanceof Literal) {
            return this.visitBinarySpatialOperator(filter, (PropertyName)e1, (Literal)e2, filter.getExpression1() instanceof Literal, extraData);
        }
        return this.visitBinarySpatialOperator(filter, e1, e2, extraData);
    }

    private Object visitBinaryTemporalOperator(BinaryTemporalOperator filter, Object extraData) {
        if (filter == null) {
            throw new NullPointerException("Null filter");
        }
        Expression e1 = filter.getExpression1();
        Expression e2 = filter.getExpression2();
        if (e1 instanceof Literal && e2 instanceof PropertyName) {
            e1 = filter.getExpression2();
            e2 = filter.getExpression1();
        }
        if (e1 instanceof PropertyName && e2 instanceof Literal) {
            return this.visitBinaryTemporalOperator(filter, (PropertyName)e1, (Literal)e2, filter.getExpression1() instanceof Literal, extraData);
        }
        return this.visitBinaryTemporalOperator();
    }

    private Object visitBinaryTemporalOperator(BinaryTemporalOperator filter, PropertyName property, Literal temporal, boolean swapped, Object extraData) {
        AttributeDescriptor attType = (AttributeDescriptor)property.evaluate((Object)this.featureType);
        Class typeContext = null;
        this.nested = false;
        if (attType != null) {
            typeContext = attType.getType().getBinding();
            if (attType.getUserData().containsKey("nested")) {
                this.nested = (Boolean)attType.getUserData().get("nested");
            }
            this.updateDateFormatter(attType);
        }
        Period period = null;
        if (temporal.evaluate(null) instanceof Period) {
            period = (Period)temporal.evaluate(null);
        }
        if ((filter instanceof Begins || filter instanceof BegunBy || filter instanceof Ends || filter instanceof EndedBy || filter instanceof During || filter instanceof TContains) && period == null) {
            throw new IllegalArgumentException("Filter requires a time period");
        }
        if (filter instanceof TEquals && period != null) {
            throw new IllegalArgumentException("TEquals filter does not accept time period");
        }
        if ((filter instanceof Begins || filter instanceof Ends || filter instanceof During) && swapped) {
            throw new IllegalArgumentException("Time period must be second argument of Filter");
        }
        if ((filter instanceof BegunBy || filter instanceof EndedBy || filter instanceof TContains) && !swapped) {
            throw new IllegalArgumentException("Time period must be first argument of Filter");
        }
        this.key = "";
        if (filter instanceof After || filter instanceof Before) {
            String string = this.op = filter instanceof After ? " > " : " < ";
            if (period != null) {
                property.accept((ExpressionVisitor)this, extraData);
                this.key = (String)this.field;
                this.visitBegin(period, extraData);
                this.begin = this.field;
                this.visitEnd(period, extraData);
                this.end = this.field;
            } else {
                property.accept((ExpressionVisitor)this, extraData);
                this.key = (String)this.field;
                temporal.accept((ExpressionVisitor)this, (Object)typeContext);
            }
        } else if (filter instanceof Begins || filter instanceof Ends || filter instanceof BegunBy || filter instanceof EndedBy) {
            property.accept((ExpressionVisitor)this, extraData);
            this.key = (String)this.field;
            if (filter instanceof Begins || filter instanceof BegunBy) {
                this.visitBegin(period, extraData);
            } else {
                this.visitEnd(period, extraData);
            }
        } else if (filter instanceof During || filter instanceof TContains) {
            property.accept((ExpressionVisitor)this, extraData);
            this.key = (String)this.field;
            this.visitBegin(period, extraData);
            this.lower = this.field;
            this.visitEnd(period, extraData);
        } else if (filter instanceof TEquals) {
            property.accept((ExpressionVisitor)this, extraData);
            this.key = (String)this.field;
            temporal.accept((ExpressionVisitor)this, (Object)typeContext);
        }
        if (this.nested.booleanValue()) {
            this.path = FilterToElastic.extractNestedPath(this.key);
        }
        if (filter instanceof After || filter instanceof Before) {
            this.queryBuilder = period != null ? (this.op.equals(" > ") && !swapped || this.op.equals(" < ") && swapped ? ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"gt", (Object)this.end))) : ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"lt", (Object)this.begin)))) : (this.op.equals(" < ") || swapped ? ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"lt", (Object)this.field))) : ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"gt", (Object)this.field))));
        } else if (filter instanceof Begins || filter instanceof Ends || filter instanceof BegunBy || filter instanceof EndedBy) {
            this.queryBuilder = ImmutableMap.of((Object)"term", (Object)ImmutableMap.of((Object)this.key, (Object)this.field));
        } else if (filter instanceof During || filter instanceof TContains) {
            this.queryBuilder = ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)this.key, (Object)ImmutableMap.of((Object)"gt", (Object)this.lower, (Object)"lt", (Object)this.field)));
        } else if (filter instanceof TEquals) {
            this.queryBuilder = ImmutableMap.of((Object)"term", (Object)ImmutableMap.of((Object)this.key, (Object)this.field));
        }
        if (this.nested.booleanValue()) {
            this.queryBuilder = ImmutableMap.of((Object)"nested", (Object)ImmutableMap.of((Object)"path", (Object)this.path, (Object)"query", this.queryBuilder));
        }
        return extraData;
    }

    private void visitBegin(Period p, Object extraData) {
        filterFactory.literal((Object)p.getBeginning().getPosition().getDate()).accept((ExpressionVisitor)this, extraData);
    }

    private void visitEnd(Period p, Object extraData) {
        filterFactory.literal((Object)p.getEnding().getPosition().getDate()).accept((ExpressionVisitor)this, extraData);
    }

    Object visitBinaryTemporalOperator() {
        throw new UnsupportedOperationException("Join version of binary temporal operator not supported");
    }

    public Object visitNullFilter(Object extraData) {
        return extraData;
    }

    public Object visit(PropertyName expression, Object extraData) {
        String encodedField;
        AttributeDescriptor attType;
        LOGGER.finest("exporting PropertyName");
        SimpleFeatureType featureType = this.featureType;
        Class target = null;
        if (extraData instanceof Class) {
            target = (Class)extraData;
        }
        if ((attType = (AttributeDescriptor)expression.evaluate((Object)featureType)) != null) {
            Map userData = attType.getUserData();
            encodedField = userData != null && userData.containsKey("full_name") ? userData.get("full_name").toString() : attType.getLocalName();
            if (target != null && target.isAssignableFrom(attType.getType().getBinding())) {
                target = null;
            }
        } else {
            encodedField = expression.getPropertyName();
        }
        if (target != null) {
            LOGGER.fine("PropertyName type casting not implemented");
        }
        this.field = encodedField;
        return extraData;
    }

    public Object visit(Literal expression, Object context) throws FilterToElasticException {
        LOGGER.finest("exporting LiteralExpression");
        Class target = null;
        if (context instanceof Class) {
            target = (Class)context;
        }
        try {
            Object literal = this.evaluateLiteral(expression, target);
            if (literal instanceof Geometry) {
                this.visitLiteralGeometry(filterFactory.literal(literal));
            } else {
                this.writeLiteral(literal);
            }
        }
        catch (IOException e) {
            throw new FilterToElasticException("IO problems writing literal", e);
        }
        return context;
    }

    private Object evaluateLiteral(Literal expression, Class<?> target) {
        Number number;
        Object literal = null;
        if (target != null) {
            if (Number.class.isAssignableFrom(target)) {
                literal = this.safeConvertToNumber((Expression)expression, target);
                if (literal == null) {
                    literal = this.safeConvertToNumber((Expression)expression, Number.class);
                }
            } else {
                literal = expression.evaluate(null, target);
            }
        }
        if (target == null && (number = this.safeConvertToNumber((Expression)expression, Number.class)) != null) {
            literal = number;
        }
        if (literal == null) {
            literal = expression.evaluate(null);
        }
        if (literal == null) {
            literal = expression.getValue();
        }
        return literal;
    }

    private void writeLiteral(Object literal) {
        this.field = literal;
        if (Date.class.isAssignableFrom(literal.getClass())) {
            this.field = this.dateFormatter.format((Date)literal);
        }
    }

    void visitLiteralTimePeriod() {
        throw new UnsupportedOperationException("Time periods not supported, subclasses must implement this method to support encoding timeperiods");
    }

    public Object visit(Add expression, Object extraData) {
        throw new UnsupportedOperationException("Add expressions not supported");
    }

    public Object visit(Divide expression, Object extraData) {
        throw new UnsupportedOperationException("Divide expressions not supported");
    }

    public Object visit(Multiply expression, Object extraData) {
        throw new UnsupportedOperationException("Multiply expressions not supported");
    }

    public Object visit(Subtract expression, Object extraData) {
        throw new UnsupportedOperationException("Subtract expressions not supported");
    }

    public Object visit(NilExpression expression, Object extraData) {
        this.field = null;
        return extraData;
    }

    public Object visit(After after, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)after, extraData);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)anyInteracts, extraData);
    }

    public Object visit(Before before, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)before, extraData);
    }

    public Object visit(Begins begins, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)begins, extraData);
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)begunBy, extraData);
    }

    public Object visit(During during, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)during, extraData);
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)endedBy, extraData);
    }

    public Object visit(Ends ends, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)ends, extraData);
    }

    public Object visit(Meets meets, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)meets, extraData);
    }

    public Object visit(MetBy metBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)metBy, extraData);
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)overlappedBy, extraData);
    }

    public Object visit(TContains contains, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)contains, extraData);
    }

    public Object visit(TEquals equals, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)equals, extraData);
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)contains, extraData);
    }

    private void visitLiteralGeometry(Literal expression) throws IOException {
        this.currentGeometry = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (this.currentGeometry instanceof LinearRing) {
            GeometryFactory factory = this.currentGeometry.getFactory();
            LinearRing linearRing = (LinearRing)this.currentGeometry;
            CoordinateSequence coordinates = linearRing.getCoordinateSequence();
            this.currentGeometry = factory.createLineString(coordinates);
        }
        int maxDecimals = FilterToElastic.getMaxDecimalsForEnvelope(this.currentGeometry.getEnvelopeInternal());
        String geoJson = GeoJSONWriter.toGeoJSON((Geometry)this.currentGeometry, (int)maxDecimals);
        this.currentShapeBuilder = (Map)mapReader.readValue(geoJson);
    }

    protected static int getMaxDecimalsForEnvelope(Envelope envelope) {
        double min = Math.min(Math.abs(envelope.getWidth()), Math.abs(envelope.getHeight()));
        if (min == 0.0) {
            LOGGER.log(Level.WARNING, "BBox Geometry has no width or height, it is either a point or a line.");
            return JtsModule.DEFAULT_MAX_DECIMALS;
        }
        double decimalPart = min - Math.floor(min);
        if (decimalPart == 0.0) {
            return JtsModule.DEFAULT_MAX_DECIMALS;
        }
        double log = Math.log10(decimalPart);
        int numDecimals = Math.abs((int)Math.floor(log) + 1);
        if (numDecimals <= JtsModule.DEFAULT_MAX_DECIMALS) {
            return JtsModule.DEFAULT_MAX_DECIMALS;
        }
        return numDecimals;
    }

    private Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        return this.helper.visitBinarySpatialOperator(filter, property, geometry, swapped, extraData);
    }

    private Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        return this.helper.visitBinarySpatialOperator(filter, e1, e2, extraData);
    }

    public Object visit(Function function, Object extraData) {
        throw new UnsupportedOperationException("Function support not implemented");
    }

    private void updateDateFormatter(AttributeDescriptor attType) {
        List validFormats;
        if (attType != null && (validFormats = (List)attType.getUserData().get("date_format")) != null) {
            for (String format : validFormats) {
                try {
                    this.dateFormatter = ElasticsearchDateConverter.forFormat(format);
                    break;
                }
                catch (Exception e) {
                    LOGGER.fine("Unable to parse date format ('" + format + "') for " + String.valueOf(attType));
                }
            }
        }
        if (this.dateFormatter == null) {
            this.dateFormatter = DEFAULT_DATE_FORMATTER;
        }
    }

    private Number safeConvertToNumber(Expression expression, Class<?> target) {
        return (Number)Converters.convert((Object)expression.evaluate(null), target, (Hints)new Hints((RenderingHints.Key)ConverterFactory.SAFE_CONVERSION, (Object)true));
    }

    void addViewParams(Query query) {
        Map parameters;
        Hints hints = query.getHints();
        if (hints != null && hints.get((Object)ElasticBucketVisitor.ES_AGGREGATE_BUCKET) != null) {
            parameters = (Map)hints.get((Object)ElasticBucketVisitor.ES_AGGREGATE_BUCKET);
            boolean nativeOnly = false;
            for (Map.Entry entry : parameters.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("native-only")) continue;
                nativeOnly = Boolean.parseBoolean((String)entry.getValue());
            }
            if (nativeOnly) {
                LOGGER.fine("Ignoring GeoServer filter (Elasticsearch native query/post filter only)");
                this.queryBuilder = ElasticConstants.MATCH_ALL;
            }
            for (Map.Entry entry : parameters.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("q")) {
                    this.setupNativeQuery((String)entry.getValue());
                }
                if (!((String)entry.getKey()).equalsIgnoreCase("a")) continue;
                this.aggregations = GeohashUtil.parseAggregation((String)entry.getValue());
                Optional.ofNullable(this.aggregations).map(a -> (Map)a.get("agg")).map(a -> (Map)a.get("geohash_grid")).ifPresent(this::setGeometryField);
            }
        }
        if (hints != null && hints.get((Object)Hints.VIRTUAL_TABLE_PARAMETERS) != null) {
            parameters = (Map)hints.get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
            for (Map.Entry entry : parameters.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("q")) continue;
                this.setupNativeQuery((String)entry.getValue());
            }
        }
    }

    private void setupNativeQuery(String nativeQuery) {
        try {
            this.nativeQueryBuilder = (Map)mapReader.readValue(nativeQuery);
        }
        catch (Exception e) {
            try {
                this.nativeQueryBuilder = (Map)mapReader.readValue(ElasticParserUtil.urlDecode(nativeQuery));
            }
            catch (Exception e2) {
                throw new FilterToElasticException("Unable to parse native query", e);
            }
        }
    }

    private void setGeometryField(Map<String, Object> m) {
        if ("".equals(m.get("field"))) {
            GeometryDescriptor gd = this.featureType.getGeometryDescriptor();
            String name = (String)gd.getUserData().get("full_name");
            if (name == null) {
                name = gd.getLocalName();
            }
            m.put("field", name);
        }
    }

    public static String convertToQueryString(char escape, char multi, char single, String pattern) {
        StringBuilder result = new StringBuilder(pattern.length() + 5);
        for (int i = 0; i < pattern.length(); ++i) {
            char chr = pattern.charAt(i);
            if (chr == escape) {
                if (i != pattern.length() - 1) {
                    result.append("\\");
                    result.append(pattern.charAt(i + 1));
                }
                ++i;
                continue;
            }
            if (chr == single) {
                result.append('?');
                continue;
            }
            if (chr == multi) {
                result.append('*');
                continue;
            }
            result.append(chr);
        }
        return result.toString();
    }

    public static String convertToRegex(char escape, char multi, char single, String pattern) {
        StringBuilder result = new StringBuilder(pattern.length() + 5);
        for (int i = 0; i < pattern.length(); ++i) {
            char chr = pattern.charAt(i);
            if (chr == escape) {
                if (i != pattern.length() - 1) {
                    result.append("\\");
                    result.append(pattern.charAt(i + 1));
                }
                ++i;
                continue;
            }
            if (chr == single) {
                result.append('.');
                continue;
            }
            if (chr == multi) {
                result.append(".*");
                continue;
            }
            result.append(chr);
        }
        return result.toString();
    }

    private static String extractNestedPath(String field) {
        String[] parts = field.split("\\.");
        String base = parts[parts.length - 1];
        return field.replace("." + base, "");
    }

    public Boolean getFullySupported() {
        return this.fullySupported;
    }

    public Map<String, Object> getNativeQueryBuilder() {
        return this.nativeQueryBuilder;
    }

    public Map<String, Object> getQueryBuilder() {
        Object queryBuilder = this.nativeQueryBuilder.equals(ElasticConstants.MATCH_ALL) ? this.queryBuilder : (this.queryBuilder.equals(ElasticConstants.MATCH_ALL) ? this.nativeQueryBuilder : ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must", (Object)ImmutableList.of(this.nativeQueryBuilder, this.queryBuilder))));
        return queryBuilder;
    }

    public Map<String, Map<String, Map<String, Object>>> getAggregations() {
        return this.aggregations;
    }
}

