/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geotools.data.elasticsearch.ElasticAggregation;
import org.geotools.data.elasticsearch.ElasticHit;
import org.geotools.data.elasticsearch.ElasticResults;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ElasticResponse {
    @JsonProperty(value="hits")
    private ElasticResults results;
    @JsonProperty(value="aggregations")
    private Map<String, ElasticAggregation> aggregations;
    @JsonProperty(value="_scroll_id")
    private String scrollId;

    public ElasticResults getResults() {
        return this.results;
    }

    public Map<String, ElasticAggregation> getAggregations() {
        return this.aggregations;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    @JsonIgnore
    public List<ElasticHit> getHits() {
        List<ElasticHit> hits = this.results != null ? this.results.getHits() : new ArrayList<ElasticHit>();
        return hits;
    }

    public int getNumHits() {
        int numHits = this.results != null ? this.results.getHits().size() : 0;
        return numHits;
    }

    public long getTotalNumHits() {
        long total = this.results != null && this.results.getTotal() != null ? this.results.getTotal() : 0L;
        return total;
    }

    public float getMaxScore() {
        float maxScore = this.results != null && this.results.getMaxScore() != null ? this.results.getMaxScore().floatValue() : 0.0f;
        return maxScore;
    }

    public String toString() {
        return "ElasticResponse[total=" + this.getTotalNumHits() + ", hits=" + this.getNumHits() + ", aggregations=" + String.valueOf(this.aggregations) + ", scrollId=" + this.scrollId + ", maxScore=" + this.getMaxScore() + "]";
    }
}

