/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.util.factory.Hints;
import org.opengis.feature.Feature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class ElasticBucketVisitor
implements FeatureAttributeVisitor {
    public static final Hints.ClassKey ES_AGGREGATE_BUCKET = new Hints.ClassKey(Map.class);
    private List<Map<String, Object>> buckets = new ArrayList<Map<String, Object>>();
    private String aggregationDefinition;
    private String queryDefinition;
    private Expression expr;

    public ElasticBucketVisitor(String aggregationDefinition, String queryDefinition) {
        this.aggregationDefinition = aggregationDefinition;
        this.queryDefinition = queryDefinition;
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property("_aggregation");
    }

    public void visit(Feature feature) {
        throw new RuntimeException("The ElasticBucketVisitor is only for Elasticsearch data sources and is not designed to work in memory.");
    }

    public List<Map<String, Object>> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(List<Map<String, Object>> buckets) {
        this.buckets = buckets;
    }

    public String getAggregationDefinition() {
        return this.aggregationDefinition;
    }

    public void setAggregationDefinition(String aggregationDefinition) {
        this.aggregationDefinition = aggregationDefinition;
    }

    public String getQueryDefinition() {
        return this.queryDefinition;
    }

    public void setQueryDefinition(String queryDefinition) {
        this.queryDefinition = queryDefinition;
    }

    public List<Expression> getExpressions() {
        return Arrays.asList(this.expr);
    }
}

