/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.elasticsearch.ElasticDataStore;
import org.geotools.data.elasticsearch.ElasticFeatureReader;
import org.geotools.data.elasticsearch.ElasticHit;
import org.geotools.data.elasticsearch.ElasticResponse;
import org.geotools.data.store.ContentState;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class ElasticFeatureReaderScroll
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger(ElasticFeatureReaderScroll.class);
    private final ContentState contentState;
    private final int maxFeatures;
    private String nextScrollId;
    private ElasticFeatureReader delegate;
    private int numFeatures;
    private boolean lastScroll;
    private final Set<String> scrollIds;

    public ElasticFeatureReaderScroll(ContentState contentState, ElasticResponse searchResponse, int maxFeatures) {
        this.contentState = contentState;
        this.maxFeatures = maxFeatures;
        this.numFeatures = 0;
        this.scrollIds = new HashSet<String>();
        this.processResponse(searchResponse);
    }

    private void advanceScroll() throws IOException {
        ElasticDataStore dataStore = (ElasticDataStore)this.contentState.getEntry().getDataStore();
        this.processResponse(dataStore.getClient().scroll(this.nextScrollId, dataStore.getScrollTime()));
    }

    private void processResponse(ElasticResponse searchResponse) {
        List<ElasticHit> hits;
        int numHits = searchResponse.getNumHits();
        if (this.numFeatures + numHits <= this.maxFeatures) {
            hits = searchResponse.getResults().getHits();
        } else {
            int n = this.maxFeatures - this.numFeatures;
            hits = searchResponse.getResults().getHits().subList(0, n);
        }
        this.delegate = new ElasticFeatureReader(this.contentState, hits, searchResponse.getAggregations(), 0.0f);
        this.nextScrollId = searchResponse.getScrollId();
        this.lastScroll = numHits == 0 || this.numFeatures + hits.size() >= this.maxFeatures;
        LOGGER.fine("Scoll numHits=" + hits.size() + " (total=" + this.numFeatures + hits.size());
        this.scrollIds.add(this.nextScrollId);
    }

    public SimpleFeatureType getFeatureType() {
        return this.delegate.getFeatureType();
    }

    public SimpleFeature next() throws IOException {
        if (this.hasNext()) {
            ++this.numFeatures;
        } else {
            throw new NoSuchElementException();
        }
        SimpleFeature feature = this.delegate.next();
        return feature;
    }

    public boolean hasNext() throws IOException {
        if (!this.delegate.hasNext() && !this.lastScroll) {
            this.advanceScroll();
        }
        return (this.delegate.hasNext() || !this.lastScroll) && this.numFeatures < this.maxFeatures;
    }

    public void close() throws IOException {
        if (!this.scrollIds.isEmpty()) {
            ElasticDataStore dataStore = (ElasticDataStore)this.contentState.getEntry().getDataStore();
            dataStore.getClient().clearScroll(this.scrollIds);
        }
        this.delegate.close();
    }
}

