/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class ElasticAttribute
implements Serializable,
Comparable<ElasticAttribute> {
    private static final Pattern beginLetters = Pattern.compile("^[A-Za-z_].*");
    private static final long serialVersionUID = 8839579461838862328L;
    private final String name;
    private Class<?> type;
    private ElasticGeometryType geometryType;
    private Boolean use;
    private Boolean defaultGeometry;
    private Integer srid;
    private String dateFormat;
    private List<String> validDateFormats;
    private Boolean analyzed;
    private boolean stored;
    private boolean nested;
    private Integer order;
    private String customName;

    public ElasticAttribute(String name) {
        this.name = name;
        this.use = true;
        this.defaultGeometry = false;
        this.stored = false;
        this.nested = false;
    }

    public ElasticAttribute(ElasticAttribute other) {
        this.name = other.name;
        this.type = other.type;
        this.use = other.use;
        this.defaultGeometry = other.defaultGeometry;
        this.srid = other.srid;
        this.dateFormat = other.dateFormat;
        this.validDateFormats = other.validDateFormats;
        this.geometryType = other.geometryType;
        this.analyzed = other.analyzed;
        this.stored = other.stored;
        this.nested = other.nested;
        this.order = other.order;
        this.customName = other.customName;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public ElasticGeometryType getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(ElasticGeometryType geometryType) {
        this.geometryType = geometryType;
    }

    public Boolean isUse() {
        return this.use;
    }

    public void setUse(Boolean use) {
        this.use = use;
    }

    public Boolean isDefaultGeometry() {
        return this.defaultGeometry;
    }

    public void setDefaultGeometry(Boolean defaultGeometry) {
        this.defaultGeometry = defaultGeometry;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public List<String> getValidDateFormats() {
        return this.validDateFormats;
    }

    public void setValidDateFormats(List<String> validDateFormats) {
        this.validDateFormats = validDateFormats;
    }

    public Boolean getAnalyzed() {
        return this.analyzed;
    }

    public void setAnalyzed(Boolean analyzed) {
        this.analyzed = analyzed;
    }

    public boolean isStored() {
        return this.stored;
    }

    public void setStored(boolean stored) {
        this.stored = stored;
    }

    public boolean isNested() {
        return this.nested;
    }

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setCustomName(String name) {
        this.customName = ElasticAttribute.normalizeName(name);
    }

    public String getCustomName() {
        return this.customName;
    }

    public String getDisplayName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.use, this.defaultGeometry, this.srid, this.dateFormat, this.validDateFormats, this.geometryType, this.analyzed, this.stored, this.nested, this.order, this.customName});
    }

    public boolean equals(Object obj) {
        boolean equal;
        if (obj == null || this.getClass() != obj.getClass()) {
            equal = false;
        } else {
            ElasticAttribute other = (ElasticAttribute)obj;
            equal = Objects.equals(this.name, other.name);
            equal &= Objects.equals(this.type, other.type);
            equal &= Objects.equals(this.use, other.use);
            equal &= Objects.equals(this.defaultGeometry, other.defaultGeometry);
            equal &= Objects.equals(this.srid, other.srid);
            equal &= Objects.equals(this.dateFormat, other.dateFormat);
            equal &= Objects.equals(this.validDateFormats, other.validDateFormats);
            equal &= Objects.equals((Object)this.geometryType, (Object)other.geometryType);
            equal &= Objects.equals(this.analyzed, other.analyzed);
            equal &= Objects.equals(this.stored, other.stored);
            equal &= Objects.equals(this.nested, other.nested);
            equal &= Objects.equals(this.order, other.order);
            equal &= Objects.equals(this.customName, other.customName);
        }
        return equal;
    }

    @Override
    public int compareTo(ElasticAttribute o) {
        if (this.order == null) {
            return o.order == null ? this.name.compareTo(o.name) : 1;
        }
        if (o.order == null) {
            return -1;
        }
        int i = this.order.compareTo(o.order);
        return i == 0 ? this.name.compareTo(o.name) : i;
    }

    private static String normalizeName(String name) {
        String normalName = name;
        if (normalName == null) {
            return null;
        }
        if (normalName.toLowerCase().startsWith("xml")) {
            normalName = "_".concat(normalName);
        } else if (!beginLetters.matcher(normalName).matches()) {
            normalName = "_".concat(normalName);
        }
        return normalName.replaceAll(" ", "_");
    }

    public static enum ElasticGeometryType {
        GEO_POINT,
        GEO_SHAPE;

    }
}

