/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv.parse;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class CSVStrategy {
    static Logger LOGGER = Logging.getLogger(CSVStrategy.class);
    protected final CSVFileState csvFileState;
    protected volatile SimpleFeatureType featureType = null;
    private boolean writePrj = false;

    public CSVStrategy(CSVFileState csvFileState) {
        this.csvFileState = csvFileState;
    }

    public CSVIterator iterator() throws IOException {
        return new CSVIterator(this.csvFileState, this);
    }

    protected abstract SimpleFeatureType buildFeatureType();

    public abstract void createSchema(SimpleFeatureType var1) throws IOException;

    public abstract SimpleFeature decode(String var1, String[] var2);

    public abstract String[] encode(SimpleFeature var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeatureType getFeatureType() {
        if (this.featureType == null) {
            CSVStrategy cSVStrategy = this;
            synchronized (cSVStrategy) {
                if (this.featureType == null) {
                    this.featureType = this.buildFeatureType();
                }
            }
        }
        return this.featureType;
    }

    public static SimpleFeatureTypeBuilder createBuilder(CSVFileState csvFileState) {
        Map<String, Class<?>> typesFromData;
        String[] headers;
        try (CSVReader csvReader = csvFileState.openCSVReader();){
            headers = csvFileState.getCSVHeaders();
            typesFromData = CSVStrategy.findMostSpecificTypesFromData(csvReader, headers);
        }
        catch (CsvValidationException | IOException e) {
            throw new RuntimeException("Failure reading csv file", e);
        }
        return CSVStrategy.createBuilder(csvFileState, headers, typesFromData);
    }

    public static SimpleFeatureTypeBuilder createBuilder(CSVFileState csvFileState, String[] headers, Map<String, Class<?>> typesFromData) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(csvFileState.getTypeName());
        builder.setCRS(csvFileState.getCrs());
        if (csvFileState.getNamespace() != null) {
            builder.setNamespaceURI(csvFileState.getNamespace());
        }
        for (String col : headers) {
            Class<?> type = typesFromData.get(col);
            builder.add(col, type);
        }
        return builder;
    }

    protected static Map<String, Class<?>> findMostSpecificTypesFromData(CSVReader csvReader, String[] headers) throws IOException {
        HashMap result = new HashMap();
        for (String header : headers) {
            result.put(header, Integer.class);
        }
        try {
            String[] record;
            while ((record = csvReader.readNext()) != null) {
                List<String> values = Arrays.asList(record);
                if (record.length >= headers.length) {
                    values = values.subList(0, headers.length);
                }
                int i = 0;
                for (String value : values) {
                    value = value.trim();
                    String header = headers[i];
                    Class type = (Class<String>)result.get(header);
                    if (type == Integer.class) {
                        try {
                            Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            try {
                                Double.parseDouble(value);
                                type = Double.class;
                            }
                            catch (NumberFormatException ex) {
                                type = String.class;
                            }
                        }
                    } else if (type == Double.class) {
                        try {
                            Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            type = String.class;
                        }
                    }
                    result.put(header, type);
                    ++i;
                }
            }
        }
        catch (CsvValidationException e) {
            throw new IOException(e);
        }
        return result;
    }

    public char getSeparator() {
        return this.csvFileState.getSeparator();
    }

    public void setSeparator(char separator) {
        this.csvFileState.setSeparator(separator);
    }

    public char getQuotechar() {
        return this.csvFileState.getQuotechar();
    }

    public void setQuotechar(char quotechar) {
        this.csvFileState.setQuotechar(quotechar);
    }

    public char getEscapechar() {
        return this.csvFileState.getEscapechar();
    }

    public void setEscapechar(char escapechar) {
        this.csvFileState.setEscapechar(escapechar);
    }

    public String getLineSeparator() {
        return this.csvFileState.getLineSeparator();
    }

    public void setLineSeparator(String lineSeparator) {
        this.csvFileState.setLineSeparator(lineSeparator);
    }

    public boolean isQuoteAllFields() {
        return this.csvFileState.isQuoteAllFields();
    }

    public void setQuoteAllFields(boolean quoteAllFields) {
        this.csvFileState.setQuoteAllFields(quoteAllFields);
    }

    public void setWritePrj(boolean booleanValue) {
        this.writePrj = booleanValue;
    }

    public boolean isWritePrj() {
        return this.writePrj;
    }
}

