/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv.parse;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVStrategy;
import org.opengis.feature.simple.SimpleFeature;

public class CSVIterator
implements Iterator<SimpleFeature>,
Closeable {
    private int idx;
    private SimpleFeature next;
    private final CSVReader csvReader;
    private final CSVStrategy csvStrategy;

    public CSVIterator(CSVFileState csvFileState, CSVStrategy csvStrategy) throws IOException {
        this.csvStrategy = csvStrategy;
        try {
            this.csvReader = csvFileState.openCSVReader();
        }
        catch (CsvValidationException e) {
            throw new IOException(e);
        }
        this.idx = 1;
        this.next = null;
    }

    private SimpleFeature buildFeature(String[] csvRecord) {
        String id = "fid" + this.idx;
        SimpleFeature feature = this.csvStrategy.decode(id, csvRecord);
        ++this.idx;
        return feature;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            this.next = this.readFeature();
        }
        catch (IOException e) {
            this.next = null;
        }
        return this.next != null;
    }

    private SimpleFeature readFeature() throws IOException {
        try {
            String[] record = this.csvReader.readNext();
            if (record != null) {
                return this.buildFeature(record);
            }
        }
        catch (CsvValidationException e) {
            throw new IOException(e);
        }
        return null;
    }

    @Override
    public SimpleFeature next() {
        SimpleFeature feature;
        if (this.next != null) {
            SimpleFeature result = this.next;
            this.next = null;
            return result;
        }
        try {
            feature = this.readFeature();
        }
        catch (IOException e) {
            feature = null;
        }
        if (feature == null) {
            throw new NoSuchElementException();
        }
        return feature;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove features from csv iteratore");
    }

    @Override
    public void close() {
        try {
            this.csvReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

