/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.FilterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;

abstract class Value {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    public static final Value NONE = new None();
    public static final Map<String, String> COLORS_TO_HEX = new HashMap<String, String>();

    Value() {
    }

    public org.geotools.api.filter.expression.Expression toExpression() {
        throw new UnsupportedOperationException("Cannot turn this value into a OGC expression: " + this);
    }

    public String toLiteral() {
        throw new UnsupportedOperationException("Cannot turn this value into a literal: " + this);
    }

    static {
        COLORS_TO_HEX.put("aliceblue", "#f0f8ff");
        COLORS_TO_HEX.put("antiquewhite", "#faebd7");
        COLORS_TO_HEX.put("aqua", "#00ffff");
        COLORS_TO_HEX.put("aquamarine", "#7fffd4");
        COLORS_TO_HEX.put("azure", "#f0ffff");
        COLORS_TO_HEX.put("beige", "#f5f5dc");
        COLORS_TO_HEX.put("bisque", "#ffe4c4");
        COLORS_TO_HEX.put("black", "#000000");
        COLORS_TO_HEX.put("blanchedalmond", "#ffebcd");
        COLORS_TO_HEX.put("blue", "#0000ff");
        COLORS_TO_HEX.put("blueviolet", "#8a2be2");
        COLORS_TO_HEX.put("brown", "#a52a2a");
        COLORS_TO_HEX.put("burlywood", "#deb887");
        COLORS_TO_HEX.put("cadetblue", "#5f9ea0");
        COLORS_TO_HEX.put("chartreuse", "#7fff00");
        COLORS_TO_HEX.put("chocolate", "#d2691e");
        COLORS_TO_HEX.put("coral", "#ff7f50");
        COLORS_TO_HEX.put("cornflowerblue", "#6495ed");
        COLORS_TO_HEX.put("cornsilk", "#fff8dc");
        COLORS_TO_HEX.put("crimson", "#dc143c");
        COLORS_TO_HEX.put("cyan", "#00ffff");
        COLORS_TO_HEX.put("darkblue", "#00008b");
        COLORS_TO_HEX.put("darkcyan", "#008b8b");
        COLORS_TO_HEX.put("darkgoldenrod", "#b8860b");
        COLORS_TO_HEX.put("darkgray", "#a9a9a9");
        COLORS_TO_HEX.put("darkgreen", "#006400");
        COLORS_TO_HEX.put("darkgrey", "#a9a9a9");
        COLORS_TO_HEX.put("darkkhaki", "#bdb76b");
        COLORS_TO_HEX.put("darkmagenta", "#8b008b");
        COLORS_TO_HEX.put("darkolivegreen", "#556b2f");
        COLORS_TO_HEX.put("darkorange", "#ff8c00");
        COLORS_TO_HEX.put("darkorchid", "#9932cc");
        COLORS_TO_HEX.put("darkred", "#8b0000");
        COLORS_TO_HEX.put("darksalmon", "#e9967a");
        COLORS_TO_HEX.put("darkseagreen", "#8fbc8f");
        COLORS_TO_HEX.put("darkslateblue", "#483d8b");
        COLORS_TO_HEX.put("darkslategray", "#2f4f4f");
        COLORS_TO_HEX.put("darkslategrey", "#2f4f4f");
        COLORS_TO_HEX.put("darkturquoise", "#00ced1");
        COLORS_TO_HEX.put("darkviolet", "#9400d3");
        COLORS_TO_HEX.put("deeppink", "#ff1493");
        COLORS_TO_HEX.put("deepskyblue", "#00bfff");
        COLORS_TO_HEX.put("dimgray", "#696969");
        COLORS_TO_HEX.put("dimgrey", "#696969");
        COLORS_TO_HEX.put("dodgerblue", "#1e90ff");
        COLORS_TO_HEX.put("firebrick", "#b22222");
        COLORS_TO_HEX.put("floralwhite", "#fffaf0");
        COLORS_TO_HEX.put("forestgreen", "#228b22");
        COLORS_TO_HEX.put("fuchsia", "#ff00ff");
        COLORS_TO_HEX.put("gainsboro", "#dcdcdc");
        COLORS_TO_HEX.put("ghostwhite", "#f8f8ff");
        COLORS_TO_HEX.put("gold", "#ffd700");
        COLORS_TO_HEX.put("goldenrod", "#daa520");
        COLORS_TO_HEX.put("gray", "#808080");
        COLORS_TO_HEX.put("grey", "#808080");
        COLORS_TO_HEX.put("green", "#008000");
        COLORS_TO_HEX.put("greenyellow", "#adff2f");
        COLORS_TO_HEX.put("honeydew", "#f0fff0");
        COLORS_TO_HEX.put("hotpink", "#ff69b4");
        COLORS_TO_HEX.put("indianred", "#cd5c5c");
        COLORS_TO_HEX.put("indigo", "#4b0082");
        COLORS_TO_HEX.put("ivory", "#fffff0");
        COLORS_TO_HEX.put("khaki", "#f0e68c");
        COLORS_TO_HEX.put("lavender", "#e6e6fa");
        COLORS_TO_HEX.put("lavenderblush", "#fff0f5");
        COLORS_TO_HEX.put("lawngreen", "#7cfc00");
        COLORS_TO_HEX.put("lemonchiffon", "#fffacd");
        COLORS_TO_HEX.put("lightblue", "#add8e6");
        COLORS_TO_HEX.put("lightcoral", "#f08080");
        COLORS_TO_HEX.put("lightcyan", "#e0ffff");
        COLORS_TO_HEX.put("lightgoldenrodyellow", "#fafad2");
        COLORS_TO_HEX.put("lightgray", "#d3d3d3");
        COLORS_TO_HEX.put("lightgreen", "#90ee90");
        COLORS_TO_HEX.put("lightgrey", "#d3d3d3");
        COLORS_TO_HEX.put("lightpink", "#ffb6c1");
        COLORS_TO_HEX.put("lightsalmon", "#ffa07a");
        COLORS_TO_HEX.put("lightseagreen", "#20b2aa");
        COLORS_TO_HEX.put("lightskyblue", "#87cefa");
        COLORS_TO_HEX.put("lightslategray", "#778899");
        COLORS_TO_HEX.put("lightslategrey", "#778899");
        COLORS_TO_HEX.put("lightsteelblue", "#b0c4de");
        COLORS_TO_HEX.put("lightyellow", "#ffffe0");
        COLORS_TO_HEX.put("lime", "#00ff00");
        COLORS_TO_HEX.put("limegreen", "#32cd32");
        COLORS_TO_HEX.put("linen", "#faf0e6");
        COLORS_TO_HEX.put("magenta", "#ff00ff");
        COLORS_TO_HEX.put("maroon", "#800000");
        COLORS_TO_HEX.put("mediumaquamarine", "#66cdaa");
        COLORS_TO_HEX.put("mediumblue", "#0000cd");
        COLORS_TO_HEX.put("mediumorchid", "#ba55d3");
        COLORS_TO_HEX.put("mediumpurple", "#9370db");
        COLORS_TO_HEX.put("mediumseagreen", "#3cb371");
        COLORS_TO_HEX.put("mediumslateblue", "#7b68ee");
        COLORS_TO_HEX.put("mediumspringgreen", "#00fa9a");
        COLORS_TO_HEX.put("mediumturquoise", "#48d1cc");
        COLORS_TO_HEX.put("mediumvioletred", "#c71585");
        COLORS_TO_HEX.put("midnightblue", "#191970");
        COLORS_TO_HEX.put("mintcream", "#f5fffa");
        COLORS_TO_HEX.put("mistyrose", "#ffe4e1");
        COLORS_TO_HEX.put("moccasin", "#ffe4b5");
        COLORS_TO_HEX.put("navajowhite", "#ffdead");
        COLORS_TO_HEX.put("navy", "#000080");
        COLORS_TO_HEX.put("oldlace", "#fdf5e6");
        COLORS_TO_HEX.put("olive", "#808000");
        COLORS_TO_HEX.put("olivedrab", "#6b8e23");
        COLORS_TO_HEX.put("orange", "#ffa500");
        COLORS_TO_HEX.put("orangered", "#ff4500");
        COLORS_TO_HEX.put("orchid", "#da70d6");
        COLORS_TO_HEX.put("palegoldenrod", "#eee8aa");
        COLORS_TO_HEX.put("palegreen", "#98fb98");
        COLORS_TO_HEX.put("paleturquoise", "#afeeee");
        COLORS_TO_HEX.put("palevioletred", "#db7093");
        COLORS_TO_HEX.put("papayawhip", "#ffefd5");
        COLORS_TO_HEX.put("peachpuff", "#ffdab9");
        COLORS_TO_HEX.put("peru", "#cd853f");
        COLORS_TO_HEX.put("pink", "#ffc0cb");
        COLORS_TO_HEX.put("plum", "#dda0dd");
        COLORS_TO_HEX.put("powderblue", "#b0e0e6");
        COLORS_TO_HEX.put("purple", "#800080");
        COLORS_TO_HEX.put("red", "#ff0000");
        COLORS_TO_HEX.put("rosybrown", "#bc8f8f");
        COLORS_TO_HEX.put("royalblue", "#4169e1");
        COLORS_TO_HEX.put("saddlebrown", "#8b4513");
        COLORS_TO_HEX.put("salmon", "#fa8072");
        COLORS_TO_HEX.put("sandybrown", "#f4a460");
        COLORS_TO_HEX.put("seagreen", "#2e8b57");
        COLORS_TO_HEX.put("seashell", "#fff5ee");
        COLORS_TO_HEX.put("sienna", "#a0522d");
        COLORS_TO_HEX.put("silver", "#c0c0c0");
        COLORS_TO_HEX.put("skyblue", "#87ceeb");
        COLORS_TO_HEX.put("slateblue", "#6a5acd");
        COLORS_TO_HEX.put("slategray", "#708090");
        COLORS_TO_HEX.put("slategrey", "#708090");
        COLORS_TO_HEX.put("snow", "#fffafa");
        COLORS_TO_HEX.put("springgreen", "#00ff7f");
        COLORS_TO_HEX.put("steelblue", "#4682b4");
        COLORS_TO_HEX.put("tan", "#d2b48c");
        COLORS_TO_HEX.put("teal", "#008080");
        COLORS_TO_HEX.put("thistle", "#d8bfd8");
        COLORS_TO_HEX.put("tomato", "#ff6347");
        COLORS_TO_HEX.put("turquoise", "#40e0d0");
        COLORS_TO_HEX.put("violet", "#ee82ee");
        COLORS_TO_HEX.put("wheat", "#f5deb3");
        COLORS_TO_HEX.put("white", "#ffffff");
        COLORS_TO_HEX.put("whitesmoke", "#f5f5f5");
        COLORS_TO_HEX.put("yellow", "#ffff00");
        COLORS_TO_HEX.put("yellowgreen", "#9acd32");
    }

    public static class None
    extends Value {
        private None() {
        }

        @Override
        public org.geotools.api.filter.expression.Expression toExpression() {
            return null;
        }

        @Override
        public String toLiteral() {
            return null;
        }
    }

    public static class MultiValue
    extends Value {
        List<Value> values;

        public MultiValue(List<Value> values) {
            this.values = values;
        }

        public MultiValue(Value ... values) {
            this.values = Arrays.asList(values);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultiValue other = (MultiValue)obj;
            return !(this.values == null ? other.values != null : !this.values.equals(other.values));
        }

        @Override
        public String toLiteral() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.values.size(); ++i) {
                sb.append(this.values.get(i).toLiteral());
                if (i >= this.values.size() - 1) continue;
                sb.append(" ");
            }
            return sb.toString();
        }
    }

    static class Expression
    extends Value {
        public org.geotools.api.filter.expression.Expression expression;

        public Expression(org.geotools.api.filter.expression.Expression expression) {
            this.expression = expression;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Expression other = (Expression)obj;
            return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
        }

        public String toString() {
            return "Expression [expression=" + this.expression + "]";
        }

        @Override
        public org.geotools.api.filter.expression.Expression toExpression() {
            return this.expression;
        }

        @Override
        public String toLiteral() {
            throw new UnsupportedOperationException("Cannot turn this value into a literal: " + this);
        }
    }

    static class TransformFunction
    extends Value {
        static final String URL = "url";
        static final String SYMBOL = "symbol";
        public String name;
        public Map<String, Value> parameters;

        public TransformFunction(String name, Map<String, Value> parameters) {
            this.parameters = parameters;
            this.name = name;
            if ((URL.equals(name) || SYMBOL.equals(name)) && parameters.size() != 1) {
                throw new IllegalArgumentException("Function " + name + " takes a single argument, not " + parameters.size());
            }
        }

        public String toString() {
            return "TransformFunction [name=" + this.name + ", parameters=" + this.parameters + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransformFunction other = (TransformFunction)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
        }

        @Override
        public org.geotools.api.filter.expression.Expression toExpression() {
            Map<String, Parameter<?>> paramInfo = TransformFunction.loadProcessInfo(TransformFunction.processName(this.name));
            if (paramInfo == null) {
                throw new RuntimeException("Could not locate rendering transformation named " + this.name);
            }
            ArrayList<org.geotools.api.filter.expression.Expression> arguments = new ArrayList<org.geotools.api.filter.expression.Expression>();
            String inputLayerParameter = this.getInputLayerParameter(paramInfo);
            if (inputLayerParameter != null && !this.parameters.containsKey(inputLayerParameter)) {
                arguments.add(this.toParamFunction(inputLayerParameter, null));
            }
            for (Map.Entry<String, Value> p : this.parameters.entrySet()) {
                String key = p.getKey();
                Value v = p.getValue();
                org.geotools.api.filter.expression.Expression ex = this.toParamFunction(key, v);
                arguments.add(ex);
            }
            org.geotools.api.filter.expression.Expression[] argsArray = this.toExpressionArray(arguments);
            return FF.function(this.name, argsArray);
        }

        private String getInputLayerParameter(Map<String, Parameter<?>> paramInfo) {
            for (Map.Entry<String, Parameter<?>> entry : paramInfo.entrySet()) {
                Class type;
                if (entry.getValue() == null || !GridCoverage2D.class.isAssignableFrom(type = entry.getValue().getType()) && !FeatureCollection.class.isAssignableFrom(type) && !GridCoverage2DReader.class.isAssignableFrom(type)) continue;
                return entry.getKey();
            }
            return null;
        }

        private org.geotools.api.filter.expression.Expression toParamFunction(String key, Value v) {
            ArrayList<org.geotools.api.filter.expression.Expression> paramArgs = new ArrayList<org.geotools.api.filter.expression.Expression>();
            paramArgs.add((org.geotools.api.filter.expression.Expression)FF.literal((Object)key));
            if (v instanceof MultiValue) {
                MultiValue mv = (MultiValue)v;
                for (Value cv : mv.values) {
                    org.geotools.api.filter.expression.Expression ex = cv.toExpression();
                    paramArgs.add(ex);
                }
            } else if (v != null) {
                org.geotools.api.filter.expression.Expression ex = v.toExpression();
                paramArgs.add(ex);
            }
            org.geotools.api.filter.expression.Expression[] paramArgsArray = this.toExpressionArray(paramArgs);
            org.geotools.api.filter.expression.Function function = FF.function("parameter", paramArgsArray);
            return function;
        }

        private org.geotools.api.filter.expression.Expression[] toExpressionArray(List<org.geotools.api.filter.expression.Expression> arguments) {
            org.geotools.api.filter.expression.Expression[] argsArray = arguments.toArray(new org.geotools.api.filter.expression.Expression[arguments.size()]);
            return argsArray;
        }

        public static Name processName(String name) {
            String[] split = name.split(":");
            if (split.length == 1) {
                return new NameImpl(split[0]);
            }
            return new NameImpl(split[0], split[1]);
        }

        public static Map<String, Parameter<?>> loadProcessInfo(Name name) {
            Class<?> processorsClass = null;
            try {
                processorsClass = Class.forName("org.geotools.process.Processors", false, Value.class.getClassLoader());
                Method getParameterInfo = processorsClass.getMethod("getParameterInfo", Name.class);
                return (Map)getParameterInfo.invoke(null, name);
            }
            catch (Exception e) {
                throw new RuntimeException("Error looking up process info", e);
            }
        }
    }

    static class Function
    extends Value {
        static final String URL = "url";
        static final String SYMBOL = "symbol";
        public String name;
        public List<Value> parameters;

        public static boolean isGraphicsFunction(Value v) {
            if (!(v instanceof Function)) {
                return false;
            }
            Function f = (Function)v;
            return URL.equals(f.name) || SYMBOL.equals(f.name);
        }

        public Function(String name, List<Value> parameters) {
            this.parameters = parameters;
            this.name = name;
            if ((URL.equals(name) || SYMBOL.equals(name)) && parameters.size() != 1) {
                throw new IllegalArgumentException("Function " + name + " takes a single argument, not " + parameters.size());
            }
        }

        public Function(String name, Value ... parameters) {
            this(name, Arrays.asList(parameters));
        }

        public String toString() {
            return "Function [name=" + this.name + ", parameters=" + this.parameters + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            return result;
        }

        @Override
        public org.geotools.api.filter.expression.Expression toExpression() {
            org.geotools.api.filter.expression.Expression[] params = (org.geotools.api.filter.expression.Expression[])this.parameters.stream().map(v -> v.toExpression()).toArray(org.geotools.api.filter.expression.Expression[]::new);
            return FF.function(this.name, params);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Function other = (Function)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
        }
    }

    static class Literal
    extends Value {
        static final Pattern PERCENTAGE = Pattern.compile("(\\d+\\.?\\d*)\\s*%");
        public String body;

        public Literal(String body) {
            this.body = body;
        }

        public String toString() {
            return "Literal[" + this.body + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Literal other = (Literal)obj;
            return !(this.body == null ? other.body != null : !this.body.equals(other.body));
        }

        @Override
        public org.geotools.api.filter.expression.Expression toExpression() {
            Matcher matcher = PERCENTAGE.matcher(this.body);
            if (matcher.matches()) {
                String group = matcher.group(1);
                Double percentage = Double.valueOf(group);
                return FF.literal(percentage / 100.0);
            }
            return FF.literal((Object)this.body);
        }

        @Override
        public String toLiteral() {
            return this.body;
        }
    }
}

