/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.util;

import java.util.ArrayList;
import org.geotools.styling.css.selector.Accept;
import org.geotools.styling.css.selector.And;
import org.geotools.styling.css.selector.Data;
import org.geotools.styling.css.selector.Id;
import org.geotools.styling.css.selector.Or;
import org.geotools.styling.css.selector.PseudoClass;
import org.geotools.styling.css.selector.Reject;
import org.geotools.styling.css.selector.ScaleRange;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.selector.SelectorVisitor;
import org.geotools.styling.css.selector.TypeName;

public class TypeNameSimplifier
implements SelectorVisitor {
    TypeName targetTypeName;

    public TypeNameSimplifier(TypeName targetTypeName) {
        this.targetTypeName = targetTypeName;
    }

    @Override
    public Object visit(Accept accept) {
        return accept;
    }

    @Override
    public Object visit(Reject reject) {
        return reject;
    }

    @Override
    public Object visit(Id id) {
        return id;
    }

    @Override
    public Object visit(Data data) {
        return data;
    }

    @Override
    public Object visit(And and) {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        for (Selector child : and.getChildren()) {
            Selector converted = (Selector)child.accept(this);
            if (converted instanceof Reject) {
                return Selector.REJECT;
            }
            if (converted instanceof Accept) continue;
            selectors.add(converted);
        }
        if (selectors.size() == 0) {
            return Selector.ACCEPT;
        }
        if (selectors.size() == 1) {
            return selectors.get(0);
        }
        return new And(selectors);
    }

    @Override
    public Object visit(Or or) {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        for (Selector child : or.getChildren()) {
            Selector converted = (Selector)child.accept(this);
            if (converted instanceof Accept) {
                return Selector.ACCEPT;
            }
            if (converted instanceof Reject) continue;
            selectors.add(converted);
        }
        if (selectors.size() == 0) {
            return Selector.REJECT;
        }
        if (selectors.size() == 1) {
            return selectors.get(0);
        }
        return new Or(selectors);
    }

    @Override
    public Object visit(TypeName typeName) {
        if (this.targetTypeName.equals(typeName)) {
            return Selector.ACCEPT;
        }
        return Selector.REJECT;
    }

    @Override
    public Object visit(ScaleRange scaleRange) {
        return scaleRange;
    }

    @Override
    public Object visit(PseudoClass pseudoClass) {
        return pseudoClass;
    }
}

