/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.util;

import java.util.BitSet;
import java.util.function.IntConsumer;

public abstract class Signature
implements Cloneable {
    public abstract void increment();

    public abstract boolean contains(Signature var1, int var2);

    public abstract boolean get(int var1);

    public abstract void set(int var1, boolean var2);

    public abstract int size();

    public abstract Object clone();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i)) {
                sb.append("1");
                continue;
            }
            sb.append("0");
        }
        return sb.toString();
    }

    public static Signature newSignature(int size) {
        return new BitsetSignature(size);
    }

    public abstract int cardinality();

    public abstract void foreach(IntConsumer var1);

    public static class BitsetSignature
    extends Signature {
        BitSet bs;
        private int size;

        public BitsetSignature(int size) {
            this.size = size;
            this.bs = new BitSet(size);
        }

        public BitsetSignature(BitsetSignature other) {
            this.bs = (BitSet)other.bs.clone();
            this.size = other.size;
        }

        @Override
        public void increment() {
            for (int i = 0; i < this.bs.size(); ++i) {
                if (!this.bs.get(i)) {
                    this.bs.set(i);
                    return;
                }
                this.bs.clear(i);
            }
        }

        @Override
        public boolean contains(Signature otherSignature, int k) {
            BitsetSignature other = (BitsetSignature)otherSignature;
            int max = Math.min(this.bs.size(), k + 1);
            int found = 0;
            for (int i = 0; i < max; ++i) {
                boolean ob = other.bs.get(i);
                boolean b = this.bs.get(i);
                found += ob ? 1 : 0;
                if (!ob || b) continue;
                return false;
            }
            return found > 0;
        }

        @Override
        public boolean get(int i) {
            return this.bs.get(i);
        }

        @Override
        public void set(int idx, boolean b) {
            this.bs.set(idx, b);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Object clone() {
            return new BitsetSignature(this);
        }

        @Override
        public int cardinality() {
            return this.bs.cardinality();
        }

        @Override
        public void foreach(IntConsumer consumer) {
            int next = this.bs.nextSetBit(0);
            while (next != -1) {
                consumer.accept(next);
                next = this.bs.nextSetBit(next + 1);
            }
        }
    }
}

