/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.styling.css.CssRule;
import org.geotools.styling.css.Property;
import org.geotools.styling.css.selector.PseudoClass;
import org.geotools.styling.css.selector.Selector;

class RulesCombiner {
    SimplifyingFilterVisitor simplifier;
    List<CssRule> lastRuleSet;
    Selector lastCombinedSelector;

    public RulesCombiner(SimplifyingFilterVisitor simplifier) {
        this.simplifier = simplifier;
    }

    CssRule combineRules(List<CssRule> rules) {
        Selector combinedSelector = this.combineSelectors(rules);
        LinkedHashMap properties = new LinkedHashMap();
        for (CssRule cssRule : rules) {
            for (Map.Entry<PseudoClass, List<Property>> entry : cssRule.getProperties().entrySet()) {
                PseudoClass ps = entry.getKey();
                LinkedHashMap<String, Property> psProperties = (LinkedHashMap<String, Property>)properties.get(ps);
                if (psProperties == null) {
                    psProperties = new LinkedHashMap<String, Property>();
                    properties.put(ps, psProperties);
                }
                for (Property p : entry.getValue()) {
                    psProperties.put(p.getName(), p);
                }
                if (ps == PseudoClass.ROOT) continue;
                for (PseudoClass containedClass : properties.keySet()) {
                    if (!ps.contains(containedClass)) continue;
                    Map containedProperties = (Map)properties.get(containedClass);
                    for (Property p : entry.getValue()) {
                        containedProperties.put(p.getName(), p);
                    }
                }
            }
        }
        LinkedHashMap<PseudoClass, List<Property>> newProperties = new LinkedHashMap<PseudoClass, List<Property>>();
        for (Map.Entry entry : properties.entrySet()) {
            newProperties.put((PseudoClass)entry.getKey(), new ArrayList(((Map)entry.getValue()).values()));
        }
        String string = this.getCombinedComment(rules);
        CssRule combined = new CssRule(combinedSelector, newProperties, string);
        combined.setAncestry(rules);
        return combined;
    }

    private String getCombinedComment(List<CssRule> rules) {
        StringBuilder sb = new StringBuilder();
        for (CssRule rule : rules) {
            if (rule.getComment() == null) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(rule.getComment());
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    Selector combineSelectors(List<CssRule> rules) {
        Selector s;
        if (rules == this.lastRuleSet) {
            return this.lastCombinedSelector;
        }
        if (rules.size() == 1) {
            s = rules.get(0).getSelector();
        } else {
            s = rules.get(0).getSelector();
            for (int i = 1; i < rules.size() && s != Selector.REJECT; ++i) {
                CssRule rule = rules.get(i);
                s = Selector.and(s, rule.getSelector(), this.simplifier);
            }
        }
        this.lastRuleSet = rules;
        this.lastCombinedSelector = s;
        return s;
    }
}

