/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.util.List;
import org.geotools.styling.css.CssRule;
import org.geotools.styling.css.Directive;

public class Stylesheet {
    private List<CssRule> rules;
    private List<Directive> directives;

    public Stylesheet(List<CssRule> rules, List<Directive> directives) {
        this.rules = rules;
        this.directives = directives;
    }

    List<CssRule> getRules() {
        return this.rules;
    }

    void setRules(List<CssRule> rules) {
        this.rules = rules;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    public String getDirectiveValue(String name) {
        for (Directive d : this.directives) {
            if (!name.equals(d.getName())) continue;
            return d.getValue();
        }
        return null;
    }

    public String toString() {
        return "Stylesheet [rules=" + String.valueOf(this.rules) + ", directives=" + String.valueOf(this.directives) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.directives == null ? 0 : this.directives.hashCode());
        result = 31 * result + (this.rules == null ? 0 : this.rules.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Stylesheet other = (Stylesheet)obj;
        if (this.directives == null ? other.directives != null : !this.directives.equals(other.directives)) {
            return false;
        }
        return !(this.rules == null ? other.rules != null : !this.rules.equals(other.rules));
    }
}

