/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.styling.css.Property;
import org.geotools.styling.css.RulesCombiner;
import org.geotools.styling.css.Value;
import org.geotools.styling.css.ZIndexComparator;
import org.geotools.styling.css.selector.PseudoClass;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.util.PseudoClassExtractor;
import org.geotools.styling.css.util.PseudoClassRemover;
import org.geotools.util.Converters;

public class CssRule {
    public static final Integer NO_Z_INDEX = null;
    Selector selector;
    Map<PseudoClass, List<Property>> properties;
    String comment;
    List<CssRule> ancestry;
    List<CssRule> nestedRules;

    public CssRule(Selector selector, List<Property> properties) {
        this.setSelector(selector);
        PseudoClassExtractor extractor = new PseudoClassExtractor();
        selector.accept(extractor);
        this.setProperties(new HashMap<PseudoClass, List<Property>>());
        Set<PseudoClass> pseudoClasses = extractor.getPseudoClasses();
        for (PseudoClass ps : pseudoClasses) {
            this.getProperties().put(ps, properties);
        }
    }

    public CssRule(Selector selector, List<Property> properties, String comment) {
        this(selector, properties);
        this.setComment(comment);
    }

    CssRule(Selector selector, Map<PseudoClass, List<Property>> properties, String comment) {
        this.setSelector(selector);
        this.setProperties(properties);
        this.setComment(comment);
    }

    public String toString() {
        String base = "Rule [\n    selector=" + String.valueOf(this.getSelector()) + ",\n    properties=" + String.valueOf(this.getProperties()) + "]";
        return base;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getComment() == null ? 0 : this.getComment().hashCode());
        result = 31 * result + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        result = 31 * result + (this.getSelector() == null ? 0 : this.getSelector().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssRule other = (CssRule)obj;
        if (this.getComment() == null ? other.getComment() != null : !this.getComment().equals(other.getComment())) {
            return false;
        }
        if (this.getProperties() == null ? other.getProperties() != null : !this.getProperties().equals(other.getProperties())) {
            return false;
        }
        return !(this.getSelector() == null ? other.getSelector() != null : !this.getSelector().equals(other.getSelector()));
    }

    public Map<String, List<Value>> getPropertyValues(PseudoClass pseudoClass, String ... symbolizerPrefixes) {
        List<Property> psProperties = this.getProperties().get(pseudoClass);
        if (psProperties == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<Value>> result = new LinkedHashMap<String, List<Value>>();
        if (symbolizerPrefixes != null && symbolizerPrefixes.length > 0) {
            for (Property property : psProperties) {
                for (String symbolizerPrefix : symbolizerPrefixes) {
                    if (symbolizerPrefix != null && !property.getName().startsWith(symbolizerPrefix) && !property.getName().startsWith("-gt-" + symbolizerPrefix)) continue;
                    result.put(property.getName(), property.getValues());
                }
            }
        } else {
            for (Property property : psProperties) {
                result.put(property.getName(), property.getValues());
            }
        }
        return result;
    }

    public boolean hasProperty(PseudoClass pseudoClass, String propertyName) {
        List<Property> psProperties = this.getProperties().get(pseudoClass);
        if (psProperties == null) {
            return false;
        }
        for (Property property : psProperties) {
            if (!propertyName.equals(property.getName()) || !property.hasValues()) continue;
            return true;
        }
        return false;
    }

    public Property getProperty(PseudoClass pseudoClass, String propertyName) {
        List<Property> psProperties = this.getProperties().get(pseudoClass);
        if (psProperties == null) {
            return null;
        }
        for (Property property : psProperties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public boolean hasAnyVendorProperty(PseudoClass pseudoClass, Collection<String> propertyNames) {
        List<Property> psProperties = this.getProperties().get(pseudoClass);
        if (psProperties == null) {
            return false;
        }
        for (Property property : psProperties) {
            String name = property.getName();
            if (name.startsWith("-gt-")) {
                name = name.substring(4);
            }
            if (!propertyNames.contains(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyProperty(PseudoClass pseudoClass, Collection<String> propertyNames) {
        List<Property> psProperties = this.getProperties().get(pseudoClass);
        if (psProperties == null) {
            return false;
        }
        for (Property property : psProperties) {
            if (!propertyNames.contains(property.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean covers(CssRule other) {
        Set<PseudoClass> otherPseudoClasses;
        if (!other.getSelector().equals(this.getSelector())) {
            return false;
        }
        Set<PseudoClass> pseudoClasses = this.getProperties().keySet();
        if (!pseudoClasses.containsAll(otherPseudoClasses = other.getProperties().keySet())) {
            return false;
        }
        for (PseudoClass pc : otherPseudoClasses) {
            List<Property> properties = this.getProperties().get(pc);
            List<Property> otherProperties = other.getProperties().get(pc);
            for (Property p : otherProperties) {
                if (properties.contains(p)) continue;
                return false;
            }
        }
        return true;
    }

    public CssRule getSubRuleByZIndex(Integer zIndex, ZIndexMode zIndexMode) {
        HashMap<PseudoClass, List<Property>> zProperties = new HashMap<PseudoClass, List<Property>>();
        ArrayList<Integer> zIndexes = new ArrayList<Integer>();
        for (Map.Entry<PseudoClass, List<Property>> entry : this.getProperties().entrySet()) {
            List<Property> props = entry.getValue();
            this.collectZIndexesInProperties(props, zIndexes);
            ListIterator it = zIndexes.listIterator();
            while (it.hasNext()) {
                int zIndexPosition = it.nextIndex();
                Integer nextZIndex = (Integer)it.next();
                if (nextZIndex == NO_Z_INDEX) {
                    if (zIndexMode == ZIndexMode.NoZIndexAll || !PseudoClass.ROOT.equals(entry.getKey())) {
                        zProperties.put(entry.getKey(), new ArrayList<Property>(props));
                        continue;
                    }
                    if (zIndex != 0) continue;
                    zProperties.put(entry.getKey(), new ArrayList<Property>(props));
                    continue;
                }
                if (nextZIndex == null || !nextZIndex.equals(zIndex)) continue;
                ArrayList<Property> zIndexProperties = new ArrayList<Property>();
                for (Property property : props) {
                    if (this.isZIndex(property)) continue;
                    List<Value> values = property.getValues();
                    if (zIndexPosition < values.size()) {
                        Property p = new Property(property.getName(), Arrays.asList(values.get(zIndexPosition)));
                        zIndexProperties.add(p);
                        continue;
                    }
                    if (values.size() != 1) continue;
                    zIndexProperties.add(property);
                }
                if (zIndexProperties.isEmpty()) continue;
                zProperties.put(entry.getKey(), zIndexProperties);
            }
        }
        List nestedByZIndex = Collections.emptyList();
        if (this.nestedRules != null) {
            nestedByZIndex = this.nestedRules.stream().map(r -> r.getSubRuleByZIndex(zIndex, zIndexMode)).filter(r -> r != null).collect(Collectors.toList());
        }
        if (!zProperties.isEmpty()) {
            if (zIndex != null && zIndexes.contains(zIndex)) {
                ArrayList<Property> rootProperties = (ArrayList<Property>)zProperties.get(PseudoClass.ROOT);
                if (rootProperties == null) {
                    rootProperties = new ArrayList<Property>();
                    zProperties.put(PseudoClass.ROOT, rootProperties);
                }
                rootProperties.add(new Property("z-index", Arrays.asList(new Value.Literal(String.valueOf(zIndex)))));
            }
            CssRule zRule = new CssRule(this.getSelector(), zProperties, this.getComment());
            zRule.nestedRules = nestedByZIndex;
            zRule.ancestry = Arrays.asList(this);
            return zRule;
        }
        return null;
    }

    public Set<Integer> getZIndexes() {
        TreeSet<Integer> indexes = new TreeSet<Integer>(new ZIndexComparator());
        ArrayList<Integer> singleListIndexes = new ArrayList<Integer>();
        for (List<Property> list : this.getProperties().values()) {
            this.collectZIndexesInProperties(list, singleListIndexes);
            indexes.addAll(singleListIndexes);
        }
        return indexes;
    }

    void collectZIndexesInProperties(List<Property> properties, List<Integer> zIndexes) {
        if (!zIndexes.isEmpty()) {
            zIndexes.clear();
        }
        for (Property property : properties) {
            if (!this.isZIndex(property)) continue;
            if (!zIndexes.isEmpty()) {
                zIndexes.clear();
            }
            List<Value> values = property.getValues();
            for (Value value : values) {
                if (value instanceof Value.Literal) {
                    String body = ((Value.Literal)value).body;
                    Integer zIndex = (Integer)Converters.convert((Object)body, Integer.class);
                    if (zIndex == null) {
                        throw new IllegalArgumentException("Invalid value for z-index, it should be an integer: " + body);
                    }
                    zIndexes.add(zIndex);
                    continue;
                }
                throw new IllegalArgumentException("z-index must be integer literals, they cannot be expressions, multi-values or any other type: " + String.valueOf(value));
            }
        }
        if (zIndexes.isEmpty()) {
            zIndexes.add(null);
        }
    }

    private boolean isZIndex(Property property) {
        String name = property.getName();
        return "z-index".equals(name) || "raster-z-index".equals(name);
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public Map<PseudoClass, List<Property>> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<PseudoClass, List<Property>> properties) {
        this.properties = properties;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<CssRule> getAncestry() {
        return this.ancestry;
    }

    public void setAncestry(List<CssRule> ancestry) {
        this.ancestry = ancestry;
    }

    public List<CssRule> getNestedRules() {
        return this.nestedRules;
    }

    boolean hasSymbolizerProperty() {
        List<Property> rootProperties = this.getProperties().get(PseudoClass.ROOT);
        if (rootProperties == null) {
            return false;
        }
        for (Property property : rootProperties) {
            String name;
            switch (name = property.getName()) {
                case "fill": 
                case "stroke": 
                case "mark": 
                case "label": 
                case "raster-channels": {
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasNonNullSymbolizerProperty() {
        List<Property> rootProperties = this.getProperties().get(PseudoClass.ROOT);
        if (rootProperties == null) {
            return false;
        }
        for (Property property : rootProperties) {
            String name;
            switch (name = property.getName()) {
                case "fill": 
                case "stroke": 
                case "mark": 
                case "label": 
                case "raster-channels": {
                    return property.hasValues();
                }
            }
        }
        return false;
    }

    Set<PseudoClass> getMixablePseudoClasses() {
        List<Property> rootProperties = this.getProperties().get(PseudoClass.ROOT);
        if (rootProperties == null) {
            return Collections.emptySet();
        }
        HashSet<PseudoClass> result = new HashSet<PseudoClass>();
        for (Property property : rootProperties) {
            String name;
            switch (name = property.getName()) {
                case "fill": 
                case "stroke": {
                    result.add(PseudoClass.newPseudoClass("symbol"));
                    this.addPseudoClassesForConditionallyMixableProperty(result, property);
                    break;
                }
                case "mark": {
                    result.add(PseudoClass.newPseudoClass("symbol"));
                    result.add(PseudoClass.newPseudoClass("mark"));
                    this.addIndexedPseudoClasses(result, "mark");
                    break;
                }
                case "label": {
                    result.add(PseudoClass.newPseudoClass("symbol"));
                    result.add(PseudoClass.newPseudoClass("shield"));
                    this.addIndexedPseudoClasses(result, "shield");
                }
            }
        }
        return result;
    }

    private void addPseudoClassesForConditionallyMixableProperty(Set<PseudoClass> result, Property property) {
        String propertyName = property.getName();
        List<Value> values = property.getValues();
        if (values.size() == 1 && values.get(0) instanceof Value.Function) {
            result.add(PseudoClass.newPseudoClass(propertyName));
            this.addIndexedPseudoClasses(result, propertyName);
        } else {
            for (int i = 0; i < values.size(); ++i) {
                if (!(values.get(i) instanceof Value.Function)) continue;
                result.add(PseudoClass.newPseudoClass("symbol", i));
                result.add(PseudoClass.newPseudoClass(propertyName, i + 1));
            }
        }
    }

    private void addIndexedPseudoClasses(Set<PseudoClass> result, String propertyName) {
        Map<String, List<Value>> properties = this.getPropertyValues(PseudoClass.ROOT, propertyName);
        int maxRepeatCount = this.getMaxRepeatCount(properties);
        if (maxRepeatCount >= 1) {
            for (int i = 1; i <= maxRepeatCount; ++i) {
                result.add(PseudoClass.newPseudoClass("symbol", i));
                result.add(PseudoClass.newPseudoClass(propertyName, i));
            }
        }
    }

    private int getMaxRepeatCount(Map<String, List<Value>> valueMap) {
        int max = 1;
        for (List<Value> values : valueMap.values()) {
            max = Math.max(max, values.size());
        }
        return max;
    }

    public List<CssRule> expandNested(RulesCombiner combiner) {
        if (this.nestedRules == null || this.nestedRules.isEmpty()) {
            return Collections.singletonList(this);
        }
        ArrayList<CssRule> result = new ArrayList<CssRule>();
        result.add(this);
        for (CssRule nestedRule : this.nestedRules) {
            CssRule combined = combiner.combineRules(Arrays.asList(this, nestedRule));
            combined.setComment(nestedRule.getComment());
            combined.setAncestry(null);
            combined.nestedRules = nestedRule.nestedRules;
            List<CssRule> nestedCombined = combined.expandNested(combiner);
            result.addAll(nestedCombined);
        }
        return result;
    }

    public CssRule flattenPseudoSelectors() {
        CssRule combined;
        if (this.nestedRules == null || this.nestedRules.isEmpty()) {
            return this;
        }
        ArrayList<CssRule> residual = new ArrayList<CssRule>();
        ArrayList<CssRule> pseudoRules = new ArrayList<CssRule>();
        for (CssRule nested : this.nestedRules) {
            CssRule cleaned;
            CssRule flattened = nested.flattenPseudoSelectors();
            Selector removed = (Selector)flattened.getSelector().accept(new PseudoClassRemover());
            if (Selector.ACCEPT.equals(removed)) {
                cleaned = new CssRule(removed, flattened.properties, flattened.comment);
                cleaned.nestedRules = flattened.nestedRules;
                pseudoRules.add(cleaned);
                continue;
            }
            cleaned = new CssRule(removed, flattened.properties, flattened.comment);
            cleaned.nestedRules = flattened.nestedRules;
            residual.add(cleaned);
        }
        if (!pseudoRules.isEmpty()) {
            pseudoRules.add(0, this);
            combined = new RulesCombiner(new SimplifyingFilterVisitor()).combineRules(pseudoRules);
            combined.nestedRules = residual;
            return combined;
        }
        combined = new CssRule(this.selector, this.properties, this.comment);
        combined.nestedRules = residual;
        return combined;
    }

    static enum ZIndexMode {
        NoZIndexAll,
        NoZIndexZero;

    }
}

