/*
 * Decompiled with CFR 0.152.
 */
package org.geootols.filter.text.cql_2;

import java.io.StringReader;
import java.util.List;
import org.geootols.filter.text.cql_2.CQL2FilterBuilder;
import org.geootols.filter.text.cql_2.TokenAdapter;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.During;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.text.commons.ICompiler;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql_2.parsers.CQL2Parser;
import org.geotools.filter.text.cql_2.parsers.Node;
import org.geotools.filter.text.cql_2.parsers.ParseException;
import org.geotools.filter.text.cql_2.parsers.TokenMgrError;

public class CQL2Compiler
extends CQL2Parser
implements ICompiler {
    private static final String ATTRIBUTE_PATH_SEPARATOR = "/";
    private final String source;
    private final CQL2FilterBuilder builder;

    public CQL2Compiler(String txtSource, FilterFactory filterFactory) {
        super(new StringReader(txtSource));
        assert (filterFactory != null) : "filterFactory cannot be null";
        this.source = txtSource;
        this.builder = new CQL2FilterBuilder(txtSource, filterFactory);
    }

    public void compileFilter() throws CQLException {
        try {
            super.FilterCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    public void compileExpression() throws CQLException {
        try {
            super.ExpressionCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    public void compileFilterList() throws CQLException {
        try {
            super.FilterListCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    public final String getSource() {
        return this.source;
    }

    public final Filter getFilter() throws CQLException {
        return this.builder.getFilter();
    }

    public final Expression getExpression() throws CQLException {
        return this.builder.getExpression();
    }

    public IToken getTokenInPosition(int index) {
        return TokenAdapter.newAdapterFor(super.getToken(index));
    }

    public List<Filter> getFilterList() throws CQLException {
        return this.builder.getFilterList();
    }

    @Override
    public final void jjtreeOpenNodeScope(Node n) {
    }

    @Override
    public final void jjtreeCloseNodeScope(Node n) throws ParseException {
        try {
            Object built = this.build(n);
            IToken tokenAdapter = TokenAdapter.newAdapterFor(this.token);
            Result r = new Result(built, tokenAdapter, n.getType());
            this.builder.pushResult(r);
        }
        catch (CQLException e) {
            ParseException pe = new ParseException(e.getMessage());
            pe.initCause(e);
            throw pe;
        }
        finally {
            n.dispose();
        }
    }

    private Object build(Node n) throws CQLException {
        switch (n.getType()) {
            case 48: {
                return this.builder.buildLiteralInteger(this.getTokenInPosition(0).toString());
            }
            case 49: {
                return this.builder.buildLiteralDouble(this.getTokenInPosition(0).toString());
            }
            case 47: {
                return this.builder.bulidNegativeNumber();
            }
            case 52: {
                return this.builder.buildLiteralString(this.getTokenInPosition(0).toString());
            }
            case 41: {
                return this.builder.buildIdentifier(42);
            }
            case 42: {
                return this.builder.buildIdentifierPart(this.getTokenInPosition(0));
            }
            case 43: {
                return this.builder.buildSimpleAttribute();
            }
            case 44: {
                return this.builder.buildCompoundAttribute(43, ATTRIBUTE_PATH_SEPARATOR);
            }
            case 53: {
                return this.builder.buildFunction(54);
            }
            case 54: {
                return n;
            }
            case 55: {
                return n;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return this.buildBinaryExpression(n.getType());
            }
            case 38: 
            case 39: 
            case 40: {
                return this.buildBinaryFunction(n.getType());
            }
            case 2: {
                return this.buildLogicFilter(2);
            }
            case 1: {
                return this.buildLogicFilter(1);
            }
            case 3: {
                return this.buildLogicFilter(3);
            }
            case 33: {
                return this.builder.buildBetween();
            }
            case 32: {
                return this.builder.buildNotBetween();
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return this.buildBinaryComparasionOperator(n.getType());
            }
            case 21: {
                BinaryComparisonOperator eq = this.buildBinaryComparasionOperator(16);
                Not notFilter = this.builder.buildNotFilter((Filter)eq);
                return notFilter;
            }
            case 31: {
                return this.builder.buildLikeFilter(true);
            }
            case 30: {
                return this.builder.buildNotLikeFilter(true);
            }
            case 22: {
                return this.builder.buildPropertyIsNull();
            }
            case 23: {
                return this.builder.buildPorpertyNotIsNull();
            }
            case 45: {
                return this.builder.buildDateExpression(this.getTokenInPosition(0));
            }
            case 46: {
                return this.builder.buildDateTimeExpression(this.getTokenInPosition(0));
            }
            case 28: {
                return this.builder.buildPeriodBetweenDates();
            }
            case 24: {
                return this.builder.buildTEquals();
            }
            case 26: {
                return this.buildBefore();
            }
            case 25: {
                return this.buildAfterPredicate();
            }
            case 27: {
                return this.buildDuring();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.buildBinarySpatialOperator(n.getType());
            }
            case 56: {
                return this.builder.buildCoordinate();
            }
            case 59: {
                return this.builder.buildPointText();
            }
            case 57: {
                return this.builder.buildLineString(56);
            }
            case 60: {
                return this.builder.buildPolygon(57);
            }
            case 61: {
                return this.builder.buildMultiPoint(59);
            }
            case 62: {
                return this.builder.buildMultiLineString(57);
            }
            case 63: {
                return this.builder.buildMultiPolygon(60);
            }
            case 15: {
                return this.builder.buildGeometryLiteral();
            }
            case 64: {
                return this.builder.buildGeometryCollection(15);
            }
            case 58: {
                return this.builder.buildGeometry();
            }
            case 65: {
                return this.builder.buildEnvelope(TokenAdapter.newAdapterFor(n.getToken()));
            }
            case 50: {
                return this.builder.buildTrueLiteral();
            }
            case 51: {
                return this.builder.buildFalseLiteral();
            }
            case 5: {
                return this.builder.buildInPredicate(6);
            }
            case 4: {
                Or orFilter = this.builder.buildInPredicate(6);
                Not notOrFilter = this.builder.buildNotFilter((Filter)orFilter);
                return notOrFilter;
            }
        }
        return null;
    }

    private BinaryExpression buildBinaryExpression(int nodeType) throws CQLException {
        BinaryExpression expr = null;
        switch (nodeType) {
            case 34: {
                expr = this.builder.buildAddExpression();
                break;
            }
            case 35: {
                expr = this.builder.buildSubtractExression();
                break;
            }
            case 36: {
                expr = this.builder.buildMultiplyExpression();
                break;
            }
            case 37: {
                expr = this.builder.buildDivideExpression();
                break;
            }
        }
        return expr;
    }

    private Function buildBinaryFunction(int nodeType) throws CQLException {
        if (nodeType == 39) {
            return this.builder.buildRemainderExpression();
        }
        if (nodeType == 38) {
            return this.builder.buildIntegerDivideExpression();
        }
        return this.builder.buildPowerExpression();
    }

    private Filter buildLogicFilter(int nodeType) throws CQLException {
        try {
            Filter logicFilter;
            switch (nodeType) {
                case 2: {
                    logicFilter = this.builder.buildAndFilter();
                    break;
                }
                case 1: {
                    logicFilter = this.builder.buildOrFilter();
                    break;
                }
                case 3: {
                    logicFilter = this.builder.buildNotFilter();
                    break;
                }
                default: {
                    throw new CQLException("Expression not supported. And, Or, Not is required", this.getTokenInPosition(0), this.source);
                }
            }
            return logicFilter;
        }
        catch (IllegalFilterException ife) {
            throw new CQLException("Exception building LogicFilter", this.getTokenInPosition(0), (Throwable)ife, this.source);
        }
    }

    private BinarySpatialOperator buildBinarySpatialOperator(int nodeType) throws CQLException {
        BinarySpatialOperator filter = null;
        switch (nodeType) {
            case 7: {
                filter = this.builder.buildSpatialEqualFilter();
                break;
            }
            case 8: {
                filter = this.builder.buildSpatialDisjointFilter();
                break;
            }
            case 9: {
                filter = this.builder.buildSpatialIntersectsFilter();
                break;
            }
            case 10: {
                filter = this.builder.buildSpatialTouchesFilter();
                break;
            }
            case 11: {
                filter = this.builder.buildSpatialCrossesFilter();
                break;
            }
            case 12: {
                filter = this.builder.buildSpatialWithinFilter();
                break;
            }
            case 13: {
                filter = this.builder.buildSpatialContainsFilter();
                break;
            }
            case 14: {
                filter = this.builder.buildSpatialOverlapsFilter();
                break;
            }
            default: {
                throw new CQLException("Binary spatial operator unexpected");
            }
        }
        return filter;
    }

    private Before buildBefore() throws CQLException {
        return this.builder.buildBeforeDate();
    }

    private During buildDuring() throws CQLException {
        return this.builder.buildDuringPeriod();
    }

    private After buildAfterPredicate() throws CQLException {
        return this.builder.buildAfterDate();
    }

    private BinaryComparisonOperator buildBinaryComparasionOperator(int filterType) throws CQLException {
        switch (filterType) {
            case 16: {
                return this.builder.buildEquals();
            }
            case 17: {
                return this.builder.buildGreater();
            }
            case 18: {
                return this.builder.buildLess();
            }
            case 19: {
                return this.builder.buildGreaterOrEqual();
            }
            case 20: {
                return this.builder.buildLessOrEqual();
            }
        }
        throw new CQLException("unexpeted filter type.");
    }
}

