/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql_2;

import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.text.cql2.CQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;

public class CQL2LiteralTest {
    @Test
    public void lineString() throws Exception {
        String wkt = "LINESTRING (1 2, 3 4)";
        this.assertParseGeometry(wkt, LineString.class);
    }

    @Test
    public void point() throws Exception {
        String wkt = "POINT(1 2)";
        this.assertParseGeometry(wkt, Point.class);
    }

    @Test
    public void polygon() throws Exception {
        String wkt = "POLYGON((1 2, 15 2, 15 20, 15 21, 1 2))";
        this.assertParseGeometry(wkt, Polygon.class);
    }

    @Test
    public void polygonWithHole() throws Exception {
        String wkt = "POLYGON ((40 60, 420 60, 420 320, 40 320, 40 60), (200 140, 160 220, 260 200, 200 140))";
        this.assertParseGeometry(wkt, Polygon.class);
    }

    @Test
    public void multiPoint() throws Exception {
        String wkt = "MULTIPOINT( (1 2), (15 2), (15 20), (15 21), (1 2))";
        String expectedWkt = "MULTIPOINT(1 2, 15 2, 15 20, 15 21, 1 2)";
        this.assertParseGeometry(wkt, expectedWkt, MultiPoint.class);
    }

    @Test
    public void multiLineString() throws Exception {
        String wkt = "MULTILINESTRING((10 10, 20 20),(15 15,30 15))";
        this.assertParseGeometry(wkt, MultiLineString.class);
    }

    @Test
    public void geometryCollection() throws Exception {
        String wkt = "GEOMETRYCOLLECTION (POINT (10 10),POINT (30 30),LINESTRING (15 15, 20 20))";
        this.assertParseGeometry(wkt, GeometryCollection.class);
    }

    @Test
    public void multiPolygon() throws Exception {
        String wkt = "MULTIPOLYGON( ((10 10, 10 20, 20 20, 20 15, 10 10)),((60 60, 70 70, 80 60, 60 60 )) )";
        this.assertParseGeometry(wkt, MultiPolygon.class);
    }

    private void assertParseGeometry(String wkt, Class<? extends Geometry> type) throws Exception {
        this.assertParseGeometry(wkt, wkt, type);
        this.assertParseGeometry(wkt, wkt, type);
    }

    private void assertParseGeometry(String wkt, String expectedWkt, Class expectedGeometryClass) throws Exception {
        Expression expression = CQL2.toExpression((String)wkt);
        MatcherAssert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(Literal.class));
        Literal literal = (Literal)expression;
        Object actualGeometry = literal.getValue();
        MatcherAssert.assertThat((Object)actualGeometry, (Matcher)CoreMatchers.instanceOf((Class)expectedGeometryClass));
        this.assertEqualsGeometries(expectedWkt, (Geometry)actualGeometry);
    }

    protected void assertEqualsGeometries(String strGeomExpected, Geometry actualGeometry) throws Exception {
        WKTReader reader = new WKTReader();
        Geometry expectedGeometry = reader.read(strGeomExpected);
        if (expectedGeometry instanceof GeometryCollection) {
            Assert.assertTrue((boolean)expectedGeometry.equalsExact(actualGeometry));
        } else {
            Assert.assertTrue((boolean)expectedGeometry.equalsTopo(actualGeometry));
        }
    }

    @Test
    public void testEnvelope() throws Exception {
        Expression expression = CQL2.toExpression((String)"BBOX(10, 20, 30, 40)");
        MatcherAssert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(Literal.class));
        Literal literal = (Literal)expression;
        Object actualGeometry = literal.getValue();
        MatcherAssert.assertThat((Object)actualGeometry, (Matcher)CoreMatchers.instanceOf(Polygon.class));
        Polygon polygon = (Polygon)actualGeometry;
        this.assertEqualsGeometries("POLYGON ((10 20, 10 40, 30 40, 30 20, 10 20))", (Geometry)polygon);
    }

    @Test(expected=CQLException.class)
    public void testParseInvalidSRID() throws Exception {
        CQL2.toExpression((String)"SRID=12345678987654321;POINT(1 2)");
    }

    @Test(expected=CQLException.class)
    public void geometryLiteralsError() throws CQLException {
        CQL2.toExpression((String)"POLYGON(1 2, 10 15), (10 15, 1 2)))");
    }

    @Test
    public void characterStringLiteral() throws Exception {
        String strWithSpace = "ALL PRACTICES";
        Filter filterWithSpace = CQL2.toFilter((String)"practice='ALL PRACTICES'");
        Assert.assertNotNull((Object)filterWithSpace);
        Assert.assertTrue((boolean)(filterWithSpace instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eqFilter = (PropertyIsEqualTo)filterWithSpace;
        Expression spacesLiteral = eqFilter.getExpression2();
        Assert.assertEquals((Object)"ALL PRACTICES", (Object)spacesLiteral.toString());
        Filter emptyFilter = CQL2.toFilter((String)"MAJOR_WATERSHED_SYSTEM = ''");
        Assert.assertNotNull((Object)emptyFilter);
        Assert.assertTrue((boolean)(emptyFilter instanceof PropertyIsEqualTo));
        eqFilter = (PropertyIsEqualTo)emptyFilter;
        Expression emptyLiteral = eqFilter.getExpression2();
        Assert.assertEquals((Object)"", (Object)emptyLiteral.toString());
        String expectedWithout = "ab";
        Filter filterWithoutQuote = CQL2.toFilter((String)"MAJOR_WATERSHED_SYSTEM = 'ab'");
        Assert.assertNotNull((Object)filterWithoutQuote);
        Assert.assertTrue((boolean)(filterWithoutQuote instanceof PropertyIsEqualTo));
        eqFilter = (PropertyIsEqualTo)filterWithoutQuote;
        Expression actualWhithoutQuote = eqFilter.getExpression2();
        Assert.assertEquals((Object)"ab", (Object)actualWhithoutQuote.toString());
        String expected = "cde'' fg";
        Filter filter = CQL2.toFilter((String)"MAJOR_WATERSHED_SYSTEM = 'cde'' fg'");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        eqFilter = (PropertyIsEqualTo)filter;
        Expression actual = eqFilter.getExpression2();
        Assert.assertEquals((Object)"cde'' fg".replaceAll("''", "'"), (Object)actual.toString());
        String otherChars = "\u00fc\u00e4";
        filter = CQL2.toFilter((String)"NAME = '\u00fc\u00e4'");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        eqFilter = (PropertyIsEqualTo)filter;
        actual = eqFilter.getExpression2();
        Assert.assertEquals((Object)"\u00fc\u00e4", (Object)actual.toString());
    }

    @Test
    public void russianCharacterStringLiteral() throws Exception {
        this.testCharacterString("\u0414\u041e\u0411\u0420\u0418\u0427");
        this.testCharacterString("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        this.testCharacterString("\u0444\u0430\u043c\u0438\u043b\u0438\u044f");
        this.testCharacterString("\u0441\u0440\u0435\u0434\u044b");
    }

    @Test
    public void japanCharacterStringLiteral() throws Exception {
        this.testCharacterString("\u540d");
        this.testCharacterString("\u59d3");
        this.testCharacterString("\u74b0\u5883");
    }

    private void testCharacterString(String str) throws Exception {
        Expression actual = CQL2.toExpression((String)("'" + str + "'"));
        Assert.assertEquals((Object)str, (Object)actual.toString());
    }

    @Test
    public void doubleLiteral() throws Exception {
        String expected = "4.20082008E4";
        Expression expr = CQL2.toExpression((String)"4.20082008E4");
        Literal doubleLiteral = (Literal)expr;
        Double actual = (Double)doubleLiteral.getValue();
        Assert.assertEquals((double)Double.parseDouble("4.20082008E4"), (double)actual, (double)8.0);
    }

    @Test
    public void longLiteral() throws Exception {
        String expected = "123456789012345";
        Expression expr = CQL2.toExpression((String)"123456789012345");
        Literal intLiteral = (Literal)expr;
        Long actual = (Long)intLiteral.getValue();
        Assert.assertEquals((long)Long.parseLong("123456789012345"), (long)actual);
        String maxLongValue = "9223372036854775807";
        expr = CQL2.toExpression((String)"9223372036854775807");
        intLiteral = (Literal)expr;
        actual = (Long)intLiteral.getValue();
        Assert.assertEquals((long)Long.parseLong("9223372036854775807"), (long)actual);
    }

    @Test
    public void dateLiteral() throws Exception {
        String expectedDate = "2009-08-01";
        Filter filter = CQL2.toFilter((String)("END_DATE = '" + expectedDate + "'"));
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)filter;
        Expression exp = eq.getExpression2();
        Assert.assertTrue((boolean)(exp instanceof Literal));
        Literal actualDate = (Literal)exp;
        Assert.assertEquals((Object)expectedDate, (Object)actualDate.toString());
    }

    @Test
    public void timeLiteral() throws Exception {
        String expectedTime = "12:08:01";
        Filter filter = CQL2.toFilter((String)"END_TIME = '12:08:01'");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)filter;
        Expression exp = eq.getExpression2();
        Assert.assertTrue((boolean)(exp instanceof Literal));
        Literal actualTime = (Literal)exp;
        Assert.assertEquals((Object)"12:08:01", (Object)actualTime.toString());
    }

    @Test
    public void timeStampLiteral() throws Exception {
        String expectedDateTime = "2009-08-01T12:08:01";
        Filter filter = CQL2.toFilter((String)"END_DATE = '2009-08-01T12:08:01'");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)filter;
        Expression exp = eq.getExpression2();
        Assert.assertTrue((boolean)(exp instanceof Literal));
        Literal actualDateTime = (Literal)exp;
        Assert.assertEquals((Object)"2009-08-01T12:08:01", (Object)actualDateTime.toString());
    }
}

