/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql_2;

import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.CQLExistenceTest;
import org.junit.Assert;
import org.junit.Test;

public class CQL2ExistenceTest
extends CQLExistenceTest {
    @Test
    public void attributeDoesNotExist() throws CQLException {
        this.ensureFail("ATTR1 DOES-NOT-EXIST");
    }

    @Test
    public void attributeExist() throws Exception {
        this.ensureFail("ATTR1 EXISTS");
    }

    protected Filter parseFilter(String cql) throws CQLException {
        return CQL2.toFilter((String)cql);
    }

    private void ensureFail(String filter) {
        try {
            Filter parsed = this.parseFilter(filter);
            Assert.fail((String)("Filter should not have been parsed: " + filter + " but got instead: " + parsed));
        }
        catch (CQLException cQLException) {
            // empty catch block
        }
    }
}

