/*
 * Decompiled with CFR 0.152.
 */
package org.geootols.filter.text.cql_2;

import java.util.LinkedList;
import java.util.List;
import org.geootols.filter.text.cql_2.GeometryBuilder;
import org.geotools.filter.text.commons.BuildResultStack;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.cql2.CQLException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

class PolygonBuilder
extends GeometryBuilder {
    public PolygonBuilder(String statement, BuildResultStack resultStack) {
        super(statement, resultStack);
    }

    @Override
    public Geometry build(int linestringNode) throws CQLException {
        Result result = this.getResultStack().peek();
        try {
            List<Geometry> geometryList = this.popGeometry(linestringNode);
            assert (!geometryList.isEmpty());
            LineString line = (LineString)geometryList.get(0);
            LinearRing shell = this.getGeometryFactory().createLinearRing(line.getCoordinates());
            LinearRing[] holes = new LinearRing[]{};
            if (geometryList.size() > 1) {
                LinkedList<LinearRing> holeList = new LinkedList<LinearRing>();
                for (int i = 1; i < geometryList.size(); ++i) {
                    LineString holeLines = (LineString)geometryList.get(i);
                    LinearRing ring = this.getGeometryFactory().createLinearRing(holeLines.getCoordinates());
                    holeList.add(ring);
                }
                int holesSize = holeList.size();
                holes = holeList.toArray(new LinearRing[holesSize]);
            }
            Polygon polygon = this.getGeometryFactory().createPolygon(shell, holes);
            return polygon;
        }
        catch (Exception e) {
            throw new CQLException(e.getMessage(), result.getToken(), this.getStatemet());
        }
    }
}

