/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql_2;

import java.awt.Color;
import java.util.List;
import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.During;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.IsNullImpl;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.FilterECQLSample;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class CQL2Test {
    @Test(expected=CQLException.class)
    public void include() throws CQLException {
        CQL2.toFilter((String)"INCLUDE");
    }

    @Test(expected=CQLException.class)
    public void exclude() throws CQLException {
        CQL2.toFilter((String)"EXCLUDE");
    }

    @Test
    public void betweenPredicate() throws CQLException {
        this.assertFilter("ATTR1 BETWEEN 10 AND 20", PropertyIsBetween.class);
    }

    @Test
    public void comparisonPredicate() throws Exception {
        this.assertFilter("POP_RANK > 6", PropertyIsGreaterThan.class);
        this.assertFilter("Area(the_geom) < 3000", PropertyIsLessThan.class);
    }

    @Test
    public void geoOperationPredicate() throws CQLException {
        this.assertFilter("S_INTERSECTS(the_geom, POINT (1 2))", Intersects.class);
        this.assertFilter("S_INTERSECTS(buffer(the_geom,10), POINT (1 2))", Intersects.class);
    }

    @Test
    public void beforePredicate() throws Exception {
        String cql = "T_BEFORE(ATTR1, TIMESTAMP('2006-12-31T01:30:00Z'))";
        this.assertFilter(cql, Before.class);
    }

    @Test
    public void afterPredicate() throws Exception {
        String cql = "T_AFTER(ATTR1, TIMESTAMP('2006-12-31T01:30:00Z'))";
        this.assertFilter(cql, After.class);
    }

    @Test
    public void duringPredicate() throws Exception {
        String cql = "T_DURING(ATTR1, INTERVAL(DATE('2006-10-31'), DATE('2006-12-31')))";
        this.assertFilter(cql, During.class);
    }

    @Test
    public void booleanPredicate() throws Exception {
        this.assertFilter("ATTR1 < 10 AND ATTR2 < 2", And.class);
        this.assertFilter("ATTR1 < 10 OR ATTR2 < 2", Or.class);
        this.assertFilter("NOT (ATTR < 10)", Not.class);
        this.assertFilter("(A = 1 OR B = 2) AND C = 3", And.class);
        this.assertFilter("(A = 1 OR B = 2) AND NOT (C = 3)", And.class);
    }

    private <F extends Expression> F assertExpression(String cql, Class<F> expected) throws CQLException {
        Expression expression = CQL2.toExpression((String)cql);
        Assert.assertTrue((String)expected.getSimpleName(), (boolean)expected.isInstance(expression));
        Assert.assertEquals((String)cql, (Object)cql, (Object)CQL2.toCQL2((Expression)expression));
        return (F)((Expression)expected.cast(expression));
    }

    private <F extends Filter> F assertFilter(String cql, Class<F> type) throws CQLException {
        Filter filter = CQL2.toFilter((String)cql);
        Assert.assertTrue((String)type.getSimpleName(), (boolean)type.isInstance(filter));
        Assert.assertEquals((String)cql, (Object)cql, (Object)CQL2.toCQL2((Filter)filter));
        return (F)((Filter)type.cast(filter));
    }

    private <F extends Filter> F assertFilter(String cql, String expected, Class<F> type) throws CQLException {
        Filter filter = CQL2.toFilter((String)cql);
        Assert.assertEquals((String)cql, (Object)expected, (Object)CQL2.toCQL2((Filter)filter));
        return (F)((Filter)type.cast(filter));
    }

    @Test
    public void inPredicate() throws CQLException {
        this.assertFilter("length IN (4100001,4100002,4100003)", Or.class);
        this.assertFilter("A IN (1,2,3)", Or.class);
        this.assertFilter("(A IN (1,2,3)) OR B = 1", Or.class);
        this.assertFilter("(A IN (1,2,3)) OR (B = 1 AND C = 3)", Or.class);
        this.assertFilter("(A IN (1,2,3)) OR (B IN (4,5))", Or.class);
        this.assertFilter("(A IN (1,2,3)) AND (B IN (5,6,7,8))", And.class);
        this.assertFilter("(A = 1 OR A = 2)", "A IN (1,2)", Or.class);
        this.assertFilter("A = 1 OR A = 2 OR A = 3", "(A IN (1,2)) OR A = 3", Or.class);
    }

    @Test
    public void likePredicate() throws Exception {
        this.assertFilter("aProperty LIKE '%bb%'", PropertyIsLike.class);
        PropertyIsLike like = this.assertFilter("strToUpperCase(anAttribute) LIKE '%BB%'", PropertyIsLike.class);
        Assert.assertTrue((boolean)(like.getExpression() instanceof Function));
    }

    @Test
    public void isNullPredicate() throws Exception {
        this.assertFilter("centroid(the_geom) IS NULL", IsNullImpl.class);
    }

    @Test
    public void expression() throws Exception {
        this.assertExpression("A + 1", Add.class);
    }

    @Test
    public void greaterFilterToCQL() throws Exception {
        String expectedCQL2 = "aProperty > -1";
        Filter filter = FilterECQLSample.getSample((String)expectedCQL2);
        String resultCQL2 = CQL2.toCQL2((Filter)filter);
        Assert.assertEquals((Object)expectedCQL2, (Object)resultCQL2);
    }

    @Test
    public void likeFilterToCQL() throws Exception {
        String expectedECQL = "'aabbcc' LIKE '%bb%'";
        Filter filter = FilterECQLSample.getSample((String)expectedECQL);
        String resultCQL2 = CQL2.toCQL2((Filter)filter);
        Assert.assertEquals((Object)expectedECQL, (Object)resultCQL2);
    }

    @Test
    public void functionExpressionToCQL() throws Exception {
        Expression[] absArgs = new Expression[1];
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        absArgs[0] = ff.literal(10);
        Function abs = ff.function("abs", absArgs);
        String resultECQL = CQL2.toCQL2((Expression)abs);
        Assert.assertEquals((Object)"abs(10)", (Object)resultECQL);
    }

    @Test
    public void toFilterUsesProvidedFilterFactory() throws Exception {
        final boolean[] called = new boolean[]{false};
        FilterFactoryImpl ff = new FilterFactoryImpl(){

            public PropertyName property(String propName) {
                called[0] = true;
                return super.property(propName);
            }
        };
        CQL2.toFilter((String)"attName > 20", (FilterFactory)ff);
        Assert.assertTrue((String)"Provided FilterFactory was not called", (boolean)called[0]);
    }

    @Test
    public void filterToECQL() throws Exception {
        String expectedECQL = "QUANTITY = 1";
        Filter list = CQL2.toFilter((String)expectedECQL);
        String cqlResult = CQL2.toCQL2((Filter)list);
        Assert.assertEquals((Object)expectedECQL, (Object)cqlResult);
    }

    @Test
    public void filterListToCQL() throws Exception {
        String expectedCQL = "QUANTITY = 1; YEAR < 1963";
        List list = CQL.toFilterList((String)expectedCQL);
        Assert.assertEquals((long)2L, (long)list.size());
        String cqlResult = CQL.toCQL((List)list);
        Assert.assertEquals((Object)expectedCQL, (Object)cqlResult);
    }

    @Test
    public void toExpressionUsesProvidedFilterFactory() throws Exception {
        final boolean[] called = new boolean[]{false};
        FilterFactoryImpl ff = new FilterFactoryImpl(){

            public PropertyName property(String propName) {
                called[0] = true;
                return super.property(propName);
            }
        };
        CQL2.toExpression((String)"attName", (FilterFactory)ff);
        Assert.assertTrue((String)"Provided FilterFactory was not called", (boolean)called[0]);
    }

    @Test
    public void testDivideEncode() throws Exception {
        FilterFactory filterFactory2 = CommonFactoryFinder.getFilterFactory();
        PropertyIsLessThan javaFilter = filterFactory2.less((Expression)filterFactory2.divide((Expression)filterFactory2.property("population"), (Expression)filterFactory2.literal(2)), (Expression)filterFactory2.divide((Expression)filterFactory2.property("pop2000"), (Expression)filterFactory2.literal(2)));
        Assert.assertEquals((Object)"population/2<pop2000/2", (Object)CQL2.toCQL2((Filter)javaFilter).replace(" ", ""));
    }

    @Test
    public void testQuotedComparison() throws Exception {
        Filter filter = CQL2.toFilter((String)"\"a\"=\"b\"");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyIsEqualTo expected = ff.equal((Expression)ff.property("a"), (Expression)ff.property("b"), false);
        Assert.assertEquals((Object)expected, (Object)filter);
    }

    @Test
    public void colorLiterals() throws CQLException {
        String expected = "Interpolate(population,0,'#FF0000',10,'#0000FF')";
        Expression expr = CQL2.toExpression((String)expected);
        String actual = CQL2.toCQL2((Expression)expr);
        Assert.assertEquals((String)"color literals", (Object)expected, (Object)actual);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Function function = ff.function("Interpolate", new Expression[]{ff.property("population"), ff.literal(0), ff.literal((Object)Color.RED), ff.literal(10), ff.literal((Object)Color.BLUE)});
        actual = CQL2.toCQL2((Expression)function);
        Assert.assertEquals((String)"color literals", (Object)expected, (Object)actual);
    }

    @Test
    public void idEquality() throws CQLException {
        Filter filter = CQL2.toFilter((String)"id = 'abcd'");
        MatcherAssert.assertThat((Object)filter, (Matcher)CoreMatchers.instanceOf(PropertyIsEqualTo.class));
        PropertyIsEqualTo pet = (PropertyIsEqualTo)filter;
        MatcherAssert.assertThat((Object)pet.getExpression1(), (Matcher)CoreMatchers.instanceOf(PropertyName.class));
        PropertyName pn = (PropertyName)pet.getExpression1();
        Assert.assertEquals((Object)"id", (Object)pn.getPropertyName());
    }

    @Test
    public void idInChoices() throws CQLException {
        Filter filter = CQL2.toFilter((String)"id in ('abcd', 'efg')");
        MatcherAssert.assertThat((Object)filter, (Matcher)CoreMatchers.instanceOf(Or.class));
        Or or = (Or)filter;
        Assert.assertEquals((long)2L, (long)or.getChildren().size());
        MatcherAssert.assertThat((Object)((Filter)or.getChildren().get(0)), (Matcher)CoreMatchers.instanceOf(PropertyIsEqualTo.class));
        MatcherAssert.assertThat((Object)((Filter)or.getChildren().get(1)), (Matcher)CoreMatchers.instanceOf(PropertyIsEqualTo.class));
        PropertyIsEqualTo pet = (PropertyIsEqualTo)or.getChildren().get(0);
        MatcherAssert.assertThat((Object)pet.getExpression1(), (Matcher)CoreMatchers.instanceOf(PropertyName.class));
        PropertyName pn = (PropertyName)pet.getExpression1();
        Assert.assertEquals((Object)"id", (Object)pn.getPropertyName());
    }

    @Test
    public void bbox() throws CQLException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("geometry", -180.0, -90.0, 180.0, 90.0, "CRS:84");
        Assert.assertEquals((Object)"S_INTERSECTS(geometry, BBOX(-180.0,-90.0,180.0,90.0))", (Object)CQL2.toCQL2((Filter)bbox));
    }
}

