/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql_2;

import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.filter.text.cql2.CQLException;
import org.junit.Test;

public class CQL2IDPredicateTest {
    @Test(expected=CQLException.class)
    public void filterIdWithListOfIdValues() throws Exception {
        String strId1 = "states.1";
        String strId2 = "states.2";
        String strId3 = "states.3";
        CQL2.toFilter((String)"IN ('states.1','states.2', 'states.3')");
    }

    @Test(expected=CQLException.class)
    public void notFilterId() throws Exception {
        String strId1 = "states.1";
        String strId2 = "states.2";
        String strId3 = "states.3";
        CQL2.toFilter((String)"NOT IN ('states.1','states.2', 'states.3')");
    }

    @Test(expected=CQLException.class)
    public void idUsingIntegerValues() throws Exception {
        String strId1 = "1";
        String strId2 = "2";
        String strId3 = "3";
        CQL2.toFilter((String)"IN (1,2, 3)");
    }

    @Test(expected=CQLException.class)
    public void IdUsingDateValues() throws Exception {
        String date1 = "2010-01-01";
        String date2 = "2010-02-02";
        String date3 = "2010-03-03";
        CQL2.toFilter((String)"IN ('2010-01-01','2010-02-02', '2010-03-03')");
    }

    @Test(expected=CQLException.class)
    public void IdUsingTimeStamp() throws Exception {
        String timeStamp1 = "2010-01-01 00:01:01";
        String timeStamp2 = "2010-02-02 00:01:01";
        String timeStamp3 = "2010-03-03 00:01:01";
        CQL2.toFilter((String)"IN ('2010-01-01 00:01:01','2010-02-02 00:01:01', '2010-03-03 00:01:01')");
    }

    @Test(expected=CQLException.class)
    public void filterIdSimple() throws Exception {
        CQL2.toFilter((String)"IN states.1");
    }
}

