/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql_2;

import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.referencing.FactoryException;
import org.geotools.filter.text.cql2.CQLException;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;

public class CQL2GeoOperationTest {
    @Test
    public void disjoint() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_DISJOINT(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Disjoint was expected", (boolean)(resultFilter instanceof Disjoint));
    }

    @Test
    public void Intersects() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_INTERSECTS(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
        resultFilter = CQL2.toFilter((String)"S_INTERSECTS(GEOLOC, POINT(615358 312185))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test(expected=CQLException.class)
    public void invalidGeoOperation() throws CQLException {
        CQL2.toFilter((String)"S_INTERSECT(ATTR1, POINT(1 2))");
    }

    @Test
    public void touches() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_TOUCHES(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Touches was expected", (boolean)(resultFilter instanceof Touches));
    }

    @Test
    public void crosses() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_CROSSES(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Crosses was expected", (boolean)(resultFilter instanceof Crosses));
    }

    @Test
    public void contains() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_CONTAINS(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Contains was expected", (boolean)(resultFilter instanceof Contains));
    }

    @Test
    public void overlaps() throws Exception {
        Filter resultFilter = CQL2.toFilter((String)"S_OVERLAPS(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Overlaps was expected", (boolean)(resultFilter instanceof Overlaps));
    }

    @Test
    public void equals() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_EQUALS(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"not an instance of Equals", (boolean)(resultFilter instanceof Equals));
    }

    @Test
    public void within() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_WITHIN(ATTR1, POLYGON((1 2, 1 10, 5 10, 1 2)) )");
        Assert.assertTrue((String)"Within was expected", (boolean)(resultFilter instanceof Within));
    }

    @Test(expected=CQLException.class)
    public void relate() throws CQLException {
        CQL2.toFilter((String)"RELATE(the_geom, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), T*****FF*)");
    }

    @Test(expected=CQLException.class)
    public void bbox() throws CQLException, FactoryException {
        CQL2.toFilter((String)"BBOX(ATTR1, 10.0,20.0,30.0,40.0)");
    }

    @Test
    public void IntersectsWithTwoLiteral() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_INTERSECTS(POLYGON((1 2, 2 2, 2 3, 1 2)), POINT(1 2))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test
    public void functionAsFirstArgument() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_INTERSECTS(centroid(the_geom), POINT(1 2))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test
    public void functionAsSecondArgument() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_INTERSECTS(the_geom, buffer(POINT(1 2),10))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
        resultFilter = CQL2.toFilter((String)"S_INTERSECTS(the_geom, buffer(the_geom,10))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test
    public void functionAsFirstAndSecondArgument() throws CQLException {
        Filter resultFilter = CQL2.toFilter((String)"S_INTERSECTS(centroid(the_geom), buffer(POINT(1 2) ,10))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test(expected=CQLException.class)
    public void intersectsWithReferencedGeometry() throws CQLException, FactoryException {
        CQL2.toFilter((String)"S_INTERSECTS(the_geom, SRID=4326;POINT(1 2))");
    }

    @Test
    public void testIntersectsEnvelope() throws CQLException {
        Filter filter = CQL2.toFilter((String)"S_INTERSECTS(geom, BBOX(10, 10, 40, 40))");
        Intersects intersects = (Intersects)filter;
        PropertyName pn = (PropertyName)intersects.getExpression1();
        Assert.assertEquals((Object)"geom", (Object)pn.getPropertyName());
        Polygon polygon = (Polygon)intersects.getExpression2().evaluate(null, Polygon.class);
        Assert.assertNotNull((Object)polygon);
        Assert.assertTrue((boolean)polygon.isRectangle());
        Assert.assertEquals((Object)new Envelope(10.0, 40.0, 10.0, 40.0), (Object)polygon.getEnvelopeInternal());
    }
}

