/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql_2;

import java.util.TimeZone;
import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQLComparisonPredicateTest;
import org.junit.Assert;
import org.junit.Test;

public class CQL2ComparisonPredicateTest
extends ECQLComparisonPredicateTest {
    public void deprecatedPredicate() {
        this.ensureFail("POP_RANK eq 6");
        this.ensureFail("POP_RANK neq 6");
        this.ensureFail("POP_RANK lte 6");
        this.ensureFail("! (POP_RANK = 6)");
        this.ensureFail("POP_RANK eq 6");
        this.ensureFail("POP_RANK == 6");
        this.ensureFail("POP_RANK lte 6");
        this.ensureFail("POP_RANK gte 6");
        this.ensureFail("POP_RANK lt 6");
        this.ensureFail("POP_RANK gt 6");
        this.ensureFail("! (POP_RANK == 6)");
        this.ensureFail("POP_RANK neq 6");
        this.ensureFail("A > 2 && B < 1");
    }

    @Test
    public void bracketRoundtripFilter() {
        this.ensureFail("ATTR1 > [[1 + 2] / 3]");
        this.ensureFail("[[[ X < 4 ] AND NOT [ Y < 4 ]] AND [ Z < 4 ]]");
        this.ensureFail("[X<4 AND Y<4 ] OR Z<4");
        this.ensureFail("[([ X < 4 ] AND NOT [ Y < 4 ]) AND [ Z < 4 ]]");
    }

    @Test
    public void dateLiteral() throws Exception {
        Filter f = this.parseFilter("X = DATE('2012-02-01')");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 0, 0, 0, 0, TimeZone.getDefault()));
    }

    @Test
    public void dateLiteralTimeZoneUTC() throws Exception {
        Filter f = this.parseFilter("X = DATE('2012-02-01Z')");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 0, 0, 0, 0, TimeZone.getTimeZone("GMT")));
    }

    @Test
    public void dateLiteralTimeZonePlusMinus() throws Exception {
        Filter f = this.parseFilter("X = DATE('2012-02-01-0800')");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 0, 0, 0, 0, TimeZone.getTimeZone("GMT-8:00")));
        f = this.parseFilter("X = DATE('2012-02-01+08:00')");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 0, 0, 0, 0, TimeZone.getTimeZone("GMT+8:00")));
    }

    @Test
    public void dateTimeLiteral() throws Exception {
        Filter f = this.parseFilter("X = TIMESTAMP('2012-02-01T12:10:13Z')");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 0, TimeZone.getTimeZone("UTC")));
    }

    @Test
    public void dateTimeLiteralMilliseconds() throws Exception {
        Filter f = this.parseFilter("X = TIMESTAMP('2012-02-01T12:10:13.123Z')");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 123, TimeZone.getTimeZone("UTC")));
    }

    @Test
    public void dateTimeLiteralTimeZoneUTC() throws Exception {
        Filter f = this.parseFilter("X = TIMESTAMP('2012-02-01T12:10:13.123Z')");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 123, TimeZone.getTimeZone("GMT")));
    }

    @Test
    public void dateTimeLiteralTimeZonePlusMinus() throws Exception {
        Filter f = this.parseFilter("X = TIMESTAMP('2012-02-01T12:10:13.123-0800')");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 123, TimeZone.getTimeZone("GMT-8:00")));
        f = this.parseFilter("X = TIMESTAMP('2012-02-01T12:10:13+08:00')");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 0, TimeZone.getTimeZone("GMT+8:00")));
    }

    private void ensureFail(String filter) {
        try {
            Filter parsed = this.parseFilter(filter);
            Assert.fail((String)("Filter should not have been parsed: " + filter + " but got instead: " + parsed));
        }
        catch (CQLException cQLException) {
            // empty catch block
        }
    }

    protected Filter parseFilter(String filter) throws CQLException {
        return CQL2.toFilter((String)filter);
    }
}

