/*
 * Decompiled with CFR 0.152.
 */
package org.geootols.filter.text.cql_2;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import org.geootols.filter.text.cql_2.GeometryCollectionBuilder;
import org.geootols.filter.text.cql_2.LineStringBuilder;
import org.geootols.filter.text.cql_2.MultiLineStringBuilder;
import org.geootols.filter.text.cql_2.MultiPointBuilder;
import org.geootols.filter.text.cql_2.MultiPolygonBuilder;
import org.geootols.filter.text.cql_2.PointBuilder;
import org.geootols.filter.text.cql_2.PolygonBuilder;
import org.geootols.filter.text.cql_2.SpatialOperationBuilder;
import org.geotools.filter.text.commons.AbstractFilterBuilder;
import org.geotools.filter.text.commons.BuildResultStack;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.commons.PeriodNode;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.TEquals;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;

final class CQL2FilterBuilder
extends AbstractFilterBuilder {
    public CQL2FilterBuilder(String cql2Source, FilterFactory filterFactory) {
        super(cql2Source, filterFactory);
    }

    public Literal bulidNegativeNumber() throws CQLException {
        Literal literal = this.getResultStack().popLiteral();
        String strNumber = "-" + String.valueOf(literal.getValue());
        Object value = literal.getValue();
        Number number = null;
        if (value instanceof Double) {
            number = Double.parseDouble(strNumber);
        } else if (value instanceof Float) {
            number = Float.valueOf(Float.parseFloat(strNumber));
        } else if (value instanceof Integer) {
            number = Integer.parseInt(strNumber);
        } else if (value instanceof Long) {
            number = Long.parseLong(strNumber);
        } else assert (false) : "Number instnce is expected";
        Literal signedNumber = this.getFilterFactory().literal((Object)number);
        return signedNumber;
    }

    public Or buildInPredicate(int nodeExpression) throws CQLException {
        Result result;
        int node;
        LinkedList<Expression> exprList = new LinkedList<Expression>();
        while (!this.getResultStack().empty() && (node = (result = this.getResultStack().peek()).getNodeType()) == nodeExpression) {
            this.getResultStack().popResult();
            Expression expr = this.getResultStack().popExpression();
            exprList.add(expr);
        }
        assert (!exprList.isEmpty()) : "must have one or more expressions";
        Expression leftHandExpr = this.getResultStack().popExpression();
        LinkedList<PropertyIsEqualTo> filterList = new LinkedList<PropertyIsEqualTo>();
        for (Expression expression : exprList) {
            PropertyIsEqualTo eq = this.getFilterFactory().equals(leftHandExpr, expression);
            filterList.add(eq);
        }
        Collections.reverse(filterList);
        Or orFilter = this.getFilterFactory().or(filterList);
        return orFilter;
    }

    public Coordinate buildCoordinate() throws CQLException {
        double y = this.getResultStack().popDoubleValue();
        double x = this.getResultStack().popDoubleValue();
        Coordinate coordinate = new Coordinate(x, y);
        return coordinate;
    }

    public Point buildPointText() throws CQLException {
        PointBuilder builder = new PointBuilder(this.getStatement(), this.getResultStack());
        Point point = (Point)builder.build();
        return point;
    }

    public LineString buildLineString(int pointNode) throws CQLException {
        LineStringBuilder builder = new LineStringBuilder(this.getStatement(), this.getResultStack());
        LineString line = (LineString)builder.build(pointNode);
        return line;
    }

    public Polygon buildPolygon(int linestringNode) throws CQLException {
        PolygonBuilder builder = new PolygonBuilder(this.getStatement(), this.getResultStack());
        Polygon polygon = (Polygon)builder.build(linestringNode);
        return polygon;
    }

    public MultiPoint buildMultiPoint(int pointNode) throws CQLException {
        MultiPointBuilder builder = new MultiPointBuilder(this.getStatement(), this.getResultStack());
        MultiPoint mp = (MultiPoint)builder.build(pointNode);
        return mp;
    }

    public MultiLineString buildMultiLineString(int linestringtextNode) throws CQLException {
        MultiLineStringBuilder builder = new MultiLineStringBuilder(this.getStatement(), this.getResultStack());
        MultiLineString ml = (MultiLineString)builder.build(linestringtextNode);
        return ml;
    }

    public MultiPolygon buildMultiPolygon(int polygontextNode) throws CQLException {
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.getStatement(), this.getResultStack());
        MultiPolygon mp = (MultiPolygon)builder.build(polygontextNode);
        return mp;
    }

    public GeometryCollection buildGeometryCollection(int jjtgeometryliteral) throws CQLException {
        GeometryCollectionBuilder builder = new GeometryCollectionBuilder(this.getStatement(), this.getResultStack());
        GeometryCollection gc = (GeometryCollection)builder.build(jjtgeometryliteral);
        return gc;
    }

    public Literal buildGeometry() throws CQLException {
        Geometry geometry = this.getResultStack().popGeometry();
        Literal literal = this.getFilterFactory().literal((Object)geometry);
        return literal;
    }

    public Literal buildGeometryLiteral() throws CQLException {
        Result result = this.getResultStack().popResult();
        return (Literal)result.getBuilt();
    }

    public Literal buildSimpleGeometryLiteral() throws CQLException {
        return this.getResultStack().popLiteral();
    }

    public BinarySpatialOperator buildSpatialEqualFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Equals filter = builder.buildEquals();
        return filter;
    }

    public BinarySpatialOperator buildSpatialDisjointFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Disjoint filter = builder.buildDisjoint();
        return filter;
    }

    public BinarySpatialOperator buildSpatialIntersectsFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Intersects filter = builder.buildIntersects();
        return filter;
    }

    public BinarySpatialOperator buildSpatialTouchesFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Touches filter = builder.buildTouches();
        return filter;
    }

    public BinarySpatialOperator buildSpatialCrossesFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Crosses filter = builder.buildCrosses();
        return filter;
    }

    public Literal buildPattern9IM() throws CQLException {
        Result resut = this.getResultStack().popResult();
        IToken token = resut.getToken();
        Literal built = (Literal)resut.getBuilt();
        String pattern = (String)built.getValue();
        if (pattern.length() != 9) {
            throw new CQLException("the pattern DE-9IM must have nine (9) characters", token, this.getStatement());
        }
        String patternUC = pattern.toUpperCase();
        char[] validFlags = new char[]{'T', 'F', '*', '0', '1', '2'};
        for (int i = 0; i < validFlags.length; ++i) {
            char character = patternUC.charAt(i);
            boolean found = false;
            for (char validFlag : validFlags) {
                if (validFlag != character) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new CQLException("the pattern DE-9IM must have only the following characters: T, F, *, 0, 1, 2", token, this.getStatement());
        }
        Literal patternExpr = this.getFilterFactory().literal((Object)pattern);
        return patternExpr;
    }

    public BinarySpatialOperator buildSpatialWithinFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Within filter = builder.buildWithin();
        return filter;
    }

    public BinarySpatialOperator buildSpatialContainsFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Contains filter = builder.buildContains();
        return filter;
    }

    public BinarySpatialOperator buildSpatialOverlapsFilter() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        Overlaps filter = builder.buildOverlaps();
        return filter;
    }

    public BBOX buildBBox() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        BBOX filter = builder.buildBBox();
        return filter;
    }

    public BBOX buildBBoxWithCRS() throws CQLException {
        SpatialOperationBuilder builder = new SpatialOperationBuilder(this.getResultStack(), this.getFilterFactory());
        BBOX filter = builder.buildBBoxWithCRS();
        return filter;
    }

    public Literal buildDateExpression(IToken token) throws CQLException {
        String date = this.unwrapDateFunction(token);
        return this.asLiteralDate(date);
    }

    private String unwrapDateFunction(IToken token) {
        String full = token.toString();
        int from = full.indexOf(39);
        int to = full.lastIndexOf(39);
        String date = full.substring(from + 1, to);
        return date;
    }

    public Before buildBeforePeriod() throws CQLException {
        return super.buildBeforePeriod();
    }

    public Literal buildDateTimeExpression(IToken token) throws CQLException {
        return this.asLiteralDateTime(this.unwrapDateFunction(token));
    }

    private Expression popTimeExpression() throws CQLException {
        Result result = this.getResultStack().popResult();
        Object built = result.getBuilt();
        if (built instanceof PeriodNode) {
            PeriodNode pn = (PeriodNode)built;
            DefaultPosition start = new DefaultPosition((Date)pn.getBeginning().evaluate(null, Date.class));
            DefaultPosition end = new DefaultPosition((Date)pn.getEnding().evaluate(null, Date.class));
            return this.filterFactory.literal((Object)new DefaultPeriod((Instant)new DefaultInstant((Position)start), (Instant)new DefaultInstant((Position)end)));
        }
        return (Expression)built;
    }

    public Before buildBeforeDate() throws CQLException {
        Object value;
        Expression ex2 = this.popTimeExpression();
        Expression ex1 = this.popTimeExpression();
        if (ex1 instanceof PropertyName && ex2 instanceof Literal && (value = ex2.evaluate(null)) instanceof Period) {
            return this.filterFactory.before(ex1, (Expression)this.filterFactory.literal((Object)this.getBeginDate((Period)value)));
        }
        return this.filterFactory.before(ex1, ex2);
    }

    private Date getBeginDate(Period value) {
        return value.getBeginning().getPosition().getDate();
    }

    private Date getEndDate(Period value) {
        return value.getEnding().getPosition().getDate();
    }

    public After buildAfterDate() throws CQLException {
        Object value;
        Expression ex2 = this.popTimeExpression();
        Expression ex1 = this.popTimeExpression();
        if (ex1 instanceof PropertyName && ex2 instanceof Literal && (value = ex2.evaluate(null)) instanceof Period) {
            return this.filterFactory.after(ex1, (Expression)this.filterFactory.literal((Object)this.getEndDate((Period)value)));
        }
        return this.filterFactory.after(ex1, ex2);
    }

    public TEquals buildTEquals() throws CQLException {
        Expression right = this.popTimeExpression();
        Expression left = this.popTimeExpression();
        return this.filterFactory.tequals(left, right);
    }

    public Literal buildEnvelope(IToken token) throws CQLException {
        String source = this.scanExpression(token);
        String ENVELOPE_TYPE = "ENVELOPE";
        int cur = source.indexOf("ENVELOPE");
        cur = cur + "ENVELOPE".length() + 1;
        String argument = source.substring(cur, source.length() - 1);
        String comma = ",";
        cur = 0;
        int end = argument.indexOf(",", cur);
        String west = argument.substring(cur, end);
        double minX = Double.parseDouble(west);
        cur = end + 1;
        end = argument.indexOf(",", cur);
        String south = argument.substring(cur, end);
        double minY = Double.parseDouble(south);
        cur = end + 1;
        end = argument.indexOf(",", cur);
        String east = argument.substring(cur, end);
        double maxX = Double.parseDouble(east);
        cur = end + 1;
        String north = argument.substring(cur);
        double maxY = Double.parseDouble(north);
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), new Coordinate(minX, minY)};
        LinearRing shell = gf.createLinearRing(coords);
        Polygon bbox = gf.createPolygon(shell, null);
        bbox.setUserData((Object)DefaultGeographicCRS.WGS84);
        Literal literal = this.filterFactory.literal((Object)bbox);
        BuildResultStack stack = this.getResultStack();
        stack.popResult();
        stack.popResult();
        stack.popResult();
        stack.popResult();
        return literal;
    }
}

