/*
 * Decompiled with CFR 0.152.
 */
package org.geootols.filter.text.cql_2;

import org.geootols.filter.text.cql_2.CQL2CompilerFactory;
import org.geootols.filter.text.cql_2.CQL2ExpressionToText;
import org.geootols.filter.text.cql_2.FilterToCQL2;
import org.geotools.filter.text.commons.AbstractCompilerFactory;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.cql2.CQLException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

public class CQL2 {
    private CQL2() {
    }

    public static Filter toFilter(String cql2Predicate) throws CQLException {
        Filter filter = CQL2.toFilter(cql2Predicate, null);
        return filter;
    }

    public static Filter toFilter(String cql2Predicate, FilterFactory filterFactory) throws CQLException {
        CQL2CompilerFactory compilerFactory = new CQL2CompilerFactory();
        Filter result = CompilerUtil.parseFilter((String)cql2Predicate, (AbstractCompilerFactory)compilerFactory, (FilterFactory)filterFactory);
        return result;
    }

    public static Expression toExpression(String cql2Expression) throws CQLException {
        return CQL2.toExpression(cql2Expression, null);
    }

    public static Expression toExpression(String cql2Expression, FilterFactory filterFactory) throws CQLException {
        CQL2CompilerFactory compilerFactory = new CQL2CompilerFactory();
        Expression expression = CompilerUtil.parseExpression((String)cql2Expression, (AbstractCompilerFactory)compilerFactory, (FilterFactory)filterFactory);
        return expression;
    }

    public static String toCQL2(Filter filter) {
        FilterToCQL2 toCQL = new FilterToCQL2();
        StringBuilder output = (StringBuilder)filter.accept((FilterVisitor)toCQL, (Object)new StringBuilder());
        return output.toString();
    }

    public static String toCQL2(Expression expression) {
        CQL2ExpressionToText toCQL2 = new CQL2ExpressionToText();
        StringBuilder output = (StringBuilder)expression.accept((ExpressionVisitor)toCQL2, (Object)new StringBuilder());
        return output.toString();
    }
}

