/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cqljson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cqljson.CQLJsonCompiler;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;

final class CQLJsonFilterBuilder {
    private static final String WC_MULTI = "%";
    private static final String WC_SINGLE = "_";
    private static final String ESCAPE = "\\";
    private final FilterFactory filterFactory;
    private static final List<String> ARITHMETIC_OPERATORS = Arrays.asList("+", "-", "*", "/");

    public CQLJsonFilterBuilder(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    private String toCompareString(JsonNode jsonNode) throws CQLException {
        if (jsonNode != null && jsonNode.getNodeType() == JsonNodeType.STRING) {
            return jsonNode.textValue();
        }
        throw new CQLException("Expected string but got null or other type.");
    }

    private Expression toCharacterExpression(JsonNode jsonNode) throws CQLException, IOException, ParseException {
        if (jsonNode != null && jsonNode.getNodeType() == JsonNodeType.STRING) {
            String stringExpression = jsonNode.textValue();
            return this.filterFactory.literal((Object)stringExpression);
        }
        if (jsonNode != null && jsonNode.getNodeType() == JsonNodeType.OBJECT) {
            if (this.isProperty(jsonNode)) {
                return this.getPropertyName(jsonNode);
            }
            if (this.isFunction(jsonNode)) {
                return this.getFunction(jsonNode);
            }
            throw new CQLException("Expected character expression but got null or other type.");
        }
        throw new CQLException("Expected character expression but got null or other type.");
    }

    private Function getFunction(JsonNode node) throws CQLException, IOException, ParseException {
        if (this.isFunction(node)) {
            ObjectNode function = (ObjectNode)node.get("function");
            String functionName = function.get("name").textValue();
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            ArrayNode args = (ArrayNode)function.get("args");
            for (JsonNode argNode : args) {
                expressions.add(this.getExpression(argNode));
            }
            return this.filterFactory.function(functionName, expressions.toArray(new Expression[0]));
        }
        throw new CQLException("Expected function but got null or other type.");
    }

    public Expression getExpression(JsonNode node) throws CQLException, IOException, ParseException {
        Literal expression = null;
        ObjectMapper mapper = new ObjectMapper();
        if (node.getNodeType() != JsonNodeType.OBJECT) {
            expression = this.filterFactory.literal(mapper.convertValue((Object)node, Object.class));
        } else {
            if (node.getNodeType() == JsonNodeType.ARRAY) {
                throw new CQLException("Geotools filters do not have an array type");
            }
            if (this.isFunction(node)) {
                expression = this.getFunction(node);
            } else if (this.isProperty(node)) {
                expression = this.getPropertyName(node);
            } else if (this.isGeometry(node)) {
                expression = this.getGeometry(node);
            } else if (this.isTime(node)) {
                expression = this.getTime(node);
            } else if (this.isArithmetic(node)) {
                expression = this.getArithmetic(node);
            } else if (this.isInterval(node)) {
                expression = this.filterFactory.literal(this.getInterval(node));
            }
        }
        return expression;
    }

    private List<Expression> getInterval(JsonNode node) throws CQLException, IOException, ParseException {
        ArrayList<Expression> out = new ArrayList<Expression>();
        Expression expression1 = this.getExpression(node.get("interval").get(0));
        Expression expression2 = this.getExpression(node.get("interval").get(0));
        out.add(expression1);
        out.add(expression2);
        return out;
    }

    private Expression getArithmetic(JsonNode node) throws CQLException, IOException, ParseException {
        String operator = node.get("op").textValue();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        ArrayNode args = (ArrayNode)node.get("args");
        for (JsonNode argNode : args) {
            expressions.add(this.getExpression(argNode));
        }
        if (expressions.size() != 2) {
            throw new CQLException("Was expecting two arguments for arithmetic operator: " + operator);
        }
        switch (operator) {
            case "+": {
                return this.filterFactory.add((Expression)expressions.get(0), (Expression)expressions.get(1));
            }
            case "-": {
                return this.filterFactory.subtract((Expression)expressions.get(0), (Expression)expressions.get(1));
            }
            case "*": {
                return this.filterFactory.multiply((Expression)expressions.get(0), (Expression)expressions.get(1));
            }
            case "/": {
                return this.filterFactory.divide((Expression)expressions.get(0), (Expression)expressions.get(1));
            }
            case "%": {
                return this.filterFactory.function("IEEEremainder", new Expression[]{(Expression)expressions.get(0), (Expression)expressions.get(1)});
            }
            case "div": {
                return this.filterFactory.function("div", new Expression[]{(Expression)expressions.get(0), (Expression)expressions.get(1)});
            }
            case "^": {
                return this.filterFactory.function("pow", new Expression[]{(Expression)expressions.get(0), (Expression)expressions.get(1)});
            }
        }
        throw new CQLException("Unknown arithmetic operator: " + operator);
    }

    private Expression getGeometry(JsonNode node) throws ParseException {
        Geometry geom = null;
        if (node.get("bbox") != null) {
            ArrayNode bbox = (ArrayNode)node.get("bbox");
            double minX = bbox.get(0).doubleValue();
            double minY = bbox.get(1).doubleValue();
            double maxX = bbox.get(2).doubleValue();
            double maxY = bbox.get(3).doubleValue();
            if (CQLJsonFilterBuilder.isWrappingDateline(minX, maxX)) {
                Envelope bbox1 = new Envelope(minX, 180.0, minY, maxY);
                Envelope bbox2 = new Envelope(-180.0, maxX, minY, maxY);
                Polygon g1 = JTS.toGeometry((Envelope)bbox1);
                Polygon g2 = JTS.toGeometry((Envelope)bbox2);
                MultiPolygon multiPolygon = g1.getFactory().createMultiPolygon(new Polygon[]{g1, g2});
                return this.filterFactory.literal((Object)multiPolygon);
            }
            Envelope box = new Envelope(minX, maxX, minY, maxY);
            Polygon g = JTS.toGeometry((Envelope)box);
            return this.filterFactory.literal((Object)g);
        }
        geom = GeoJSONReader.parseGeometry((String)node.toString());
        return this.filterFactory.literal((Object)geom);
    }

    static boolean isWrappingDateline(double minLon, double maxLon) {
        return minLon > maxLon && CQLJsonFilterBuilder.validLongitude(minLon) && CQLJsonFilterBuilder.validLongitude(maxLon);
    }

    static boolean validLongitude(double x) {
        return x >= -180.0 && x <= 180.0;
    }

    private boolean isArithmetic(JsonNode node) {
        boolean out = false;
        if (node != null && node.getNodeType() == JsonNodeType.OBJECT && node.get("op") != null && ARITHMETIC_OPERATORS.contains(node.get("op").textValue())) {
            return true;
        }
        return out;
    }

    private boolean isInterval(JsonNode node) {
        boolean out = false;
        if (node != null && node.getNodeType() == JsonNodeType.OBJECT && node.get("interval") != null) {
            return true;
        }
        return out;
    }

    private boolean isTime(JsonNode node) {
        boolean out = false;
        if (node.get("date") != null) {
            return true;
        }
        if (node.get("timestamp") != null) {
            return true;
        }
        return out;
    }

    private Expression getTime(JsonNode node) throws CQLException {
        if (node != null && node.getNodeType() == JsonNodeType.OBJECT) {
            if (node.get("date") != null) {
                LocalDate date = LocalDate.parse(node.get("date").textValue());
                Date sqlDate = Date.valueOf(date);
                return this.filterFactory.literal((Object)sqlDate);
            }
            if (node.get("timestamp") != null) {
                java.util.Date date = java.util.Date.from(Instant.parse(node.get("timestamp").textValue()));
                return this.filterFactory.literal((Object)date);
            }
        }
        throw new CQLException("date, or time type not found");
    }

    private boolean isGeometry(JsonNode node) {
        boolean out = false;
        if (node != null && node.getNodeType() == JsonNodeType.OBJECT) {
            if (node.get("bbox") != null) {
                return true;
            }
            if (node.get("coordinates") != null) {
                return true;
            }
            if (node.get("geometries") != null) {
                return true;
            }
        }
        return out;
    }

    private boolean isFunction(JsonNode node) {
        boolean out = false;
        if (node != null && node.getNodeType() == JsonNodeType.OBJECT && node.get("function") != null) {
            return true;
        }
        return out;
    }

    private boolean isProperty(JsonNode node) {
        boolean out = false;
        if (node != null && node.get("property") != null) {
            return true;
        }
        return out;
    }

    private PropertyName getPropertyName(JsonNode node) throws CQLException {
        if (node != null && node.get("property") != null) {
            return this.filterFactory.property(node.get("property").textValue());
        }
        throw new CQLException("Expected property but got null or other type.");
    }

    public Filter convertLike(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression characterExpression = this.toCharacterExpression(args.get(0));
        String stringLiteral = this.toCompareString(args.get(1));
        return this.filterFactory.like(characterExpression, stringLiteral, WC_MULTI, WC_SINGLE, ESCAPE);
    }

    public Filter convertEquals(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.equals(expression1, expression2);
    }

    public Filter convertEquals(Expression expression1, Expression expression2) {
        return this.filterFactory.equals(expression1, expression2);
    }

    public Filter convertNotEquals(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.notEqual(expression1, expression2);
    }

    public Filter convertGreaterThan(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.greater(expression1, expression2);
    }

    public Filter convertLessThan(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.less(expression1, expression2);
    }

    public Filter convertGreaterThanOrEq(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.greaterOrEqual(expression1, expression2);
    }

    public Filter convertLessThanOrEq(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.lessOrEqual(expression1, expression2);
    }

    public Filter convertBetween(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        Expression expression3 = this.getExpression(args.get(2));
        return this.filterFactory.between(expression1, expression2, expression3);
    }

    public Filter convertIsNull(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        return this.filterFactory.isNull(expression1);
    }

    public Filter convertOr(CQLJsonCompiler cqlJsonCompiler, ArrayNode args) throws CQLException, IOException, ParseException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (JsonNode arg : args) {
            filters.add(cqlJsonCompiler.convertToFilter(arg));
        }
        return this.filterFactory.or(filters);
    }

    public Filter convertOr(List<Filter> filters) {
        return this.filterFactory.or(filters);
    }

    public Filter convertAnd(CQLJsonCompiler cqlJsonCompiler, ArrayNode args) throws CQLException, IOException, ParseException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (JsonNode arg : args) {
            filters.add(cqlJsonCompiler.convertToFilter(arg));
        }
        return this.filterFactory.and(filters);
    }

    public Filter convertAnd(Filter filter1, Filter filter2) {
        return this.filterFactory.and(filter1, filter2);
    }

    public Filter convertIn(ArrayNode args) throws CQLException, IOException, ParseException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Expression expression1 = this.getExpression(args.get(0));
        ArrayNode inArray = (ArrayNode)args.get(1);
        for (JsonNode inElement : inArray) {
            Expression expression2 = this.getExpression(inElement);
            filters.add(this.convertEquals(expression1, expression2));
        }
        return this.convertOr(filters);
    }

    public Filter convertContains(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.contains(expression1, expression2);
    }

    public Filter convertCrosses(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.crosses(expression1, expression2);
    }

    public Filter convertDisjoint(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.disjoint(expression1, expression2);
    }

    public Filter convertSEquals(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.equal(expression1, expression2);
    }

    public Filter convertIntersects(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.intersects(expression1, expression2);
    }

    public Filter convertOverlaps(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.overlaps(expression1, expression2);
    }

    public Filter convertTouches(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.touches(expression1, expression2);
    }

    public Filter convertWithin(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.within(expression1, expression2);
    }

    public Filter convertNot(CQLJsonCompiler cqlJsonCompiler, ArrayNode args) throws CQLException, IOException, ParseException {
        Filter filter = cqlJsonCompiler.convertToFilter(args.get(0));
        return this.filterFactory.not(filter);
    }

    public Filter convertAfter(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.after(expression1, expression2);
    }

    public Filter convertAfter(Expression expression1, Expression expression2) {
        return this.filterFactory.after(expression1, expression2);
    }

    public Filter convertBefore(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.before(expression1, expression2);
    }

    public Filter convertBefore(Expression expression1, Expression expression2) {
        return this.filterFactory.before(expression1, expression2);
    }

    public Filter convertTDisjoint(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        Filter before = this.convertBefore(expression1, expression2);
        Filter after = this.convertAfter(expression1, expression2);
        return this.convertAnd(before, after);
    }

    public Filter convertDuring(ArrayNode args) throws CQLException, IOException, ParseException {
        Expression expression1 = this.getExpression(args.get(0));
        Expression expression2 = this.getExpression(args.get(1));
        return this.filterFactory.during(expression1, expression2);
    }

    public Filter convertFinishedBy(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Finished by not supported by GeoTools filters");
    }

    public Filter convertFinishing(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Finishing not supported by GeoTools filters");
    }

    public Filter convertTIntersects(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("TIntersects not supported by GeoTools filters");
    }

    public Filter convertMeets(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Meets not supported by GeoTools filters");
    }

    public Filter convertMetBy(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Met by not supported by GeoTools filters");
    }

    public Filter convertOverlappedBy(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Overlapped by not supported by GeoTools filters");
    }

    public Filter convertTOverlaps(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Time Overlaps not supported by GeoTools filters");
    }

    public Filter convertStartedBy(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Started by not supported by GeoTools filters");
    }

    public Filter convertStarts(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Starts not supported by GeoTools filters");
    }

    public Filter convertAContainedBy(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Array Contained By not supported by GeoTools filters");
    }

    public Filter convertAContaining(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Array Containing not supported by GeoTools filters");
    }

    public Filter convertArrayEquals(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Array Equals not supported by GeoTools filters");
    }

    public Filter convertAOverlaps(ArrayNode args) throws CQLException, IOException, ParseException {
        throw new CQLException("Array Overlaps not supported by GeoTools filters");
    }
}

