/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterCQLSample;
import org.junit.Assert;
import org.junit.Test;

public class CQLExistenceTest {
    protected final Language language;

    public CQLExistenceTest() {
        this(Language.CQL);
    }

    protected CQLExistenceTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void attributeDoesNotExist() throws CQLException {
        Filter resultFilter = this.parseFilter("ATTR1 DOES-NOT-EXIST");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample("ATTR1 DOES-NOT-EXIST");
        Assert.assertEquals((Object)expected, (Object)resultFilter);
    }

    protected Filter parseFilter(String attributeNameDoesNotExist) throws CQLException {
        return CompilerUtil.parseFilter((Language)this.language, (String)attributeNameDoesNotExist);
    }

    @Test
    public void attributeExist() throws Exception {
        Filter resultFilter = this.parseFilter("ATTR1 EXISTS");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Assert.assertTrue((boolean)(resultFilter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eqToResultFilter = (PropertyIsEqualTo)resultFilter;
        Filter expected = FilterCQLSample.getSample("ATTR1 EXISTS");
        Assert.assertEquals((Object)expected, (Object)eqToResultFilter);
        Assert.assertNotNull((String)"implementation of function was expected", (Object)eqToResultFilter.getExpression1());
    }
}

